/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.actions;

import com.eviware.soapui.config.RestParametersConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.RestURIParserImpl;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.rest.support.XmlBeansRestParamsTestPropertyHolder;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.support.ModelItemNamer;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import java.net.MalformedURLException;
import org.apache.commons.lang.ArrayUtils;

public class RestServiceBuilder {
    public void createRestService(WsdlProject project, String URI2) throws MalformedURLException {
        if (StringUtils.isNullOrEmpty(URI2)) {
            return;
        }
        RestResource restResource = this.createResource(ModelCreationStrategy.CREATE_NEW_MODEL, project, URI2);
        RestRequest restRequest = this.addNewRequest(this.addNewMethod(ModelCreationStrategy.CREATE_NEW_MODEL, restResource, RestRequestInterface.HttpMethod.GET));
        this.copyParameters(this.extractParams(URI2), restResource.getParams());
        UISupport.select(restRequest);
        UISupport.showDesktopPanel(restRequest);
    }

    public RestRequest createRestServiceHeadlessFromUri(WsdlProject project, RequestInfo requestInfo, ModelCreationStrategy methodReuseStrategy) throws MalformedURLException {
        RestResource restResource = this.createResource(ModelCreationStrategy.REUSE_MODEL, project, requestInfo.getUri());
        RestMethod restMethod = this.addNewMethod(methodReuseStrategy, restResource, requestInfo.getRequestMethod());
        RestRequest restRequest = this.addNewRequest(restMethod);
        this.copyParametersWithDefaultsOnResource(this.extractParams(requestInfo.getUri()), restMethod.getParams(), restRequest.getParams());
        return restRequest;
    }

    protected RestParamsPropertyHolder extractParams(String URI2) {
        XmlBeansRestParamsTestPropertyHolder params = new XmlBeansRestParamsTestPropertyHolder(null, RestParametersConfig.Factory.newInstance());
        this.extractAndFillParameters(URI2, params);
        return params;
    }

    protected RestResource createResource(ModelCreationStrategy creationStrategy, WsdlProject project, String URI2) throws MalformedURLException {
        RestResource existingResource;
        Interface existingInterface;
        RestURIParserImpl restURIParser = new RestURIParserImpl(URI2);
        String resourcePath = restURIParser.getResourcePath();
        String host = restURIParser.getEndpoint();
        RestService restService = null;
        if (creationStrategy == ModelCreationStrategy.REUSE_MODEL && (existingInterface = project.getInterfaceByName(host)) instanceof RestService && ArrayUtils.contains((Object[])((AbstractInterface)existingInterface).getEndpoints(), (Object)host)) {
            restService = (RestService)existingInterface;
        }
        if (restService == null) {
            restService = (RestService)project.addNewInterface(host, "rest");
            restService.addEndpoint(restURIParser.getEndpoint());
        }
        if (creationStrategy == ModelCreationStrategy.REUSE_MODEL && (existingResource = restService.getResourceByFullPath(RestResource.removeMatrixParams(resourcePath))) != null) {
            return existingResource;
        }
        return restService.addNewResource(restURIParser.getResourceName(), resourcePath);
    }

    protected void extractAndFillParameters(String URI2, RestParamsPropertyHolder params) {
        RestUtils.extractParams(URI2, params, false, RestUtils.TemplateExtractionOption.EXTRACT_TEMPLATE_PARAMETERS);
    }

    protected void copyParameters(RestParamsPropertyHolder srcParams, RestParamsPropertyHolder destinationParams) {
        for (int i = 0; i < srcParams.size(); ++i) {
            RestParamProperty prop = srcParams.getPropertyAt(i);
            destinationParams.addParameter(prop);
        }
    }

    protected void copyParametersWithDefaultsOnResource(RestParamsPropertyHolder srcParams, RestParamsPropertyHolder resourceParams, RestParamsPropertyHolder requestParams) {
        for (int i = 0; i < srcParams.size(); ++i) {
            RestParamProperty prop = srcParams.getPropertyAt(i);
            String value = prop.getValue();
            prop.setValue("");
            prop.setDefaultValue("");
            resourceParams.addParameter(prop);
            requestParams.getProperty(prop.getName()).setValue(value);
        }
    }

    protected RestMethod addNewMethod(ModelCreationStrategy creationStrategy, RestResource restResource, RestRequestInterface.HttpMethod requestMethod) {
        RestMethod restMethod2;
        if (creationStrategy == ModelCreationStrategy.REUSE_MODEL) {
            for (RestMethod restMethod2 : restResource.getRestMethodList()) {
                if (restMethod2.getMethod() != requestMethod) continue;
                return restMethod2;
            }
        }
        String methodName = ModelItemNamer.createName(restResource.getName(), restResource.getRestMethodList());
        restMethod2 = restResource.addNewMethod(methodName);
        restMethod2.setMethod(requestMethod);
        return restMethod2;
    }

    protected RestRequest addNewRequest(RestMethod restMethod) {
        return restMethod.addNewRequest("Request " + (restMethod.getRequestCount() + 1));
    }

    public static class RequestInfo {
        private final String uri;
        private final RestRequestInterface.HttpMethod requestMethod;

        public RequestInfo(String uri, RestRequestInterface.HttpMethod requestMethod) {
            this.uri = uri;
            this.requestMethod = requestMethod;
        }

        public String getUri() {
            return this.uri;
        }

        public RestRequestInterface.HttpMethod getRequestMethod() {
            return this.requestMethod;
        }
    }

    public static enum ModelCreationStrategy {
        CREATE_NEW_MODEL,
        REUSE_MODEL;

    }
}

