/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SoapuiWorkspaceDocumentConfig;
import com.eviware.soapui.config.WorkspaceProjectConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.project.ProjectFactoryRegistry;
import com.eviware.soapui.model.project.SaveStatus;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.model.workspace.WorkspaceListener;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveDialog;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class WorkspaceImpl
extends AbstractModelItem
implements Workspace {
    private static final Logger log = Logger.getLogger(WorkspaceImpl.class);
    public static final MessageSupport messages = MessageSupport.getMessages(WorkspaceImpl.class);
    private List<Project> projectList = new ArrayList<Project>();
    private SoapuiWorkspaceDocumentConfig workspaceConfig;
    private String path = null;
    private Set<WorkspaceListener> listeners = new HashSet<WorkspaceListener>();
    private ImageIcon workspaceIcon;
    private XmlBeansSettingsImpl settings;
    private StringToStringMap projectOptions;
    private ResolveDialog resolver;

    public WorkspaceImpl(String path, StringToStringMap projectOptions) throws XmlException, IOException {
        this.projectOptions = projectOptions == null ? new StringToStringMap() : projectOptions;
        File file = new File(path);
        this.path = file.getAbsolutePath();
        this.loadWorkspace(file);
        for (WorkspaceListener listener : SoapUI.getListenerRegistry().getListeners(WorkspaceListener.class)) {
            this.addWorkspaceListener(listener);
        }
    }

    @Override
    public void switchWorkspace(File file) throws SoapUIException {
        if (file.exists()) {
            try {
                SoapuiWorkspaceDocumentConfig.Factory.parse(file);
            }
            catch (Exception e) {
                throw new SoapUIException(messages.get("FailedToLoadWorkspaceException") + e.toString());
            }
        }
        this.fireWorkspaceSwitching();
        while (this.projectList.size() > 0) {
            Project project = this.projectList.remove(0);
            try {
                this.fireProjectRemoved(project);
            }
            finally {
                project.release();
            }
        }
        try {
            String oldName = this.getName();
            this.loadWorkspace(file);
            this.path = file.getAbsolutePath();
            for (Project project : this.projectList) {
                this.fireProjectAdded(project);
            }
            this.notifyPropertyChanged(ModelItem.NAME_PROPERTY, oldName, this.getName());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        this.fireWorkspaceSwitched();
    }

    public void loadWorkspace(File file) throws XmlException, IOException {
        if (file.exists()) {
            log.info((Object)messages.get("FailedToLoadWorkspaceFrom", file.getAbsolutePath()));
            this.workspaceConfig = SoapuiWorkspaceDocumentConfig.Factory.parse(file);
            if (this.workspaceConfig.getSoapuiWorkspace().getSettings() == null) {
                this.workspaceConfig.getSoapuiWorkspace().addNewSettings();
            }
            this.setPath(file.getAbsolutePath());
            this.settings = new XmlBeansSettingsImpl(this, SoapUI.getSettings(), this.workspaceConfig.getSoapuiWorkspace().getSettings());
            boolean closeOnStartup = this.getSettings().getBoolean(UISettings.CLOSE_PROJECTS);
            List<WorkspaceProjectConfig> projects = this.workspaceConfig.getSoapuiWorkspace().getProjectList();
            for (WorkspaceProjectConfig wsc : projects) {
                String str = PathUtils.denormalizePath(wsc.getStringValue());
                str = PathUtils.adjustRelativePath(str, this.getProjectRoot(), this);
                try {
                    WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(str, this, !closeOnStartup && wsc.getStatus() != WorkspaceProjectConfig.Status.CLOSED && wsc.getType() != WorkspaceProjectConfig.Type.REMOTE, wsc.getName(), null);
                    this.projectList.add(project);
                }
                catch (Exception e) {
                    UISupport.showErrorMessage(messages.get("FailedToLoadProjectInWorkspace", str) + e.getMessage());
                    SoapUI.logError(e);
                }
            }
        } else {
            this.workspaceConfig = SoapuiWorkspaceDocumentConfig.Factory.newInstance();
            this.workspaceConfig.addNewSoapuiWorkspace().setName(messages.get("DefaultWorkspaceName"));
            this.workspaceConfig.getSoapuiWorkspace().addNewSettings();
            this.settings = new XmlBeansSettingsImpl(this, SoapUI.getSettings(), this.workspaceConfig.getSoapuiWorkspace().getSettings());
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map<String, Project> getProjects() {
        HashMap<String, Project> result = new HashMap<String, Project>();
        for (Project project : this.projectList) {
            result.put(project.getName(), project);
        }
        return result;
    }

    public void setName(String name) {
        String oldName = this.getName();
        this.workspaceConfig.getSoapuiWorkspace().setName(name);
        this.notifyPropertyChanged(ModelItem.NAME_PROPERTY, oldName, name);
    }

    public void setDescription(String description) {
        String oldDescription = this.getDescription();
        this.workspaceConfig.getSoapuiWorkspace().setDescription(description);
        this.notifyPropertyChanged(ModelItem.DESCRIPTION_PROPERTY, oldDescription, description);
    }

    @Override
    public String getName() {
        return this.workspaceConfig.getSoapuiWorkspace().isSetName() ? this.workspaceConfig.getSoapuiWorkspace().getName() : messages.get("DefaultWorkspaceName");
    }

    @Override
    public Project getProjectAt(int index) {
        return this.projectList.get(index);
    }

    @Override
    public Project getProjectByName(String projectName) {
        for (Project project : this.projectList) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        return null;
    }

    @Override
    public int getProjectCount() {
        return this.projectList.size();
    }

    @Override
    public SaveStatus onClose() {
        return this.save(!this.getSettings().getBoolean(UISettings.AUTO_SAVE_PROJECTS_ON_EXIT));
    }

    @Override
    public SaveStatus save(boolean workspaceOnly) {
        return this.save(workspaceOnly, false);
    }

    public SaveStatus save(boolean saveWorkspaceOnly, boolean skipProjectsWithRunningTests) {
        try {
            if (this.path == null) {
                File file = UISupport.getFileDialogs().saveAs(this, messages.get("SaveWorkspace.Title"), ".xml", "XML Files (*.xml)", null);
                if (file == null) {
                    return SaveStatus.CANCELLED;
                }
                this.path = file.getAbsolutePath();
            }
            ArrayList<WorkspaceProjectConfig> projects = new ArrayList<WorkspaceProjectConfig>();
            for (int c = 0; c < this.getProjectCount(); ++c) {
                SaveStatus status;
                WsdlProject project = (WsdlProject)this.getProjectAt(c);
                if (!(saveWorkspaceOnly || (status = this.saveProject(skipProjectsWithRunningTests, project)) != SaveStatus.CANCELLED && status != SaveStatus.FAILED)) {
                    return status;
                }
                this.saveWorkspaceProjectConfig(projects, project);
            }
            this.saveWorkspaceConfig(projects);
        }
        catch (IOException e) {
            log.error((Object)(messages.get("FailedToSaveWorkspace.Error") + e.getMessage()), (Throwable)e);
            return SaveStatus.FAILED;
        }
        return SaveStatus.SUCCESS;
    }

    private void saveWorkspaceConfig(List<WorkspaceProjectConfig> projects) throws IOException {
        this.workspaceConfig.getSoapuiWorkspace().setProjectArray(projects.toArray(new WorkspaceProjectConfig[projects.size()]));
        this.workspaceConfig.getSoapuiWorkspace().setSoapuiVersion(SoapUI.SOAPUI_VERSION);
        File workspaceFile = new File(this.path);
        this.workspaceConfig.save(workspaceFile, new XmlOptions().setSavePrettyPrint());
        log.info((Object)messages.get("SavedWorkspace.Info", workspaceFile.getAbsolutePath()));
    }

    private void saveWorkspaceProjectConfig(List<WorkspaceProjectConfig> projects, WsdlProject project) {
        String path = project.getPath();
        if (path != null) {
            path = PathUtils.createRelativePath(path, this.getProjectRoot(), this);
            WorkspaceProjectConfig wpc = WorkspaceProjectConfig.Factory.newInstance();
            wpc.setStringValue(PathUtils.normalizePath(path));
            if (project.isRemote()) {
                wpc.setType(WorkspaceProjectConfig.Type.REMOTE);
            }
            if (!project.isOpen()) {
                if (project.getEncryptionStatus() == WsdlProject.ProjectEncryptionStatus.NOT_ENCRYPTED) {
                    wpc.setStatus(WorkspaceProjectConfig.Status.CLOSED);
                } else {
                    wpc.setStatus(WorkspaceProjectConfig.Status.CLOSED_AND_ENCRYPTED);
                }
            }
            wpc.setName(project.getName());
            projects.add(wpc);
        }
    }

    private SaveStatus saveProject(boolean skipProjectsWithRunningTests, WsdlProject project) throws IOException {
        if (!skipProjectsWithRunningTests || !SoapUI.getTestMonitor().hasRunningTests(project)) {
            if (!StringUtils.hasContent(project.getPath())) {
                Boolean shouldSave = UISupport.confirmOrCancel(messages.get("ProjectHasNotBeenSaved.Label", project.getName()), messages.get("ProjectHasNotBeenSaved.Title"));
                if (shouldSave == null) {
                    return SaveStatus.CANCELLED;
                }
                if (shouldSave.booleanValue()) {
                    return project.save();
                }
                return SaveStatus.DONT_SAVE;
            }
            return project.save();
        }
        log.warn((Object)messages.get("ProjectHasRunningTests.Warning", project.getName()));
        return SaveStatus.SUCCESS;
    }

    @Override
    public void addWorkspaceListener(WorkspaceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeWorkspaceListener(WorkspaceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Project importProject(String fileName) throws SoapUIException {
        File projectFile = new File(fileName);
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(projectFile.getAbsolutePath(), (Workspace)this);
        this.afterProjectImport(project);
        return project;
    }

    @Override
    public Project importProject(InputStream inputStream) {
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(inputStream, this);
        this.afterProjectImport(project);
        return project;
    }

    public void resolveProject(WsdlProject project) {
        if (this.resolver == null) {
            this.resolver = new ResolveDialog("Resolve Project", "Resolve imported project", null);
            this.resolver.setShowOkMessage(false);
        }
        this.resolver.resolve(project);
    }

    public WsdlProject createProject(String name) throws SoapUIException {
        File projectFile = new File(this.createProjectFileName(name));
        File file = UISupport.getFileDialogs().saveAs(this, messages.get("CreateProject.Title"), ".xml", "XML Files (*.xml)", projectFile);
        if (file == null) {
            return null;
        }
        return this.createProject(name, file);
    }

    @Override
    public WsdlProject createProject(String name, File file) throws SoapUIException {
        File projectFile = file;
        block2: while (projectFile != null && projectFile.exists()) {
            Boolean result = Boolean.FALSE;
            while (!result.booleanValue()) {
                result = UISupport.confirmOrCancel(messages.get("OverwriteProject.Label"), messages.get("OverwriteProject.Title"));
                if (result == null) {
                    return null;
                }
                if (result.booleanValue()) {
                    projectFile.delete();
                    continue;
                }
                projectFile = UISupport.getFileDialogs().saveAs(this, messages.get("CreateProject.Title"), ".xml", "XML Files (*.xml)", projectFile);
                if (projectFile != null) continue block2;
                return null;
            }
        }
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew((String)null, (Workspace)this);
        project.setName(name);
        this.projectList.add(project);
        this.fireProjectAdded(project);
        try {
            if (projectFile != null) {
                project.saveAs(projectFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            log.error((Object)(messages.get("FailedToSaveProject.Error") + e.getMessage()), (Throwable)e);
        }
        return project;
    }

    private void afterProjectImport(WsdlProject project) {
        this.projectList.add(project);
        this.fireProjectAdded(project);
        this.resolveProject(project);
        this.save(true);
    }

    private void fireProjectOpened(Project project) {
        for (WorkspaceListener listener : this.listeners) {
            listener.projectOpened(project);
        }
    }

    private void fireProjectClosed(Project project) {
        for (WorkspaceListener listener : this.listeners) {
            listener.projectClosed(project);
        }
    }

    private void fireProjectAdded(Project project) {
        for (WorkspaceListener listener : this.listeners) {
            listener.projectAdded(project);
        }
    }

    private void fireWorkspaceSwitching() {
        for (WorkspaceListener listener : this.listeners) {
            listener.workspaceSwitching(this);
        }
    }

    private void fireWorkspaceSwitched() {
        for (WorkspaceListener listener : this.listeners) {
            listener.workspaceSwitched(this);
        }
    }

    private String createProjectFileName(String name) {
        return name + "-soapui-project.xml";
    }

    @Override
    public void removeProject(Project project) {
        int ix = this.projectList.indexOf(project);
        if (ix == -1) {
            throw new RuntimeException("Project [" + project.getName() + "] not available in workspace for removal");
        }
        this.projectList.remove(ix);
        try {
            this.fireProjectRemoved(project);
        }
        finally {
            project.release();
        }
    }

    public Project reloadProject(Project project) throws SoapUIException {
        int ix = this.projectList.indexOf(project);
        if (ix == -1) {
            throw new RuntimeException("Project [" + project.getName() + "] not available in workspace for reload");
        }
        this.projectList.remove(ix);
        this.fireProjectRemoved(project);
        String tempName = project.getName();
        project.release();
        project = ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(project.getPath(), this, true, tempName, null);
        this.projectList.add(ix, project);
        this.fireProjectAdded(project);
        this.fireProjectOpened(project);
        return project;
    }

    private void fireProjectRemoved(Project project) {
        for (WorkspaceListener listener : this.listeners) {
            listener.projectRemoved(project);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return this.workspaceIcon;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public int getIndexOfProject(Project project) {
        return this.projectList.indexOf(project);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String getProjectRoot() {
        return this.workspaceConfig.getSoapuiWorkspace().getProjectRoot();
    }

    public void setProjectRoot(String workspaceRoot) {
        this.workspaceConfig.getSoapuiWorkspace().setProjectRoot(workspaceRoot);
    }

    public void release() {
        this.settings.release();
        for (Project project : this.projectList) {
            project.release();
        }
    }

    @Override
    public List<? extends Project> getProjectList() {
        return this.projectList;
    }

    @Override
    public String getDescription() {
        return this.workspaceConfig.getSoapuiWorkspace().getDescription();
    }

    public WsdlProject importRemoteProject(String url) throws SoapUIException {
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(url, (Workspace)this);
        this.afterProjectImport(project);
        return project;
    }

    public void closeProject(Project project) {
        WsdlProject.ProjectEncryptionStatus oldProjectEncrypt = ((WsdlProject)project).getEncryptionStatus();
        int ix = this.projectList.indexOf(project);
        if (ix == -1) {
            throw new RuntimeException("Project [" + project.getName() + "] not available in workspace for close");
        }
        this.projectList.remove(ix);
        this.fireProjectRemoved(project);
        this.fireProjectClosed(project);
        String name = project.getName();
        project.release();
        try {
            project = ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(project.getPath(), this, false, name, null);
            ((WsdlProject)project).setEncryptionStatus(oldProjectEncrypt);
            this.projectList.add(ix, project);
            this.fireProjectAdded(project);
        }
        catch (Exception e) {
            UISupport.showErrorMessage(messages.get("FailedToCloseProject.Error", name) + e.getMessage());
            SoapUI.logError(e);
        }
    }

    public List<Project> getOpenProjectList() {
        ArrayList<Project> availableProjects = new ArrayList<Project>();
        for (Project project : this.projectList) {
            if (!project.isOpen()) continue;
            availableProjects.add(project);
        }
        return availableProjects;
    }

    @Override
    public Project openProject(Project project) throws SoapUIException {
        return this.reloadProject(project);
    }

    @Override
    public String getId() {
        return String.valueOf(this.hashCode());
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.getProjectList();
    }

    @Override
    public ModelItem getParent() {
        return null;
    }

    @Override
    public void inspectProjects() {
        for (Project project : this.projectList) {
            if (!project.isOpen()) continue;
            project.inspect();
        }
    }

    public String getProjectPassword(String name) {
        return (String)this.projectOptions.get(name);
    }

    public void clearProjectPassword(String name) {
        this.projectOptions.remove(name);
    }

    @Override
    public boolean isSupportInformationDialog() {
        boolean isCollect = false;
        if (this.workspaceConfig != null) {
            if (!this.workspaceConfig.getSoapuiWorkspace().isSetCollectInfoForSupport()) {
                return true;
            }
            isCollect = this.workspaceConfig.getSoapuiWorkspace().getCollectInfoForSupport();
        }
        return isCollect;
    }

    @Override
    public void setSupportInformationDialog(boolean value) {
        if (this.workspaceConfig != null) {
            this.workspaceConfig.getSoapuiWorkspace().setCollectInfoForSupport(value);
        }
    }
}

