/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.UniqueUserIdentifier;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JFriendlyTextField;
import com.smartbear.analytics.OSUserDescription;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class SumbitUserInfoAction {
    private static final String NAME_HINT = "Enter your name *";
    private static final String EMAIL_HINT = "Enter e-mail *";
    private static final String DIALOG_CAPTION = "Stay Tuned!";
    private static final String DIALOG_MAIN_TEXT = "Want to stay in the loop?";
    private static final String DIALOG_DESCRIPTION = "Provide your email to stay current on SoapUI updates, no advertisements or promotions!";
    private static final String OK_BTN_CAPTION = "Yes, I want to know";
    private static final String SKIP_BTN_CAPTION = "Skip";

    public void show() {
        CollectUserInfoDialog cui = new CollectUserInfoDialog();
        cui.setVisible(true);
    }

    private class CollectUserInfoDialog
    extends JDialog {
        private JLabel title;
        private JLabel description;
        private JFriendlyTextField textFieldName;
        private JFriendlyTextField textFieldEmail;
        private static final String VALID_EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        private Pattern validEmailRegex;

        private void setBackgroundColor(JPanel curPanel) {
            curPanel.setOpaque(true);
            curPanel.setBackground(Color.WHITE);
        }

        private void setBackgroundColor(JLabel curLabel) {
            curLabel.setOpaque(true);
            curLabel.setBackground(Color.WHITE);
        }

        public CollectUserInfoDialog() {
            super(UISupport.getMainFrame(), SumbitUserInfoAction.DIALOG_CAPTION, true);
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.setUndecorated(true);
            this.setModal(true);
            this.setSize(430, 250);
            this.setBackground(Color.WHITE);
            JPanel jBasePanel = new JPanel(new BorderLayout(5, 5));
            jBasePanel.setBorder(new LineBorder(new Color(170, 170, 170), 2));
            this.setBackgroundColor(jBasePanel);
            this.add(jBasePanel);
            JPanel jBaseUserPanel = new JPanel(new BorderLayout(5, 5));
            this.setBackgroundColor(jBaseUserPanel);
            JLabel jCaption = new JLabel("  Stay Tuned!");
            jCaption.setOpaque(true);
            jCaption.setPreferredSize(new Dimension(1000, 25));
            jCaption.setBackground(new Color(166, 192, 229));
            jBaseUserPanel.add((Component)this.buildCaptionPanel(SumbitUserInfoAction.DIALOG_MAIN_TEXT, SumbitUserInfoAction.DIALOG_DESCRIPTION), "North");
            jBaseUserPanel.add(this.buildControlsPanel());
            jBasePanel.add((Component)jCaption, "North");
            jBasePanel.add(jBaseUserPanel);
            this.validEmailRegex = Pattern.compile(VALID_EMAIL_PATTERN);
        }

        private JPanel buildCaptionPanel(String titleStr, String descriptionStr) {
            JPanel jRoot = new JPanel(new BorderLayout());
            jRoot.setBorder(new EmptyBorder(10, 30, 0, 25));
            this.setBackgroundColor(jRoot);
            this.title = new JLabel();
            this.setBackgroundColor(this.title);
            this.title.setText("<html><div style=\"font-size: 11px\"><b>" + titleStr + "</b></div></html>");
            this.title.setOpaque(true);
            this.title.setBackground(Color.WHITE);
            this.description = new JLabel();
            this.setBackgroundColor(this.description);
            this.description.setText("<html><div style=\"font-size: 9px\">" + descriptionStr + "</div></html>");
            this.description.setBorder(new EmptyBorder(5, 0, 0, 0));
            jRoot.add((Component)this.title, "North");
            jRoot.add(this.description);
            return jRoot;
        }

        private JPanel buildControlsPanel() {
            JPanel jbase = new JPanel(new BorderLayout());
            JPanel jLeftPanel = new JPanel();
            jLeftPanel.setLayout(new BorderLayout());
            jLeftPanel.setBorder(new EmptyBorder(0, 0, 25, 0));
            JLabel arrowIcon = new JLabel(UISupport.createImageIcon("/big_arrow.png"));
            jLeftPanel.add((Component)arrowIcon, "South");
            this.setBackgroundColor(jLeftPanel);
            JPanel jControlsPanel = new JPanel(new BorderLayout());
            jControlsPanel.setBorder(new EmptyBorder(5, 2, 10, 35));
            this.setBackgroundColor(jControlsPanel);
            jControlsPanel.add((Component)this.buildButtonsPanel(), "South");
            jControlsPanel.add(this.buildUserInfoPanel());
            jbase.add((Component)jLeftPanel, "West");
            jbase.add(jControlsPanel);
            return jbase;
        }

        private JPanel buildUserInfoPanel() {
            this.textFieldName = new JFriendlyTextField(SumbitUserInfoAction.NAME_HINT);
            this.textFieldName.setPreferredSize(new Dimension(300, 24));
            this.textFieldEmail = new JFriendlyTextField(SumbitUserInfoAction.EMAIL_HINT);
            this.textFieldEmail.setPreferredSize(new Dimension(300, 24));
            JPanel jHelpEmail = new JPanel(new BorderLayout());
            this.setBackgroundColor(jHelpEmail);
            jHelpEmail.setBorder(new EmptyBorder(8, 0, 0, 0));
            jHelpEmail.add((Component)this.textFieldEmail, "North");
            JPanel userInfoContent = new JPanel(new BorderLayout());
            this.setBackgroundColor(userInfoContent);
            userInfoContent.add((Component)this.textFieldName, "North");
            userInfoContent.add(jHelpEmail);
            return userInfoContent;
        }

        private JPanel buildButtonsPanel() {
            JButton jOkBtn = new JButton(SumbitUserInfoAction.OK_BTN_CAPTION);
            jOkBtn.setBorder(new LineBorder(new Color(200, 200, 200), 1));
            jOkBtn.setBackground(new Color(157, 200, 130));
            jOkBtn.setOpaque(true);
            jOkBtn.setForeground(Color.WHITE);
            jOkBtn.setPreferredSize(new Dimension(300, 24));
            jOkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CollectUserInfoDialog.this.handleOk()) {
                        CollectUserInfoDialog.this.setVisible(false);
                    }
                }
            });
            JPanel jOkPanel = new JPanel(new BorderLayout());
            jOkPanel.setBorder(new EmptyBorder(0, 0, 0, 10));
            this.setBackgroundColor(jOkPanel);
            jOkPanel.add(jOkBtn);
            JButton jSkip = new JButton(SumbitUserInfoAction.SKIP_BTN_CAPTION);
            jSkip.setBorder(new LineBorder(new Color(170, 170, 170), 1));
            jSkip.setForeground(new Color(170, 170, 170));
            if (UISupport.isMac()) {
                jSkip.setBackground(new Color(236, 236, 236));
            }
            jSkip.setOpaque(true);
            jSkip.setPreferredSize(new Dimension(60, 20));
            jSkip.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollectUserInfoDialog.this.setVisible(false);
                }
            });
            JPanel buttonsContent = new JPanel(new BorderLayout());
            buttonsContent.setBorder(new EmptyBorder(20, 0, 20, 0));
            this.setBackgroundColor(buttonsContent);
            buttonsContent.add((Component)jSkip, "East");
            buttonsContent.add(jOkPanel);
            return buttonsContent;
        }

        @Override
        public void setVisible(boolean b) {
            UISupport.centerDialog(this);
            super.setVisible(b);
        }

        private String getUserName() {
            String name = this.textFieldName.getText();
            name = name.replace(SumbitUserInfoAction.NAME_HINT, "");
            return name;
        }

        private String getUserEMail() {
            String email = this.textFieldEmail.getText();
            email = email.replace(SumbitUserInfoAction.EMAIL_HINT, "");
            return email;
        }

        protected boolean handleOk() {
            if (!this.validateFormValues()) {
                return false;
            }
            UniqueUserIdentifier userIdentifier = UniqueUserIdentifier.getInstance();
            OSUserDescription osUserDescription = new OSUserDescription(this.getUserName(), this.getUserEMail(), userIdentifier.getUserId());
            Analytics.trackUserInfo(osUserDescription);
            return true;
        }

        private boolean validateFormValues() {
            ArrayList<String> fieldErrors = new ArrayList<String>();
            if (StringUtils.isNullOrEmpty(this.getUserName())) {
                fieldErrors.add("your name");
            }
            if (!this.isValidEmailAddress(this.getUserEMail())) {
                fieldErrors.add("a valid email address");
            }
            if (fieldErrors.isEmpty()) {
                return true;
            }
            StringBuilder buf = new StringBuilder("You must enter ");
            int numberOfErrors = fieldErrors.size();
            for (int i = 0; i < numberOfErrors; ++i) {
                if (i > 0) {
                    buf.append(i < numberOfErrors - 1 ? ", " : " and ");
                }
                buf.append((String)fieldErrors.get(i));
            }
            buf.append(".");
            UISupport.showErrorMessage(buf.toString());
            return false;
        }

        private boolean isValidEmailAddress(String email) {
            return StringUtils.hasContent(email) && this.validEmailRegex.matcher(email).matches();
        }
    }
}

