/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VolumeInfo {
    private static Map mountPointToDiskFile;
    private static final String DOWNLOAD_SUFFIX = ".download";

    public static Map getNewMountPointToDiskFile() {
        mountPointToDiskFile = null;
        return VolumeInfo.getMountPointToDiskFile();
    }

    public static Map getMountPointToDiskFile() {
        if (mountPointToDiskFile == null) {
            mountPointToDiskFile = new HashMap();
            StringBuffer stringBuffer = new StringBuffer();
            try {
                int n = Execution.executeWithReturnCode(new String[]{"hdiutil", "info", "-plist"}, stringBuffer, true);
                if (n != 0) {
                    return mountPointToDiskFile;
                }
                Document document = XmlHelper.parseString(stringBuffer.toString(), false, false);
                Element element = document.getDocumentElement();
                element = PlistHelper.getFirstChild(PlistHelper.getFirstChild(element, "dict"), "array");
                Iterator iterator = XmlHelper.childElements(element);
                block6: while (iterator.hasNext()) {
                    Element element2 = (Element)iterator.next();
                    try {
                        String string = XmlHelper.getTextValue(PlistHelper.findValue(element2, "image-path"));
                        Element element3 = PlistHelper.findValue(element2, "system-entities");
                        Iterator iterator2 = XmlHelper.childElements(element3);
                        while (iterator2.hasNext()) {
                            Element element4 = (Element)iterator2.next();
                            try {
                                String string2 = XmlHelper.getTextValue(PlistHelper.findValue(element4, "mount-point"));
                                String string3 = VolumeInfo.removeDownloadDir(string);
                                mountPointToDiskFile.put(string2, string3);
                                Logger.getInstance().info(class$com$install4j$runtime$installer$platform$macos$VolumeInfo == null ? VolumeInfo.class$("com.install4j.runtime.installer.platform.macos.VolumeInfo") : class$com$install4j$runtime$installer$platform$macos$VolumeInfo, "image: " + string3 + ", mountPoint: " + string2);
                                continue block6;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                    catch (Exception exception) {
                        Logger.getInstance().info(class$com$install4j$runtime$installer$platform$macos$VolumeInfo == null ? VolumeInfo.class$("com.install4j.runtime.installer.platform.macos.VolumeInfo") : class$com$install4j$runtime$installer$platform$macos$VolumeInfo, "Could not get volume info: " + exception);
                    }
                }
            }
            catch (Exception exception) {
                Logger.getInstance().error(VolumeInfo.class, "Could not get volume info: " + exception);
            }
        }
        return mountPointToDiskFile;
    }

    private static String removeDownloadDir(String string) {
        File file = new File(string).getParentFile();
        if (file.getName().endsWith(DOWNLOAD_SUFFIX)) {
            String string2 = file.getAbsolutePath();
            return string2.substring(0, string2.length() - DOWNLOAD_SUFFIX.length());
        }
        return string;
    }
}

