/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.launching.InputRedirection;
import com.install4j.runtime.installer.helper.launching.InputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.helper.launching.OutputRedirection;
import com.install4j.runtime.installer.helper.launching.OutputRedirectionMode;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public class RunExecutableAction
extends SystemInstallOrUninstallAction
implements PropertyLoggingInterceptor {
    public static final String PROPERTY_ARGUMENTS = "arguments";
    private File executable;
    private File workingDirectory;
    private String[] arguments;
    private boolean useRollbackExecutable = false;
    private File rollbackExecutable;
    private File rollbackWorkingDirectory;
    private String[] rollbackArguments;
    private boolean wait = false;
    private boolean waitForStreams = true;
    private String returnCodeVariable = "";
    private int timeout = 0;
    private boolean logArguments = false;
    private OutputRedirectionMode stdoutRedirectionMode = OutputRedirectionMode.NONE;
    private String stdoutVariableName = "";
    private File stdoutFile;
    private boolean failOnStdoutFileError = false;
    private OutputRedirectionMode stderrRedirectionMode = OutputRedirectionMode.NONE;
    private File stderrFile;
    private String stderrVariableName = "";
    private boolean failOnStderrFileError = false;
    private InputRedirectionMode stdinRedirectionMode = InputRedirectionMode.NONE;
    private File stdinFile;
    private String stdinString = "";
    private boolean failOnStdinFileError = false;
    private boolean includeParentEnvironmentVariables = true;
    private Map environmentVariables = new LinkedHashMap();
    private boolean showWindowsConsole = false;
    private boolean keepConsoleWindow = false;

    public File getExecutable() {
        return RunExecutableAction.replaceVariables(this.executable);
    }

    public void setExecutable(File file) {
        this.executable = file;
    }

    public File getWorkingDirectory() {
        return RunExecutableAction.replaceVariables(this.workingDirectory);
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file;
    }

    public String[] getArguments() {
        return RunExecutableAction.replaceVariables(this.arguments);
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public boolean isUseRollbackExecutable() {
        return this.useRollbackExecutable;
    }

    public void setUseRollbackExecutable(boolean bl) {
        this.useRollbackExecutable = bl;
    }

    public File getRollbackExecutable() {
        return RunExecutableAction.replaceVariables(this.rollbackExecutable);
    }

    public void setRollbackExecutable(File file) {
        this.rollbackExecutable = file;
    }

    public File getRollbackWorkingDirectory() {
        return RunExecutableAction.replaceVariables(this.rollbackWorkingDirectory);
    }

    public void setRollbackWorkingDirectory(File file) {
        this.rollbackWorkingDirectory = file;
    }

    public String[] getRollbackArguments() {
        return RunExecutableAction.replaceVariables(this.rollbackArguments);
    }

    public void setRollbackArguments(String[] stringArray) {
        this.rollbackArguments = stringArray;
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean bl) {
        this.wait = bl;
    }

    public boolean isWaitForStreams() {
        return this.waitForStreams;
    }

    public void setWaitForStreams(boolean bl) {
        this.waitForStreams = bl;
    }

    public String getReturnCodeVariable() {
        return this.returnCodeVariable;
    }

    public void setReturnCodeVariable(String string) {
        this.returnCodeVariable = string;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public boolean isLogArguments() {
        return this.logArguments;
    }

    public void setLogArguments(boolean bl) {
        this.logArguments = bl;
    }

    public OutputRedirectionMode getStdoutRedirectionMode() {
        return this.stdoutRedirectionMode;
    }

    public void setStdoutRedirectionMode(OutputRedirectionMode outputRedirectionMode) {
        this.stdoutRedirectionMode = outputRedirectionMode;
    }

    public String getStdoutVariableName() {
        return RunExecutableAction.replaceVariables(this.stdoutVariableName);
    }

    public void setStdoutVariableName(String string) {
        this.stdoutVariableName = string;
    }

    public File getStdoutFile() {
        return RunExecutableAction.replaceVariables(this.stdoutFile);
    }

    public void setStdoutFile(File file) {
        this.stdoutFile = file;
    }

    public boolean isFailOnStdoutFileError() {
        return this.failOnStdoutFileError;
    }

    public void setFailOnStdoutFileError(boolean bl) {
        this.failOnStdoutFileError = bl;
    }

    public OutputRedirectionMode getStderrRedirectionMode() {
        return this.stderrRedirectionMode;
    }

    public void setStderrRedirectionMode(OutputRedirectionMode outputRedirectionMode) {
        this.stderrRedirectionMode = outputRedirectionMode;
    }

    public String getStderrVariableName() {
        return RunExecutableAction.replaceVariables(this.stderrVariableName);
    }

    public void setStderrVariableName(String string) {
        this.stderrVariableName = string;
    }

    public File getStderrFile() {
        return RunExecutableAction.replaceVariables(this.stderrFile);
    }

    public void setStderrFile(File file) {
        this.stderrFile = file;
    }

    public boolean isFailOnStderrFileError() {
        return this.failOnStderrFileError;
    }

    public void setFailOnStderrFileError(boolean bl) {
        this.failOnStderrFileError = bl;
    }

    public InputRedirectionMode getStdinRedirectionMode() {
        return this.stdinRedirectionMode;
    }

    public void setStdinRedirectionMode(InputRedirectionMode inputRedirectionMode) {
        this.stdinRedirectionMode = inputRedirectionMode;
    }

    public String getStdinString() {
        return RunExecutableAction.replaceVariables(this.stdinString);
    }

    public void setStdinString(String string) {
        this.stdinString = string;
    }

    public File getStdinFile() {
        return RunExecutableAction.replaceVariables(this.stdinFile);
    }

    public void setStdinFile(File file) {
        this.stdinFile = file;
    }

    public boolean isFailOnStdinFileError() {
        return this.failOnStdinFileError;
    }

    public void setFailOnStdinFileError(boolean bl) {
        this.failOnStdinFileError = bl;
    }

    public boolean isIncludeParentEnvironmentVariables() {
        return this.includeParentEnvironmentVariables;
    }

    public void setIncludeParentEnvironmentVariables(boolean bl) {
        this.includeParentEnvironmentVariables = bl;
    }

    public Map getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map map) {
        this.environmentVariables = map;
    }

    public boolean isShowWindowsConsole() {
        return this.showWindowsConsole;
    }

    public void setShowWindowsConsole(boolean bl) {
        this.showWindowsConsole = bl;
    }

    public boolean isKeepConsoleWindow() {
        return this.keepConsoleWindow;
    }

    public void setKeepConsoleWindow(boolean bl) {
        this.keepConsoleWindow = bl;
    }

    public Object getLogValueForProperty(String string, Object object) {
        if (string.equals(PROPERTY_ARGUMENTS) && !this.logArguments) {
            return "[logging of arguments is disabled]";
        }
        return object;
    }

    public boolean execute(Context context) throws UserCanceledException {
        return this.runExecutable(this.getExecutable(), this.getWorkingDirectory(), this.getArguments(), context);
    }

    private boolean runExecutable(File file, File file2, String[] stringArray, Context context) {
        Integer n;
        File file3;
        for (file3 = context.getDestinationFile(file2); file3 != null && !file3.exists(); file3 = file3.getParentFile()) {
        }
        Logger.getInstance().info(this, "used working dir: " + file3);
        File file4 = this.getUsedExecutable(file3, context, file);
        if (!file4.exists()) {
            Logger.getInstance().error(this, "executable does not exist: " + file4.getAbsolutePath());
            return false;
        }
        OutputRedirection outputRedirection = new OutputRedirection(this.getStdoutRedirectionMode(), this.getStdoutVariableName(), this.getStdoutFile(), this.isFailOnStdoutFileError());
        OutputRedirection outputRedirection2 = new OutputRedirection(this.getStderrRedirectionMode(), this.getStderrVariableName(), this.getStderrFile(), this.isFailOnStderrFileError());
        InputRedirection inputRedirection = new InputRedirection(this.getStdinRedirectionMode(), this.getStdinString(), this.getStdinFile(), this.isFailOnStdinFileError());
        LaunchDescriptor launchDescriptor = new LaunchDescriptor(file4).workingDirectory(file3).arguments(stringArray).specificEnvironmentVariables(this.environmentVariables).includeParentEnvironmentVariables(this.includeParentEnvironmentVariables).showWindowsConsole(this.showWindowsConsole).keepConsoleWindow(this.keepConsoleWindow).useNohup(!this.wait && !Util.isWindows() && !Util.isMacOS()).stdoutRedirection(outputRedirection).stderrRedirection(outputRedirection2).stdinRedirection(inputRedirection).wait(this.wait).waitForStreams(this.waitForStreams).timeout(this.timeout);
        if (Util.isMacOS() && HelperCommunication.getInstance().isElevatedHelper()) {
            launchDescriptor.suidRoot(true);
        }
        if ((n = LaunchHelper.launchApplication(launchDescriptor)) == null) {
            return false;
        }
        if (this.wait) {
            int n2 = n;
            if (this.returnCodeVariable.length() > 0) {
                context.setVariable(this.returnCodeVariable, n);
            }
            if (n2 != 0) {
                Logger.getInstance().error(this, "return value is " + n2);
                return false;
            }
        }
        return true;
    }

    public boolean isRollbackSupported() {
        return this.useRollbackExecutable;
    }

    public void rollback(InstallerContext installerContext) {
        super.rollback(installerContext);
        this.runExecutable(this.getRollbackExecutable(), this.getRollbackWorkingDirectory(), this.getRollbackArguments(), installerContext);
    }

    private File getUsedExecutable(File file, Context context, File file2) {
        File file3;
        File file4 = this.maybeWithExtension(context.getDestinationFile(file2));
        if (!file4.exists() && !file2.isAbsolute() && (file3 = this.maybeWithExtension(new File(file, file2.getPath()))).exists()) {
            file4 = file3;
        }
        return file4;
    }

    private File maybeWithExtension(File file) {
        if (Util.isWindows() && !file.exists() && !file.getPath().toLowerCase().endsWith(".exe")) {
            File file2 = new File(file.getPath() + ".exe");
            if (file2.exists()) {
                return file2;
            }
            return file;
        }
        return file;
    }
}

