/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.IOException;

public class CopyFileAction
extends AbstractRecursiveFileAction {
    private File destinationFile;
    private OverwriteMode overwriteMode = OverwriteMode.ALWAYS_ASK_EXCEPT_FOR_UPDATE;
    private String mode = "644";
    private String directoryMode = "755";
    private boolean shared = false;
    private UninstallMode uninstallMode = UninstallMode.IF_CREATED;
    private boolean delay = false;
    private boolean triggerReboot = true;
    private transient boolean toSingleFile;

    public boolean isDelay() {
        return this.delay;
    }

    public void setDelay(boolean bl) {
        this.delay = bl;
    }

    public boolean isTriggerReboot() {
        return this.triggerReboot;
    }

    public void setTriggerReboot(boolean bl) {
        this.triggerReboot = bl;
    }

    public String getDirectoryMode() {
        return this.directoryMode;
    }

    public void setDirectoryMode(String string) {
        this.directoryMode = string;
    }

    public File getDestinationFile() {
        return CopyFileAction.replaceVariables(this.destinationFile);
    }

    public void setDestinationFile(File file) {
        this.destinationFile = file;
    }

    public OverwriteMode getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(OverwriteMode overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public UninstallMode getUninstallMode() {
        return this.uninstallMode;
    }

    public void setUninstallMode(UninstallMode uninstallMode) {
        this.uninstallMode = uninstallMode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeForMultipleFilesAction(Context context, File[] fileArray) throws UserCanceledException {
        File file = context.getDestinationFile(this.getDestinationFile());
        this.toSingleFile = false;
        if (!file.isDirectory()) {
            if (fileArray.length > 1) {
                Logger.getInstance().log(this, "Destination file " + file + " is not a directory and there are more than one source files", false);
                return false;
            }
            if (context.getDestinationFile(fileArray[0]).isFile()) {
                this.toSingleFile = true;
            }
        }
        FileInstaller.getInstance().resetCurrentRebootRequired();
        try {
            boolean bl = super.executeForMultipleFilesAction(context, fileArray);
            return bl;
        }
        finally {
            if (this.isTriggerReboot() && this.isDelay() && FileInstaller.getInstance().isCurrentRebootRequired()) {
                context.triggerReboot(true);
            }
        }
    }

    protected boolean executeForSingleRecursiveFile(Context context, File file, File file2, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        FileInstaller fileInstaller = FileInstaller.getInstance();
        File file3 = context.getDestinationFile(this.getDestinationFile());
        if (file.isDirectory()) {
            File file4 = this.getCanonicalFileNoError(new File(file3, file2.getPath()));
            fileInstaller.createDirectory(file4, this.getUninstallMode());
            file4.setLastModified(file.lastModified());
            if (!InstallerUtil.isWindows()) {
                UnixFileSystem.setMode(this.getDirectoryMode(), file4);
            }
        } else {
            File file5 = this.toSingleFile ? file3 : this.getCanonicalFileNoError(new File(file3, file2.getPath()));
            Util.logInfo(null, this.getActionName() + " " + file + " to " + file5);
            if (!fileInstaller.install(file, file5, new FileOptions(file.lastModified(), this.getMode(), this.getOverwriteMode(), this.isShared(), this.isDelay(), this.getUninstallMode()), progressAdapter)) {
                return false;
            }
        }
        return true;
    }

    protected boolean isAddTopLevelDirectoriesToRelativePath() {
        return false;
    }

    public boolean isRecursive() {
        return true;
    }

    private File getCanonicalFileNoError(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    protected String getActionName() {
        return "Copy";
    }
}

