/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherType;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.beans.screens.components.ProgramGroupEntryConfig;
import com.install4j.runtime.beans.screens.components.ProgramGroupFileConfig;
import com.install4j.runtime.beans.screens.components.ProgramGroupUrlConfig;
import com.install4j.runtime.beans.screens.components.ProgramGroupWithIconConfig;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CreateProgramGroupAction
extends SystemInstallAction {
    private String programGroupName = "${installer:sys.programGroupName}";
    private boolean allUsers = true;
    private boolean addUninstaller = true;
    private String uninstallerMenuName = "";
    private boolean addDefaultLauncherLinks = true;
    private String linkDirectory = "${installer:sys.symlinkDir}";
    private String categories = "Application";
    private boolean unixSymlinks = true;
    private boolean failForSymlinksNotCreated = false;
    private boolean unixMenuEntries = true;
    private List programGroupEntryConfigs = new ArrayList();
    private boolean nameEdited = false;

    public void init(Context context) {
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        if (!this.nameEdited) {
            this.updateProgramGroupName();
        }
        boolean bl = true;
        try {
            if (InstallerUtil.isWindows()) {
                this.installWindows(installerContext);
            } else if (!InstallerUtil.isMacOS()) {
                bl = this.installUnix(installerContext);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return bl;
    }

    public boolean isAddUninstaller() {
        return this.addUninstaller;
    }

    public void setAddUninstaller(boolean bl) {
        this.addUninstaller = bl;
    }

    public String getUninstallerMenuName() {
        return CreateProgramGroupAction.replaceVariables(this.uninstallerMenuName);
    }

    public void setUninstallerMenuName(String string) {
        this.uninstallerMenuName = string;
    }

    public boolean isAddDefaultLauncherLinks() {
        return this.addDefaultLauncherLinks;
    }

    public void setAddDefaultLauncherLinks(boolean bl) {
        this.addDefaultLauncherLinks = bl;
    }

    public String getCategories() {
        return CreateProgramGroupAction.replaceVariables(this.categories);
    }

    public void setCategories(String string) {
        this.categories = string;
    }

    public String getProgramGroupName() {
        try {
            return CreateProgramGroupAction.replaceVariables(this.programGroupName);
        }
        catch (UndefinedVariableException undefinedVariableException) {
            return "";
        }
    }

    public void setProgramGroupName(String string) {
        this.programGroupName = string;
        this.nameEdited = true;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean bl) {
        this.allUsers = bl;
    }

    public String getLinkDirectory() {
        try {
            return CreateProgramGroupAction.replaceVariables(this.linkDirectory);
        }
        catch (UndefinedVariableException undefinedVariableException) {
            return "";
        }
    }

    public void setLinkDirectory(String string) {
        this.linkDirectory = string;
    }

    public List getProgramGroupEntryConfigs() {
        return this.programGroupEntryConfigs;
    }

    public void setProgramGroupEntryConfigs(List list) {
        this.programGroupEntryConfigs = list;
    }

    public boolean isUnixSymlinks() {
        return this.unixSymlinks;
    }

    public void setUnixSymlinks(boolean bl) {
        this.unixSymlinks = bl;
    }

    public boolean isFailForSymlinksNotCreated() {
        return this.failForSymlinksNotCreated;
    }

    public void setFailForSymlinksNotCreated(boolean bl) {
        this.failForSymlinksNotCreated = bl;
    }

    public boolean isUnixMenuEntries() {
        return this.unixMenuEntries;
    }

    public void setUnixMenuEntries(boolean bl) {
        this.unixMenuEntries = bl;
    }

    private boolean installUnix(InstallerContext installerContext) throws IOException, UserCanceledException {
        FileInstaller fileInstaller = FileInstaller.getInstance();
        boolean bl = true;
        Iterator iterator = installerContext.getLaunchers().iterator();
        while (iterator.hasNext()) {
            File file;
            File file2;
            ContextImpl.LauncherSetupImpl launcherSetupImpl = (ContextImpl.LauncherSetupImpl)iterator.next();
            if (launcherSetupImpl.isUninstaller() || !(file2 = installerContext.getDestinationFile(launcherSetupImpl.getRelativeFileName())).exists()) continue;
            boolean bl2 = launcherSetupImpl.isExcludeFromMenu();
            if (this.unixMenuEntries && !bl2 && (launcherSetupImpl.getType() == LauncherType.GUI || launcherSetupImpl.getType() == LauncherType.EXTERNAL)) {
                MenuHelper.installUnixMenu(installerContext.getInstallationDirectory(), file2, launcherSetupImpl.getMenuName(), this.getCategories(), null);
            }
            if (!this.unixSymlinks || bl2 || this.getLinkDirectory() == null || this.getLinkDirectory().trim().length() <= 0 || (file = new File(this.getLinkDirectory()).getCanonicalFile()).equals(file2.getParentFile().getCanonicalFile())) continue;
            fileInstaller.createDirectory(file);
            File file3 = new File(file, file2.getName());
            boolean bl3 = UnixFileSystem.createLink(file2.getAbsolutePath(), file3);
            if (this.failForSymlinksNotCreated && !bl3) {
                bl = false;
            }
            if (!bl3) continue;
            fileInstaller.registerUninstallFile(file3);
        }
        try {
            Runtime.getRuntime().exec("kbuildsycoca");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private void installWindows(InstallerContext installerContext) throws UserCanceledException, IOException {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        boolean bl = this.allUsers;
        Object object2 = InstallerVariables.getVariable("sys.programGroupAllUsers");
        if (object2 != null && object2 instanceof Boolean) {
            bl = (Boolean)object2;
        }
        if (bl && !InstallerUtil.checkWriteable(FolderInfo.getSpecialFolder(3, true))) {
            bl = false;
        }
        File file = FolderInfo.getSpecialFolder(3, bl);
        if (this.getProgramGroupName().trim().length() > 0) {
            file = new File(file, this.getProgramGroupName());
        }
        ExecutionContext executionContext = bl ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED;
        Iterator iterator = installerContext.getLaunchers().iterator();
        while (iterator.hasNext()) {
            serializable2 = (ContextImpl.LauncherSetupImpl)iterator.next();
            if (((ContextImpl.LauncherSetupImpl)serializable2).isExcludeFromMenu() || ((ContextImpl.LauncherSetupImpl)serializable2).isUninstaller() && !this.isAddUninstaller() || !((File)(serializable = installerContext.getDestinationFile(CreateProgramGroupAction.replaceVariables(((ContextImpl.LauncherSetupImpl)serializable2).getRelativeFileName())))).exists()) continue;
            object = ((ContextImpl.LauncherSetupImpl)serializable2).isUninstaller() ? this.getUninstallerMenuName() : ((ContextImpl.LauncherSetupImpl)serializable2).getMenuName();
            MenuHelper.installWindowsMenu(executionContext, new File(file, (String)object), (File)serializable, null);
        }
        iterator = this.getProgramGroupEntryConfigs().iterator();
        while (iterator.hasNext()) {
            Object object3;
            ProgramGroupWithIconConfig programGroupWithIconConfig;
            serializable2 = (ProgramGroupEntryConfig)iterator.next();
            if (!(serializable2 instanceof ProgramGroupWithIconConfig)) continue;
            serializable = (ProgramGroupWithIconConfig)serializable2;
            object = installerContext.getExternalFile(((ProgramGroupWithIconConfig)serializable).getIconFile(), true);
            File file2 = new File(file, ((ProgramGroupEntryConfig)serializable2).getName());
            if (serializable2 instanceof ProgramGroupUrlConfig) {
                programGroupWithIconConfig = (ProgramGroupUrlConfig)serializable2;
                object3 = CreateProgramGroupAction.replaceVariables(((ProgramGroupUrlConfig)programGroupWithIconConfig).getUrl());
                if (((String)object3).indexOf("://") < 0) {
                    object3 = "http://" + (String)object3;
                }
                MenuHelper.installUrlLink(executionContext, (String)object3, file2, (File)object, ((ProgramGroupUrlConfig)programGroupWithIconConfig).isFavicon());
                continue;
            }
            if (!(serializable2 instanceof ProgramGroupFileConfig) || !((File)(object3 = installerContext.getDestinationFile(CreateProgramGroupAction.replaceVariables(((ProgramGroupFileConfig)(programGroupWithIconConfig = (ProgramGroupFileConfig)serializable2)).getTarget())))).exists()) continue;
            MenuHelper.installWindowsMenu(executionContext, file2, (File)object3, (File)object, CreateProgramGroupAction.replaceVariables(((ProgramGroupFileConfig)programGroupWithIconConfig).getArguments()), ((ProgramGroupFileConfig)programGroupWithIconConfig).isRunAsAdministrator(), null);
        }
    }

    public void updateProgramGroupName() {
        this.nameEdited = true;
    }
}

