/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.analytics.impl;

import com.smartbear.analytics.ActionDescription;
import com.smartbear.analytics.OSUserDescription;
import com.smartbear.analytics.api.ProductInfo;
import com.smartbear.analytics.impl.BaseAnalyticsProvider;
import com.smartbear.analytics.impl.SoapUIOSMixpanelProvider;
import com.smartbear.analytics.impl.UserInfoProvider;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapUIOSUserProvider
extends BaseAnalyticsProvider
implements UserInfoProvider {
    private static final String ANALYTICS_SERVER_URL = "https://analytics01.smartbear.com/open-source-analytics-server/analytics";
    private static final Logger log = LoggerFactory.getLogger(SoapUIOSMixpanelProvider.class);

    public SoapUIOSUserProvider(ProductInfo productInfo) {
        super(productInfo);
    }

    @Override
    public void trackUserInfo(OSUserDescription osUserDescription) {
        String requestParams = this.prepareRequestParams(osUserDescription);
        this.sendRecord(ANALYTICS_SERVER_URL, requestParams);
    }

    @Override
    public void trackAction(ActionDescription actionDescription) {
    }

    private String prepareRequestParams(OSUserDescription osUserDescription) {
        StringBuilder sb = new StringBuilder();
        sb.append("name=");
        sb.append(this.urlEncodeWithUtf8(osUserDescription.getName()));
        sb.append("&email=");
        sb.append(this.urlEncodeWithUtf8(osUserDescription.getEmail()));
        sb.append("&uuid=");
        sb.append(this.urlEncodeWithUtf8(osUserDescription.getUuid()));
        return sb.toString();
    }

    protected boolean sendRecord(String connectionURL, String parameters) {
        if (parameters == null) {
            return false;
        }
        HttpURLConnection connection = this.initializeConnection(connectionURL);
        if (connection == null) {
            return false;
        }
        try {
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(parameters);
            wr.flush();
            wr.close();
            int responseCode = connection.getResponseCode();
            return responseCode == 200;
        }
        catch (Exception e) {
            log.error("Error when sending request to udpdate user info", (Throwable)e);
            return false;
        }
    }

    protected HttpURLConnection initializeConnection(String connectionURL) {
        try {
            URL url = new URL(connectionURL);
            return (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            log.error("Error when creating the connection", (Throwable)e);
            return null;
        }
    }
}

