/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.analytics.impl;

import com.smartbear.analytics.ActionDescription;
import com.smartbear.analytics.api.AnalyticsProvider;
import com.smartbear.analytics.api.AnalyticsProviderFactory;
import com.smartbear.analytics.api.LogList;
import com.smartbear.analytics.impl.BaseAnalyticsProvider;
import com.smartbear.analytics.impl.EmptyProductInfo;

public class LogTabAnalyticsProvider
extends BaseAnalyticsProvider {
    private final LogList logList;

    public LogTabAnalyticsProvider(LogList logList) {
        super(new EmptyProductInfo());
        this.logList = logList;
    }

    @Override
    public void trackAction(ActionDescription actionDescription) {
        this.logList.addLine(actionDescription.toString());
    }

    public static class LogTabAnalyticsProviderFactory
    implements AnalyticsProviderFactory {
        private LogList logList;

        public LogTabAnalyticsProviderFactory(LogList logList) {
            this.logList = logList;
        }

        @Override
        public String getName() {
            return "Log Tab Analytics";
        }

        @Override
        public String getDescription() {
            return "Logs analytics events to a dedicated tab in SoapUI - for debugging - enable with -Dsoapui.analytics.logtab=true";
        }

        @Override
        public AnalyticsProvider allocateProvider() {
            return new LogTabAnalyticsProvider(this.logList);
        }
    }
}

