/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.analytics.impl;

import com.smartbear.analytics.ActionDescription;
import com.smartbear.analytics.AnalyticsManager;
import com.smartbear.analytics.AnalyticsUtils;
import com.smartbear.analytics.api.ProductInfo;
import com.smartbear.analytics.impl.BaseAnalyticsProvider;
import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAnalyticsProvider
extends BaseAnalyticsProvider {
    public static final Logger log = LoggerFactory.getLogger(GoogleAnalyticsProvider.class);
    private static final String CATEGORY_SESSION = "Session";
    private static final String CATEGORY_ACTION = "Action";
    private static final String CATEGORY_INVALID = "[Unknown]";
    private static final String EVENT_START = "Start";
    private static final String EVENT_STOP = "Stop";
    private final String googleAnalyticId;

    public GoogleAnalyticsProvider(ProductInfo productInfo, String googleAnalyticId) {
        super(productInfo);
        this.googleAnalyticId = googleAnalyticId;
    }

    @Override
    public void trackAction(ActionDescription actionDescription) {
        try {
            if (AnalyticsManager.Category.LICENSE_UPDATE == actionDescription.getCategory()) {
                return;
            }
            this.sendRecord(this.buildParametersString(actionDescription));
            this.trackActiveScreen(actionDescription.getActionName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void trackError(Throwable error) {
        try {
            String errorParametersString = String.format("v=1&an=%s&av=%s&cd=%s&tid=%s&cid=%s&t=exception&exd=%s&exf=%s&aip=1", this.urlEncodeWithUtf8(this.getProductInfo().getName()), this.urlEncodeWithUtf8(this.getProductVersion()), "undefined", this.googleAnalyticId, AnalyticsUtils.getMacAddressString(), this.urlEncodeWithUtf8(error.getLocalizedMessage()), "0");
            this.sendRecord(errorParametersString);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String buildParametersString(ActionDescription actionDescription) throws SocketException, UnknownHostException {
        String gaParametersString = String.format("v=1&an=%s&av=%s&cd=%s&tid=%s&cid=%s&t=event&ec=%s&ea=%s&el=%s&ev=1&sr=%s&cm1=%s&aip=1", this.urlEncodeWithUtf8(this.getProductInfo().getName()), this.urlEncodeWithUtf8(this.getProductVersion()), "undefined", this.googleAnalyticId, AnalyticsUtils.getMacAddressString(), this.urlEncodeWithUtf8(this.getEventCategory(actionDescription)), this.urlEncodeWithUtf8(this.getEventAction(actionDescription)), this.urlEncodeWithUtf8(this.getEventLabel(actionDescription)), this.getStrScreenSize(), this.urlEncodeWithUtf8(actionDescription.getSessionId()));
        switch (actionDescription.getCategory()) {
            case SESSION_START: {
                gaParametersString = gaParametersString + "&sc=start&ua=" + this.urlEncodeWithUtf8(this.getProductInfo().getName() + "/" + this.getProductVersion() + " (" + this.getOsName() + " " + this.getOsVersion() + ")");
                break;
            }
            case SESSION_STOP: {
                gaParametersString = gaParametersString + "&sc=end";
            }
        }
        return gaParametersString;
    }

    private HttpURLConnection initializeConnection() {
        try {
            URL url = new URL("http://www.google-analytics.com/collect");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            return connection;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void trackActiveScreen(String screenName) {
        try {
            String gaParametersString = String.format("v=1&an=%s&av=%s&cd=%s&tid=%s&cid=%s&t=screenview&cd=%s&sr=%s", this.urlEncodeWithUtf8(this.getProductInfo().getName()), this.urlEncodeWithUtf8(this.getProductVersion()), "undefined", this.googleAnalyticId, AnalyticsUtils.getMacAddressString(), this.urlEncodeWithUtf8(screenName), this.getStrScreenSize());
            this.sendRecord(gaParametersString);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean sendRecord(String parameters) {
        if (parameters == null) {
            return false;
        }
        HttpURLConnection connection = this.initializeConnection();
        if (connection == null) {
            return false;
        }
        try {
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(parameters);
            wr.flush();
            wr.close();
            int responseCode = connection.getResponseCode();
            return responseCode == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getEventCategory(ActionDescription actionDescription) {
        AnalyticsManager.Category category = actionDescription.getCategory();
        if (category == null) {
            return CATEGORY_INVALID;
        }
        switch (category) {
            case SESSION_START: 
            case SESSION_STOP: {
                return CATEGORY_SESSION;
            }
            case ACTION: {
                return CATEGORY_ACTION;
            }
        }
        return category.name();
    }

    private String getEventAction(ActionDescription actionDescription) {
        switch (actionDescription.getCategory()) {
            case SESSION_START: {
                return EVENT_START;
            }
            case SESSION_STOP: {
                return EVENT_STOP;
            }
        }
        return actionDescription.getActionName();
    }

    private String getEventLabel(ActionDescription actionDescription) {
        switch (actionDescription.getCategory()) {
            case SESSION_START: {
                return String.format("%s %s, %s; License: %s", this.getOsName(), this.getOsVersion(), this.getStrScreenSize(), this.getLicenseDescription());
            }
        }
        return actionDescription.getParamsAsString();
    }
}

