/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.tests;

import org.w3c.dom.Element;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.XPathAssertion;
import org.wsi.test.validator.bsp11.entrytypes.EncryptedDataEntryType;
import org.wsi.test.validator.bsp11.entrytypes.EncryptedHeaderEntryType;

public class BSP5624
extends XPathAssertion {
    public BSP5624(Element e) throws ValidatorException {
        super(e);
    }

    public boolean isApplicable(Entry e) {
        if (e instanceof EncryptedDataEntryType) {
            Element eHeader = (Element)e.getElement().getParentNode();
            if (EncryptedHeaderEntryType.getFactory().isValidElement(eHeader)) {
                String wsuId = eHeader.getAttributeNS(SecureConstants.WSU_NAMESPACE, "Id");
                if (wsuId != null && !wsuId.equals("")) {
                    EncryptedHeaderEntryType encHeader = (EncryptedHeaderEntryType)EncryptedHeaderEntryType.getFactory().newInstance(eHeader);
                    return encHeader.getReferringList() == null;
                }
                return true;
            }
        }
        return false;
    }

    public boolean applyRule(Entry entry) {
        String id = entry.getElement().getAttribute("Id");
        if (id != null) {
            EncryptedDataEntryType encData = (EncryptedDataEntryType)entry;
            return encData.getReferringList() != null;
        }
        return false;
    }
}

