/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.tests;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.entrytypes.BinarySecurityTokenEntryType;
import org.wsi.test.validator.bsp11.entrytypes.StrKeyIdentifierEntryType;

public class BSP5206
extends Assertion {
    public BSP5206(Element assertionEl) {
        super(assertionEl);
    }

    public boolean isApplicable(Entry e) {
        if (e instanceof StrKeyIdentifierEntryType) {
            NodeList bsTokens = e.getElement().getOwnerDocument().getDocumentElement().getElementsByTagNameNS(SecureConstants.WSSE_NAMESPACE, "BinarySecurityToken");
            int i = 0;
            while (i < bsTokens.getLength()) {
                Element el = (Element)bsTokens.item(i);
                BinarySecurityTokenEntryType token = (BinarySecurityTokenEntryType)BinarySecurityTokenEntryType.getFactory().newInstance(el);
                if (token.isX509Token()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean applyRule(Entry entry) {
        String valueType = entry.getElement().getAttribute("ValueType");
        if (valueType == null) {
            return false;
        }
        return valueType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier") || valueType.equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
    }
}

