/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.tests;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.entrytypes.EkDataReferenceEntryType;
import org.wsi.test.validator.bsp11.entrytypes.EkReferenceListEntryType;
import org.wsi.test.validator.bsp11.entrytypes.EncryptedDataEntryType;
import org.wsi.test.validator.bsp11.entrytypes.EncryptedKeyEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SecurityHeaderEntryType;

public class BSP3208
extends Assertion {
    public BSP3208(Element el) {
        super(el);
    }

    public boolean isApplicable(Entry e) {
        return e instanceof EncryptedKeyEntryType;
    }

    public boolean applyRule(Entry entry) throws ValidatorException {
        EncryptedKeyEntryType encryptedKeyEntry = (EncryptedKeyEntryType)entry;
        Element ekReferenceListElement = encryptedKeyEntry.getReferenceList();
        if (ekReferenceListElement == null) {
            return true;
        }
        EkReferenceListEntryType ekReferenceList = null;
        if (!EkReferenceListEntryType.getFactory().isValidElement(ekReferenceListElement)) {
            throw new ValidatorException("Problem fetching xenc:ReferenceList child of xenc:EncryptedKey");
        }
        ekReferenceList = (EkReferenceListEntryType)EkReferenceListEntryType.getFactory().newInstance(ekReferenceListElement);
        Element[] dataRefs = ekReferenceList.getDataReferenceElements();
        int i = 0;
        while (i < dataRefs.length) {
            if (EkDataReferenceEntryType.getFactory().isValidElement(dataRefs[i])) {
                Element encryptedData;
                EkDataReferenceEntryType dataRefEntryType = (EkDataReferenceEntryType)EkDataReferenceEntryType.getFactory().newInstance(dataRefs[i]);
                try {
                    encryptedData = dataRefEntryType.itemReferenced();
                }
                catch (ValidatorException e) {
                    return false;
                }
                if (encryptedData != null && EncryptedDataEntryType.getFactory().isValidElement(encryptedData)) {
                    Node secureHeaderChild = encryptedData;
                    Node parent = encryptedData.getParentNode();
                    while (parent.getNodeType() == 1 && !SecurityHeaderEntryType.getFactory().isValidElement((Element)parent)) {
                        secureHeaderChild = parent;
                        parent = parent.getParentNode();
                    }
                    if (parent.getNodeType() == 1) {
                        int dataSiblingCount = 0;
                        Node place = secureHeaderChild;
                        while (place != null) {
                            place = place.getPreviousSibling();
                            ++dataSiblingCount;
                        }
                        int keySiblingCount = 0;
                        place = encryptedKeyEntry.getElement();
                        while (place != null) {
                            place = place.getPreviousSibling();
                            ++keySiblingCount;
                        }
                        if (dataSiblingCount <= keySiblingCount) {
                            return false;
                        }
                    }
                }
            }
            ++i;
        }
        return true;
    }
}

