/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.tests;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.entrytypes.SecurityHeaderEntryType;
import org.wsi.test.validator.bsp11.entrytypes.StrReferenceEntryType;

public class BSP3066
extends Assertion {
    public BSP3066(Element el) {
        super(el);
    }

    public boolean isApplicable(Entry e) {
        if (!(e instanceof StrReferenceEntryType)) {
            return false;
        }
        StrReferenceEntryType strReferenceEntry = (StrReferenceEntryType)e;
        Element strReference = strReferenceEntry.getElement();
        String uri = strReference.getAttribute("URI");
        if (uri == null || uri.equals("") || uri.charAt(0) != '#') {
            return true;
        }
        return this.getMySecurityHeader(strReference) != null;
    }

    public boolean applyRule(Entry entry) throws ValidatorException {
        Element itemReferenced;
        StrReferenceEntryType strReferenceEntry = (StrReferenceEntryType)entry;
        Element strReference = strReferenceEntry.getElement();
        String uri = strReference.getAttribute("URI");
        if (uri == null || uri.equals("") || uri.charAt(0) != '#') {
            return true;
        }
        Element mySecurityHeader = this.getMySecurityHeader(strReference);
        if (mySecurityHeader == null) {
            throw new ValidatorException("Invalid state (should have been NA)");
        }
        try {
            itemReferenced = strReferenceEntry.itemReferenced();
        }
        catch (ValidatorException e) {
            return false;
        }
        if (itemReferenced == null) {
            return true;
        }
        Element refSecurityHeader = null;
        Node parent = strReference.getParentNode();
        parent = itemReferenced.getParentNode();
        while (parent.getNodeType() != 9 && refSecurityHeader == null) {
            if (SecurityHeaderEntryType.getFactory().isValidElement((Element)parent)) {
                refSecurityHeader = (Element)parent;
            }
            parent = parent.getParentNode();
        }
        if (refSecurityHeader == null) {
            throw new ValidatorException("Could not find SECURITY_HEADER parent of STR_REFERENCE");
        }
        int myCount = 0;
        Node currentNode = mySecurityHeader;
        while (currentNode != null) {
            currentNode = currentNode.getPreviousSibling();
            ++myCount;
        }
        int refCount = 0;
        currentNode = refSecurityHeader;
        while (currentNode != null) {
            currentNode = currentNode.getPreviousSibling();
            ++refCount;
        }
        return myCount == refCount;
    }

    private Element getMySecurityHeader(Element strReference) {
        Element mySecurityHeader = null;
        Node parent = strReference.getParentNode();
        while (parent.getNodeType() != 9 && mySecurityHeader == null) {
            if (SecurityHeaderEntryType.getFactory().isValidElement((Element)parent)) {
                mySecurityHeader = (Element)parent;
            }
            parent = parent.getParentNode();
        }
        return mySecurityHeader;
    }
}

