/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;

public abstract class XPathAssertion
extends Assertion {
    private static final XPath xp;
    private static final String TAD_EL_ASSERTIONDESC = "assertionDescription";
    private XPathExpression xpath;

    static {
        XPathFactory xpf = XPathFactory.newInstance();
        xp = xpf.newXPath();
        xp.setNamespaceContext(new Namespaces());
    }

    public XPathAssertion(Element el) throws ValidatorException {
        super(el);
        NodeList descriptionNL = el.getElementsByTagNameNS("http://www.ws-i.org/testing/2004/07/assertions/", TAD_EL_ASSERTIONDESC);
        if (descriptionNL.getLength() != 1) {
            throw new ValidatorException("Too many descriptions");
        }
        CharacterData textNode = (CharacterData)descriptionNL.item(0).getChildNodes().item(0);
        String xpathString = textNode.getData().trim();
        xpathString = xpathString.substring(1, xpathString.length() - 1);
        try {
            this.xpath = xp.compile(xpathString);
        }
        catch (XPathExpressionException e) {
            throw new ValidatorException((Exception)e);
        }
    }

    public boolean applyRule(Entry entry) throws ValidatorException {
        try {
            return (Boolean)this.xpath.evaluate(entry.getElement(), XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e) {
            throw new ValidatorException((Exception)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Namespaces
    implements NamespaceContext {
        private Namespaces() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("soap")) {
                return "http://schemas.xmlsoap.org/soap/envelope/";
            }
            if (prefix.equals("wsa")) {
                return "http://www.w3.org/2005/08/addressing";
            }
            if (prefix.equals("wsdl")) {
                return "http://schemas.xmlsoap.org/wsdl/";
            }
            if (prefix.equals("soapbind")) {
                return "http://schemas.xmlsoap.org/wsdl/soap/";
            }
            if (prefix.equals("xs")) {
                return "http://www.w3.org/2001/XMLSchema";
            }
            if (prefix.equals("wsse")) {
                return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            }
            if (prefix.equals("wsse11")) {
                return "http://docs.oasis-open.org/wss/oasis-wsswssecurity-secext-1.1.xsd";
            }
            if (prefix.equals("wsu")) {
                return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
            }
            if (prefix.equals("ds")) {
                return "http://www.w3.org/2000/09/xmldsig#";
            }
            if (prefix.equals("xenc")) {
                return "http://www.w3.org/2001/04/xmlenc#";
            }
            if (prefix.equals("saml")) {
                return "urn:oasis:names:tc:SAML:1.0:assertion";
            }
            throw new RuntimeException("Unknown prefix:  " + prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            throw new RuntimeException("Not yet implemented");
        }

        public Iterator<Object> getPrefixes(String namespaceURI) {
            throw new RuntimeException("Not yet implemented");
        }
    }
}

