/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11;

import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.wsi.test.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTestUtilities {
    public static Map<String, String> parseSchemaDateTime(String dt) throws ValidatorException {
        ValidatorException failure = new ValidatorException("Invalid dateTime string");
        int i = 0;
        if (dt.charAt(i) == '-') {
            ++i;
        }
        String yearString = "";
        while (Character.isDigit(dt.charAt(i))) {
            yearString = String.valueOf(yearString) + dt.charAt(i);
            ++i;
        }
        if (dt.charAt(i) != '-') {
            throw failure;
        }
        String monthString = dt.substring(++i, i + 2);
        if (dt.charAt(i += 2) != '-') {
            throw failure;
        }
        String dateString = dt.substring(++i, i + 2);
        SecurityTestUtilities.validateDateTimeDate(yearString, monthString, dateString);
        if (dt.charAt(i += 2) != 'T') {
            throw failure;
        }
        String hourString = dt.substring(++i, i + 2);
        if (dt.charAt(i += 2) != ':') {
            throw failure;
        }
        String minuteString = dt.substring(++i, i + 2);
        if (dt.charAt(i += 2) != ':') {
            throw failure;
        }
        String secondString = dt.substring(++i, i + 2);
        SecurityTestUtilities.validateDateTimeTime(hourString, minuteString, secondString);
        String fractionString = null;
        if (dt.charAt(i += 2) == '.') {
            ++i;
            fractionString = "";
            while (Character.isDigit(dt.charAt(i))) {
                fractionString = String.valueOf(fractionString) + dt.charAt(i);
                ++i;
            }
        }
        String timezoneString = dt.substring(i);
        SecurityTestUtilities.validateDateTimeTimezone(timezoneString);
        HashMap<String, String> returnMap = new HashMap<String, String>(3);
        returnMap.put("seconds", secondString);
        returnMap.put("fractionalSeconds", fractionString);
        returnMap.put("timezone", timezoneString);
        return returnMap;
    }

    private static void validateDateTimeDate(String yearString, String monthString, String dateString) throws ValidatorException {
        String yearNumerical;
        String string = yearNumerical = yearString.charAt(0) == '-' ? yearString.substring(1) : yearString;
        if (yearNumerical.equals("0000")) {
            throw new ValidatorException("DateTime parsing error:  0000 not allowed as year in DateTime");
        }
        if (yearNumerical.length() > 4 && yearNumerical.charAt(0) == '0') {
            throw new ValidatorException("DateTime parsing error:  Leading zeros not allowed in a year that is more than four digits");
        }
        int yearValue = Integer.valueOf(yearNumerical);
        if (monthString.length() != 2) {
            throw new ValidatorException("DateTime parsing error:  Month must be two digits");
        }
        int monthValue = Integer.valueOf(monthString);
        if (monthValue < 1 || monthValue > 12) {
            throw new ValidatorException("DateTime parsing error:  Illegal month value");
        }
        if (dateString.length() != 2) {
            throw new ValidatorException("DateTime parsing error:  Date must be two digits");
        }
        int dateValue = Integer.valueOf(dateString);
        if (dateValue < 1 || dateValue > 31) {
            throw new ValidatorException("DateTime parsing error:  Illegal date value");
        }
        GregorianCalendar cal = new GregorianCalendar(yearValue, monthValue - 1, dateValue);
        cal.setLenient(false);
        try {
            cal.getTime();
        }
        catch (Throwable t) {
            throw new ValidatorException("DateTime parsing error:  Illegal day specified");
        }
    }

    private static void validateDateTimeTime(String hourString, String minuteString, String secondString) throws ValidatorException {
        if (hourString.length() != 2) {
            throw new ValidatorException("DateTime parsing error:  Hour must be two digits");
        }
        int hourValue = Integer.valueOf(hourString);
        if (hourValue < 0 || hourValue > 24) {
            throw new ValidatorException("DateTime parsing error:  Illegal hour value");
        }
        if (minuteString.length() != 2) {
            throw new ValidatorException("DateTime parsing error:  Minute must be two digits");
        }
        int minuteValue = Integer.valueOf(minuteString);
        if (minuteValue < 0 || minuteValue > 59) {
            throw new ValidatorException("DateTime parsing error:  Illegal minute value");
        }
        if (secondString.length() != 2) {
            throw new ValidatorException("DateTime parsing error:  Second must be two digits");
        }
        int secondValue = Integer.valueOf(secondString);
        if (secondValue < 0 || secondValue > 60) {
            throw new ValidatorException("DateTime parsing error:  Illegal second value");
        }
        if (hourValue == 24 && minuteValue != 0 && secondValue != 0) {
            throw new ValidatorException("DateTime parsing error:  Illegal time value");
        }
    }

    private static void validateDateTimeTimezone(String timezoneString) {
    }

    public static void main(String[] args) {
        try {
            SecurityTestUtilities.parseSchemaDateTime("2002-02-30T12:00:00-05:00");
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        System.out.println("done");
    }
}

