/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.Artifact;
import org.wsi.test.validator.ArtifactResult;
import org.wsi.test.validator.Configuration;
import org.wsi.test.validator.TestAssertionsDocument;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.entrytypes.SecureEntryType;
import org.wsi.test.validator.service.ProfileService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureEnvelopeArtifact
extends Artifact {
    public SecureEnvelopeArtifact(Element el, ProfileService profile) throws ValidatorException {
        super(el, profile);
    }

    private List<Class<? extends SecureEntryType>> getEntryTypeClasses(TestAssertionsDocument tad) throws ValidatorException {
        ArrayList<Class<? extends SecureEntryType>> result = new ArrayList<Class<? extends SecureEntryType>>();
        for (String tag : (List)tad.getAllEntryTypeTags().get("secureEnvelope")) {
            if (tag.equals("anySecureEnvelope")) {
                tag = "secureEnvelope";
            }
            String className = String.valueOf(tag.substring(0, 1).toUpperCase()) + tag.substring(1) + "EntryType";
            Class<SecureEntryType> klass = null;
            try {
                klass = Class.forName("org.wsi.test.validator.bsp11.entrytypes." + className).asSubclass(SecureEntryType.class);
            }
            catch (ClassNotFoundException e) {
                throw new ValidatorException((Exception)e);
            }
            result.add(klass);
        }
        return result;
    }

    public ArtifactResult validate(Configuration config) throws ValidatorException {
        ArtifactResult result = new ArtifactResult(this.getType());
        List messageEntries = config.getLogFile().getMessageEntryElements();
        for (Class<? extends SecureEntryType> klass : this.getEntryTypeClasses(config.getTad())) {
            SecureEntryType.Factory factory = null;
            try {
                factory = (SecureEntryType.Factory)klass.getMethod("getFactory", null).invoke(null, null);
            }
            catch (Exception e) {
                throw new ValidatorException(e);
            }
            for (Element el : messageEntries) {
                Document doc;
                String id = el.getAttribute("ID");
                NodeList messageContentList = el.getChildNodes();
                Node messageContent = null;
                int j = 0;
                while (j < messageContentList.getLength()) {
                    if (messageContentList.item(j).getNodeType() == 1 && (messageContent = (Element)messageContentList.item(j)).getLocalName().equals("messageContent")) break;
                    ++j;
                }
                if (messageContent == null || !messageContent.getLocalName().equals("messageContent")) {
                    throw new ValidatorException("XML log file is invalid");
                }
                NodeList textList = messageContent.getChildNodes();
                if (textList.getLength() == 0) continue;
                if (textList.getLength() > 1) {
                    throw new ValidatorException("XML file is invalid");
                }
                CharacterData textNode = (CharacterData)textList.item(0);
                String xmlString = textNode.getData();
                ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                try {
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    doc = builder.parse(bais);
                }
                catch (Exception e) {
                    throw new ValidatorException(e);
                }
                SecureEntryType[] entries = factory.collectFromSoapEnvelope(doc.getDocumentElement());
                int j2 = 0;
                while (j2 < entries.length) {
                    result.addEntryResult(entries[j2].validate(this, id));
                    ++j2;
                }
            }
        }
        return result;
    }
}

