/*
 * Decompiled with CFR 0.152.
 */
import com.eviware.soapui.analytics.providers.BaseAnalyticsProvider;
import com.smartbear.analytics.ActionDescription;
import com.smartbear.analytics.AnalyticsManager;
import com.smartbear.analytics.AnalyticsUtils;
import java.io.DataOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;

public class GoogleAnalyticsProvider
extends BaseAnalyticsProvider {
    private static final String GA_ID = "UA-92447-22";
    private static final String CATEGORY_ACTION = "Action";
    private static final String CATEGORY_INVALID = "[Unknown]";
    private static final String EVENT_INVALID = "[Unknown]";
    private static final String NO_ACTIVE_SCREEN = "NoActiveScreen";
    private final String productName;
    private final String productVersion;

    public GoogleAnalyticsProvider(String productName, String productVersion) {
        this.productName = productName;
        this.productVersion = productVersion;
    }

    @Override
    public void trackAction(ActionDescription actionDescription) {
        try {
            this.sendRecord(this.buildParametersString(actionDescription));
            this.trackActiveScreen(actionDescription.getActionName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String urlEncodeWithUtf8(String input) {
        try {
            return URLEncoder.encode(input == null ? "" : input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Unexpected error: charset UTF-8 not available", e);
        }
    }

    String buildParametersString(ActionDescription actionDescription) throws SocketException, UnknownHostException {
        return String.format("v=1&an=%s&av=%s&cd=%s&tid=%s&cid=%s&t=event&ec=%s&ea=%s&el=%s&ev=1&sr=%s&cm1=%s&aip=1", GoogleAnalyticsProvider.urlEncodeWithUtf8(this.productName), GoogleAnalyticsProvider.urlEncodeWithUtf8(this.productVersion), "undefined", GA_ID, AnalyticsUtils.getMacAddressString(), GoogleAnalyticsProvider.urlEncodeWithUtf8(this.getEventCategory(actionDescription)), GoogleAnalyticsProvider.urlEncodeWithUtf8(this.getEventAction(actionDescription)), GoogleAnalyticsProvider.urlEncodeWithUtf8(actionDescription.getParamsAsString()), this.getStrScreenSize(), GoogleAnalyticsProvider.urlEncodeWithUtf8(actionDescription.getSessionId()));
    }

    private HttpURLConnection initializeConnection() {
        try {
            URL url = new URL("http://www.google-analytics.com/collect");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            return connection;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void trackActiveScreen(String screenName) {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            StringBuilder sb = new StringBuilder();
            if (network != null) {
                byte[] mac;
                for (byte aMac : mac = network.getHardwareAddress()) {
                    sb.append(String.format("%d", aMac));
                }
            } else {
                sb.append(NO_ACTIVE_SCREEN);
            }
            String gaParametersString = String.format("v=1&an=%s&av=%s&cd=%s&tid=%s&cid=%s&t=screenview&cd=%s&sr=%s", GoogleAnalyticsProvider.urlEncodeWithUtf8(this.productName), GoogleAnalyticsProvider.urlEncodeWithUtf8(this.productVersion), "undefined", GA_ID, sb.toString(), GoogleAnalyticsProvider.urlEncodeWithUtf8(screenName), this.getStrScreenSize());
            this.sendRecord(gaParametersString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean sendRecord(String parameters) {
        if (parameters == null) {
            return false;
        }
        HttpURLConnection connection = this.initializeConnection();
        if (connection == null) {
            return false;
        }
        try {
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(parameters);
            wr.flush();
            wr.close();
            int responseCode = connection.getResponseCode();
            return responseCode == 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String getEventCategory(ActionDescription actionDescription) {
        if (actionDescription.getCategory().equals((Object)AnalyticsManager.Category.ACTION)) {
            return CATEGORY_ACTION;
        }
        return "[Unknown]";
    }

    private String getEventAction(ActionDescription actionDescription) {
        if (actionDescription.getCategory().equals((Object)AnalyticsManager.Category.ACTION)) {
            return actionDescription.getActionName();
        }
        return "[Unknown]";
    }
}

