/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.CallbackLookup;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityEngine {
    private static Log log = LogFactory.getLog(WSSecurityEngine.class);
    private WSSConfig wssConfig = null;
    private boolean doDebug = false;
    private CallbackLookup callbackLookup = null;
    public static final QName BINARY_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
    public static final QName USERNAME_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    public static final QName TIMESTAMP = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
    public static final QName SIGNATURE_CONFIRMATION = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "SignatureConfirmation");
    public static final QName SIGNATURE = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    public static final QName ENCRYPTED_KEY = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
    public static final QName ENCRYPTED_DATA = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
    public static final QName REFERENCE_LIST = new QName("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
    public static final QName SAML_TOKEN = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
    public static final QName SAML2_TOKEN = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
    public static final QName ENCRYPTED_ASSERTION = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
    public static final QName DERIVED_KEY_TOKEN_05_02 = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "DerivedKeyToken");
    public static final QName SECURITY_CONTEXT_TOKEN_05_02 = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "SecurityContextToken");
    public static final QName DERIVED_KEY_TOKEN_05_12 = new QName("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "DerivedKeyToken");
    public static final QName SECURITY_CONTEXT_TOKEN_05_12 = new QName("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "SecurityContextToken");

    public final WSSConfig getWssConfig() {
        if (this.wssConfig == null) {
            this.wssConfig = WSSConfig.getNewInstance();
        }
        return this.wssConfig;
    }

    public final WSSConfig setWssConfig(WSSConfig cfg) {
        WSSConfig ret = this.wssConfig;
        this.wssConfig = cfg;
        return ret;
    }

    public void setCallbackLookup(CallbackLookup callbackLookup) {
        this.callbackLookup = callbackLookup;
    }

    public CallbackLookup getCallbackLookup() {
        return this.callbackLookup;
    }

    public List<WSSecurityEngineResult> processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        return this.processSecurityHeader(doc, actor, cb, crypto, crypto);
    }

    public List<WSSecurityEngineResult> processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug((Object)"enter processSecurityHeader()");
        }
        if (actor == null) {
            actor = "";
        }
        List<WSSecurityEngineResult> wsResult = null;
        Element elem = WSSecurityUtil.getSecurityHeader(doc, actor);
        if (elem != null) {
            if (this.doDebug) {
                log.debug((Object)("Processing WS-Security header for '" + actor + "' actor."));
            }
            wsResult = this.processSecurityHeader(elem, cb, sigCrypto, decCrypto);
        }
        return wsResult;
    }

    public List<WSSecurityEngineResult> processSecurityHeader(Element securityHeader, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto) throws WSSecurityException {
        RequestData data = new RequestData();
        data.setWssConfig(this.getWssConfig());
        data.setDecCrypto(decCrypto);
        data.setSigCrypto(sigCrypto);
        data.setCallbackHandler(cb);
        return this.processSecurityHeader(securityHeader, data);
    }

    public List<WSSecurityEngineResult> processSecurityHeader(Element securityHeader, RequestData requestData) throws WSSecurityException {
        ArrayList<WSSecurityEngineResult> returnResults = new ArrayList<WSSecurityEngineResult>();
        if (securityHeader == null) {
            return returnResults;
        }
        if (requestData.getWssConfig() == null) {
            requestData.setWssConfig(this.getWssConfig());
        }
        WSDocInfo wsDocInfo = new WSDocInfo(securityHeader.getOwnerDocument());
        wsDocInfo.setCallbackLookup(this.callbackLookup);
        wsDocInfo.setCrypto(requestData.getSigCrypto());
        wsDocInfo.setSecurityHeader(securityHeader);
        WSSConfig cfg = this.getWssConfig();
        Node node = securityHeader.getFirstChild();
        boolean foundTimestamp = false;
        while (node != null) {
            Node nextSibling = node.getNextSibling();
            if (1 == node.getNodeType()) {
                Processor p;
                QName el = new QName(node.getNamespaceURI(), node.getLocalName());
                if (requestData.getWssConfig().isWsiBSPCompliant()) {
                    if (foundTimestamp && el.equals(TIMESTAMP)) {
                        if (this.doDebug) {
                            log.debug((Object)"Failure on processing multiple Timestamps as per the BSP");
                        }
                        throw new WSSecurityException(4, "invalidTimestamp");
                    }
                    if (el.equals(TIMESTAMP)) {
                        foundTimestamp = true;
                    }
                }
                if ((p = cfg.getProcessor(el)) != null) {
                    List<WSSecurityEngineResult> results = p.handleToken((Element)node, requestData, wsDocInfo);
                    if (!results.isEmpty()) {
                        returnResults.addAll(0, results);
                    }
                } else if (this.doDebug) {
                    log.debug((Object)("Unknown Element: " + node.getLocalName() + " " + node.getNamespaceURI()));
                }
            }
            if (node.getNextSibling() == null && nextSibling != null) {
                node = nextSibling;
                continue;
            }
            node = node.getNextSibling();
        }
        return returnResults;
    }
}

