/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp10.tests;

import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp10.ExtensibleSecurityTokenProfile;
import org.wsi.test.validator.bsp10.ProfileServiceBSP10;
import org.wsi.test.validator.bsp10.entrytypes.BinarySecurityTokenEntryType;
import org.wsi.test.validator.bsp10.entrytypes.SecurityTokenReferenceEntryType;
import org.wsi.test.validator.bsp10.entrytypes.StrEmbeddedEntryType;

public class BSP3060
extends Assertion {
    public BSP3060(Element element) {
        super(element);
    }

    public boolean isApplicable(Entry entry) {
        return entry instanceof StrEmbeddedEntryType;
    }

    private boolean isInternalSecurityToken(Element element) throws ValidatorException {
        if (BinarySecurityTokenEntryType.getFactory().isValidElement(element)) {
            return true;
        }
        if (SecurityTokenReferenceEntryType.getFactory().isValidElement(element)) {
            return true;
        }
        List<ExtensibleSecurityTokenProfile> list = ProfileServiceBSP10.getSecurityTokenExtensions();
        for (ExtensibleSecurityTokenProfile extensibleSecurityTokenProfile : list) {
            if (!extensibleSecurityTokenProfile.isValidElement(element)) continue;
            return true;
        }
        return false;
    }

    public boolean applyRule(Entry entry) throws ValidatorException {
        Element element = entry.getElement();
        NodeList nodeList = element.getChildNodes();
        boolean bl = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (bl) {
                return false;
            }
            bl = true;
            if (this.isInternalSecurityToken((Element)node)) continue;
            return false;
        }
        return bl;
    }
}

