/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp10.entrytypes;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.test.validator.bsp10.SecureConstants;
import org.wsi.test.validator.bsp10.entrytypes.SecureEntryType;
import org.wsi.test.validator.bsp10.entrytypes.SoapHeaderEntryType;

public class HeaderElementEntryType
extends SecureEntryType {
    private static Factory fInstance = new Factory();

    public static Factory getFactory() {
        return fInstance;
    }

    private HeaderElementEntryType(Element element) {
        super(element);
    }

    public String getEntryTypeTag() {
        return "headerElement";
    }

    protected String getSoapRoleIdString() {
        Element element = this.getElement();
        if (element.hasAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor")) {
            return element.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor");
        }
        return SecureConstants.SOAP_ROLE_ULTIMATE_RECEIVER_TAG;
    }

    protected String getUniqueIdString() {
        String string = super.getWsuIdOrId();
        if (string == null) {
            string = this.getSoapRoleIdString();
        }
        return string;
    }

    public static class Factory
    extends SecureEntryType.Factory {
        private Factory() {
        }

        public SecureEntryType newInstance(Element element) {
            return new HeaderElementEntryType(element);
        }

        public boolean isValidElement(Element element) {
            Node node = element.getParentNode();
            if (node.getNodeType() != 1) {
                return false;
            }
            Element element2 = (Element)node;
            return SoapHeaderEntryType.getFactory().isValidElement(element2);
        }
    }
}

