/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp10;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;

public abstract class XPathAssertion
extends Assertion {
    private static final XPath xp;
    private static final String TAD_EL_ASSERTIONDESC = "assertionDescription";
    private XPathExpression xpath;

    public XPathAssertion(Element element) throws ValidatorException {
        super(element);
        NodeList nodeList = element.getElementsByTagNameNS("http://www.ws-i.org/testing/2004/07/assertions/", TAD_EL_ASSERTIONDESC);
        if (nodeList.getLength() != 1) {
            throw new ValidatorException("Too many descriptions");
        }
        CharacterData characterData = (CharacterData)nodeList.item(0).getChildNodes().item(0);
        String string = characterData.getData().trim();
        string = string.substring(1, string.length() - 1);
        try {
            this.xpath = xp.compile(string);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new ValidatorException((Exception)xPathExpressionException);
        }
    }

    public boolean applyRule(Entry entry) throws ValidatorException {
        try {
            return (Boolean)this.xpath.evaluate(entry.getElement(), XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new ValidatorException((Exception)xPathExpressionException);
        }
    }

    static {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        xp = xPathFactory.newXPath();
        xp.setNamespaceContext(new Namespaces());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Namespaces
    implements NamespaceContext {
        private Namespaces() {
        }

        @Override
        public String getNamespaceURI(String string) {
            if (string.equals("soap")) {
                return "http://schemas.xmlsoap.org/soap/envelope/";
            }
            if (string.equals("wsa")) {
                return "http://www.w3.org/2005/08/addressing";
            }
            if (string.equals("wsdl")) {
                return "http://schemas.xmlsoap.org/wsdl/";
            }
            if (string.equals("soapbind")) {
                return "http://schemas.xmlsoap.org/wsdl/soap/";
            }
            if (string.equals("xs")) {
                return "http://www.w3.org/2001/XMLSchema";
            }
            if (string.equals("wsse")) {
                return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            }
            if (string.equals("wsu")) {
                return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
            }
            if (string.equals("ds")) {
                return "http://www.w3.org/2000/09/xmldsig#";
            }
            if (string.equals("xenc")) {
                return "http://www.w3.org/2001/04/xmlenc#";
            }
            if (string.equals("saml")) {
                return "urn:oasis:names:tc:SAML:1.0:assertion";
            }
            throw new RuntimeException("Unknown prefix:  " + string);
        }

        @Override
        public String getPrefix(String string) {
            throw new RuntimeException("Not yet implemented");
        }

        public Iterator<Object> getPrefixes(String string) {
            throw new RuntimeException("Not yet implemented");
        }
    }
}

