/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp10;

import java.lang.reflect.Constructor;
import java.util.List;
import org.w3c.dom.Element;
import org.wsi.test.validator.Artifact;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Configuration;
import org.wsi.test.validator.ServiceExtension;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp10.ExtensibleSecurityTokenProfile;
import org.wsi.test.validator.bsp10.SecureEnvelopeArtifact;
import org.wsi.test.validator.service.ProfileService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServiceBSP10
implements ProfileService {
    private static final String TAD_ATTRIB_ASSERTIONID = "id";
    private static final String TAD_ATTRIB_TYPE = "type";

    public Assertion getAssertion(Element element) throws ValidatorException {
        String string = element.getAttribute(TAD_ATTRIB_ASSERTIONID);
        try {
            String string2 = "org.wsi.test.validator.bsp10.tests." + string;
            Class<Assertion> clazz = Class.forName(string2).asSubclass(Assertion.class);
            Constructor<Assertion> constructor = clazz.getConstructor(Element.class);
            Assertion assertion = constructor.newInstance(element);
            return assertion;
        }
        catch (Exception exception) {
            if (!string.startsWith("BSP699")) {
                throw new ValidatorException(exception);
            }
            return null;
        }
    }

    public static List<ExtensibleSecurityTokenProfile> getSecurityTokenExtensions() throws ValidatorException {
        return new ServiceExtension("org.wsi.test.validator.bsp10.tokenprofiles.txt").getServiceInstances();
    }

    public Artifact getArtifact(Element element) throws ValidatorException {
        String string = element.getAttribute(TAD_ATTRIB_TYPE);
        if (string.equals("secureEnvelope")) {
            return new SecureEnvelopeArtifact(element, this);
        }
        return null;
    }

    public String getReportNamespace() {
        return "http://www.ws-i.org/testing/2004/07/report/";
    }

    public String getConformanceReportTitle() {
        return "WS-I Basic Security Profile Conformance Report";
    }

    public Configuration getConfiguration(String string) throws ValidatorException {
        return new Configuration(string, (ProfileService)this);
    }

    public String getReleaseDateString() {
        return "2007-11-03";
    }

    public String getReleaseYearString() {
        return "2007";
    }

    public String getVersionString() {
        return "1.0.1 [BSP 1.0]";
    }
}

