/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptJobManagerImpl
implements JavaScriptJobManager {
    private static final long serialVersionUID = 9212855747249248967L;
    private transient WeakReference<WebWindow> window_;
    private transient ScheduledThreadPoolExecutor executor_;
    private transient Map<Integer, ScheduledFuture<?>> futures_;
    private transient List<JavaScriptJob> currentlyRunningJobs_;
    private static final AtomicInteger NEXT_JOB_ID = new AtomicInteger(1);
    private static final AtomicInteger NEXT_THREAD_ID = new AtomicInteger(1);
    private static final int PRIORITY = Math.min(10, Thread.currentThread().getPriority() + 1);
    private static final Log LOG = LogFactory.getLog(JavaScriptJobManagerImpl.class);
    private Thread executorThread_;

    public JavaScriptJobManagerImpl(WebWindow window) {
        this.init(window);
    }

    private void init(WebWindow window) {
        this.window_ = new WeakReference<WebWindow>(window);
        this.executor_ = new ScheduledThreadPoolExecutor(1);
        this.futures_ = new TreeMap();
        this.currentlyRunningJobs_ = new ArrayList<JavaScriptJob>();
        this.executor_.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                String name = "JavaScript Job Thread " + NEXT_THREAD_ID.getAndIncrement();
                JavaScriptJobManagerImpl.this.executorThread_ = new Thread(r, name);
                JavaScriptJobManagerImpl.this.executorThread_.setDaemon(true);
                JavaScriptJobManagerImpl.this.executorThread_.setPriority(PRIORITY);
                return JavaScriptJobManagerImpl.this.executorThread_;
            }
        });
    }

    @Override
    public int getJobCount() {
        if (this.executor_.isShutdown()) {
            return 0;
        }
        int count1 = Integer.MIN_VALUE;
        int count2 = Integer.MAX_VALUE;
        while (count1 != count2) {
            count1 = this.getJobCountInner();
            this.sleep(10L);
            count2 = this.getJobCountInner();
        }
        return count1;
    }

    private synchronized int getJobCountInner() {
        this.executor_.purge();
        return (int)(this.executor_.getTaskCount() - this.executor_.getCompletedTaskCount());
    }

    @Override
    public synchronized int addJob(JavaScriptJob job, Page page) {
        WebWindow w = this.getWindow();
        if (w == null) {
            return 0;
        }
        if (w.getEnclosedPage() != page) {
            return 0;
        }
        int id = NEXT_JOB_ID.getAndIncrement();
        job.setId(id);
        ExecutingJobTracker jobWrapper = new ExecutingJobTracker(job);
        ScheduledFuture<?> future = job.isPeriodic() ? this.executor_.scheduleAtFixedRate(jobWrapper, job.getInitialDelay(), job.getPeriod().intValue(), TimeUnit.MILLISECONDS) : this.executor_.schedule(jobWrapper, (long)job.getInitialDelay(), TimeUnit.MILLISECONDS);
        this.futures_.put(id, future);
        LOG.debug((Object)("Added job: " + job + "."));
        return id;
    }

    @Override
    public synchronized void removeJob(int id) {
        ScheduledFuture<?> future = this.futures_.remove(id);
        if (future != null) {
            LOG.debug((Object)("Removing job " + id + "."));
            future.cancel(false);
            LOG.debug((Object)("Removed job " + id + "."));
        }
    }

    @Override
    public synchronized void stopJob(int id) {
        Future future = this.futures_.remove(id);
        if (future != null) {
            LOG.debug((Object)("Stopping job " + id + "."));
            future.cancel(true);
            LOG.debug((Object)("Stopped job " + id + "."));
        }
    }

    @Override
    public synchronized void removeAllJobs() {
        LOG.debug((Object)"Removing all jobs.");
        int count = 0;
        for (ScheduledFuture<?> future : this.futures_.values()) {
            future.cancel(false);
            ++count;
        }
        this.futures_.clear();
        if (count > 0) {
            LOG.debug((Object)("Removed all jobs (" + count + ")."));
        }
    }

    @Override
    public int waitForJobs(long timeoutMillis) {
        LOG.debug((Object)("Waiting for all jobs to finish (will wait max " + timeoutMillis + " millis)."));
        if (timeoutMillis > 0L) {
            long start = System.currentTimeMillis();
            long interval = Math.min(timeoutMillis, 100L);
            while (this.getJobCount() > 0 && System.currentTimeMillis() - start < timeoutMillis) {
                this.sleep(interval);
            }
        }
        int jobs = this.getJobCount();
        LOG.debug((Object)("Finished waiting for all jobs to finish (final job count is " + jobs + ")."));
        return jobs;
    }

    @Override
    public int waitForJobsStartingBefore(long delayMillis) {
        LOG.debug((Object)("Waiting for all jobs to finish that start within " + delayMillis + " millis."));
        long maxStartTime = System.currentTimeMillis() + delayMillis;
        try {
            ScheduledFuture<?> lastJobWithinDelay = this.getLastJobStartingBefore(maxStartTime);
            if (lastJobWithinDelay == null) {
                this.waitForCurrentlyRunningJobs();
                lastJobWithinDelay = this.getLastJobStartingBefore(maxStartTime);
            }
            while (lastJobWithinDelay != null) {
                this.waitForCompletion(lastJobWithinDelay);
                this.waitForCurrentlyRunningJobs();
                lastJobWithinDelay = this.getLastJobStartingBefore(maxStartTime);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        int jobs = this.getJobCount();
        LOG.debug((Object)("Finished waiting for all jobs to finish (final job count is " + jobs + ")."));
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCurrentlyRunningJobs() throws InterruptedException {
        List<JavaScriptJob> list = this.currentlyRunningJobs_;
        synchronized (list) {
            while (!this.currentlyRunningJobs_.isEmpty()) {
                JavaScriptJob job = this.currentlyRunningJobs_.get(0);
                while (this.currentlyRunningJobs_.contains(job)) {
                    this.currentlyRunningJobs_.wait();
                }
            }
        }
    }

    private synchronized ScheduledFuture<?> getLastJobStartingBefore(long maxStartTime) {
        long currentDelay = Long.MIN_VALUE;
        ScheduledFuture<?> job = null;
        long maxAllowedDelay = maxStartTime - System.currentTimeMillis();
        for (ScheduledFuture<?> future : this.futures_.values()) {
            long delay = future.getDelay(TimeUnit.MILLISECONDS);
            if (future.isDone() || delay <= currentDelay || delay >= maxAllowedDelay && delay > 0L) continue;
            currentDelay = delay;
            job = future;
        }
        LOG.debug((Object)("Last job starting before " + maxStartTime + ": " + job + "."));
        return job;
    }

    private boolean waitForCompletion(ScheduledFuture<?> job) {
        try {
            long delay = job.getDelay(TimeUnit.MILLISECONDS);
            LOG.debug((Object)("Waiting for completion of job starting in " + delay + "ms: " + job));
            job.get(delay + 100L, TimeUnit.MILLISECONDS);
            LOG.debug((Object)("Job done: " + job.isDone() + "."));
        }
        catch (CancellationException e) {
            LOG.debug((Object)("Job cancelled: " + job + "."));
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (ExecutionException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized void shutdown() {
        this.executor_.purge();
        List<Runnable> neverStartedTasks = this.executor_.shutdownNow();
        this.futures_.clear();
        if (this.executorThread_ != null) {
            try {
                this.executorThread_.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.executorThread_.isAlive()) {
                LOG.warn((Object)("Executor thread " + this.executorThread_.getName() + " still alive"));
            }
        }
        if (this.getJobCount() - neverStartedTasks.size() > 0) {
            LOG.warn((Object)("jobCount: " + this.getJobCount() + "(taskCount: " + this.executor_.getTaskCount() + ", completedTaskCount: " + this.executor_.getCompletedTaskCount() + ", never started tasks: " + neverStartedTasks.size() + ")"));
        }
    }

    private WebWindow getWindow() {
        return (WebWindow)this.window_.get();
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.window_.get());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        WebWindow window = (WebWindow)in.readObject();
        this.init(window);
    }

    class ExecutingJobTracker
    implements Runnable {
        private final JavaScriptJob job_;

        ExecutingJobTracker(JavaScriptJob job) {
            this.job_ = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.debug((Object)("Running job " + this.job_));
            List list = JavaScriptJobManagerImpl.this.currentlyRunningJobs_;
            synchronized (list) {
                JavaScriptJobManagerImpl.this.currentlyRunningJobs_.add(this.job_);
                JavaScriptJobManagerImpl.this.currentlyRunningJobs_.notifyAll();
            }
            try {
                this.job_.run();
            }
            catch (RuntimeException e) {
                LOG.error((Object)("Job run failed with unexpected RuntimeException: " + e.getMessage()), (Throwable)e);
                throw e;
            }
            finally {
                List list2 = JavaScriptJobManagerImpl.this.currentlyRunningJobs_;
                synchronized (list2) {
                    JavaScriptJobManagerImpl.this.currentlyRunningJobs_.remove(this.job_);
                    JavaScriptJobManagerImpl.this.currentlyRunningJobs_.notifyAll();
                }
            }
        }
    }
}

