/*
 * Decompiled with CFR 0.152.
 */
package hermes.util;

import hermes.Domain;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;

public class JMSUtils {
    public static String getFilenameFromMessageID(String messageId) {
        return messageId.replace('/', '_').replace(':', '_').replace('\\', '_').replace("<", "_").replace(">", "_");
    }

    public static void closeQuietly(QueueBrowser browser) {
        try {
            if (browser != null) {
                browser.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public static boolean isQueue(Connection o) {
        return o instanceof QueueConnection;
    }

    public static boolean isQueue(ConnectionFactory o) {
        return o instanceof QueueConnectionFactory;
    }

    public static boolean isQueue(Destination o) {
        return Domain.getDomain(o) == Domain.QUEUE;
    }

    public static boolean isQueue(MessageConsumer o) {
        return o instanceof QueueReceiver;
    }

    public static boolean isQueue(MessageProducer o) {
        return o instanceof QueueSender;
    }

    public static boolean isQueue(Session o) {
        return o instanceof QueueSession;
    }

    public static String getDestinationName(Destination to) {
        if (to == null) {
            return "";
        }
        try {
            if (JMSUtils.isQueue(to)) {
                return ((Queue)to).getQueueName();
            }
            return ((Topic)to).getTopicName();
        }
        catch (JMSException ex) {
            return ex.getMessage();
        }
    }
}

