/*
 * Decompiled with CFR 0.152.
 */
package hermes.taglib;

import hermes.Domain;
import hermes.Hermes;
import hermes.taglib.DestinationStatisticsBean;
import hermes.taglib.HermesSessionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.jms.Destination;
import javax.jms.Message;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;

public class InquireTag
extends TagSupport {
    private static final Logger log = Logger.getLogger(InquireTag.class);
    private static FastDateFormat dateFormat = FastDateFormat.getInstance((String)"MM/dd/yyyy HH:mm:ss");
    private String hermes;
    private String destination;
    private String var;
    private String collection;

    public int doEndTag() throws JspException {
        try {
            String lDestination = this.destination;
            String lHermes = this.hermes;
            if (lDestination == null) {
                lDestination = (String)this.pageContext.getAttribute("destination", 1);
            }
            if (lHermes == null) {
                lHermes = (String)this.pageContext.getAttribute("hermes", 1);
            }
            if (this.var == null) {
                this.var = "inquire";
            }
            DestinationStatisticsBean sbean = new DestinationStatisticsBean();
            Hermes h = HermesSessionManager.getHermes(this.pageContext, lHermes);
            Destination d = h.getDestination(lDestination, Domain.QUEUE);
            sbean.setName(lDestination);
            sbean.setHermes(lHermes);
            int depth = 0;
            try {
                sbean.setDepth(depth);
            }
            catch (Exception e) {
                sbean.setDepth(0);
            }
            try {
                Message m;
                if (depth > 0 && (m = h.receiveNoWait(d)) != null) {
                    sbean.setOldest(new Date(m.getJMSTimestamp()));
                }
            }
            catch (Exception e) {
                sbean.setOldest(null);
            }
            if (h.getTransacted()) {
                h.rollback();
            }
            this.pageContext.setAttribute(this.var, (Object)sbean, 1);
            if (this.collection != null) {
                Collection<DestinationStatisticsBean> c;
                if (this.pageContext.getAttribute(this.collection, 1) == null) {
                    c = new ArrayList();
                    this.pageContext.setAttribute(this.collection, c, 1);
                } else {
                    c = (Collection)this.pageContext.getAttribute(this.collection, 1);
                }
                c.add(sbean);
            }
            return 0;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return 0;
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getHermes() {
        return this.hermes;
    }

    public void setHermes(String hermes) {
        this.hermes = hermes;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }
}

