/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import com.jidesoft.swing.FolderChooser;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.BrowserAction;
import hermes.swing.actions.BrowseActionListenerAdapter;
import hermes.swing.actions.DirectoryCache;
import hermes.util.JMSUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.jms.Message;
import org.apache.log4j.Logger;

public class SaveMessagesIndividuallyAsXMLAction
extends BrowseActionListenerAdapter {
    private static final Logger log = Logger.getLogger(SaveMessagesIndividuallyAsXMLAction.class);

    public SaveMessagesIndividuallyAsXMLAction() {
        this.putValue("Name", "Save individually as XML...");
        this.putValue("ShortDescription", "Save selected messages encoded a XML in separate files.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.messages.save.xml.one"));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            BrowserAction action;
            if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof BrowserAction && (action = (BrowserAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument()).getSelectedMessages().size() > 0) {
                FolderChooser chooser = DirectoryCache.lastSaveAsDirectory == null ? new FolderChooser(new File(HermesBrowser.getBrowser().getRepositoryManager().getDirectory())) : new FolderChooser(DirectoryCache.lastSaveAsDirectory);
                if (chooser.showDialog((Component)((Object)HermesBrowser.getBrowser()), "Select directory for messages") == 0) {
                    DirectoryCache.lastSaveAsDirectory = chooser.getSelectedFile();
                    for (Message m : action.getSelectedMessages()) {
                        String filename = DirectoryCache.lastSaveAsDirectory.getAbsolutePath() + File.separator + JMSUtils.getFilenameFromMessageID(m.getJMSMessageID()) + ".xml";
                        File file = new File(filename);
                        FileOutputStream ostream = new FileOutputStream(file);
                        log.debug((Object)("saving message as " + filename));
                        action.getHermes().toXML(m, (OutputStream)ostream);
                        ostream.close();
                    }
                    if (action.getSelectedMessages().size() == 1) {
                        Hermes.ui.getDefaultMessageSink().add("Message saved");
                    } else {
                        Hermes.ui.getDefaultMessageSink().add(action.getSelectedMessages().size() + " messages saved");
                    }
                } else {
                    Hermes.ui.getDefaultMessageSink().add("Save messages cancelled");
                }
            }
        }
        catch (Exception e) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to save: ", e);
        }
    }
}

