/*
 * Decompiled with CFR 0.152.
 */
package hermes.store.schema;

import hermes.Domain;
import hermes.Hermes;
import hermes.MessageFactory;
import hermes.browser.HermesBrowser;
import hermes.impl.DefaultXMLHelper;
import hermes.impl.XMLHelper;
import hermes.store.MessageStore;
import hermes.store.MessageStoreQueue;
import hermes.store.MessageStoreTopic;
import hermes.store.jdbc.MessageResultSetHandler;
import hermes.store.schema.JDBCAdapter;
import hermes.store.schema.Statements;
import hermes.util.JMSUtils;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.swing.ProgressMonitor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.log4j.Logger;
import org.apache.tools.ant.filters.StringInputStream;

public class DefaultJDBCAdapter
implements JDBCAdapter {
    private static final Logger log = Logger.getLogger(DefaultJDBCAdapter.class);
    private XMLHelper xmlHelper = new DefaultXMLHelper();
    private int maxMessageSize = 0x100000;
    private long messageIdSequence = System.currentTimeMillis();
    private Statements statements;

    public DefaultJDBCAdapter() throws IOException {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("default Derby JDBC driver not loaded: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void setStatements(Statements statements) {
        this.statements = statements;
    }

    @Override
    public Collection<String> getStores(Connection connection) throws SQLException {
        QueryRunner runner = new QueryRunner();
        final ArrayList<String> stores = new ArrayList<String>();
        Hermes.ui.getDefaultMessageSink().add("Getting message stores....");
        runner.query(connection, this.statements.getStoresStatement(), new ResultSetHandler(){

            public Object handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    stores.add(rs.getString(1));
                }
                return stores;
            }
        });
        Hermes.ui.getDefaultMessageSink().add("Getting message stores.... done.");
        return stores;
    }

    @Override
    public void remove(Connection connection, String storeId) throws SQLException {
        QueryRunner runner = new QueryRunner();
        for (String statment : this.statements.getRemoveStoreStatements()) {
            runner.update(connection, statment, new Object[]{storeId});
        }
    }

    private synchronized String getNextMessageId(String storeId) {
        return "ID:" + storeId + "-" + this.messageIdSequence++;
    }

    @Override
    public void insert(Connection connection, String storeId, Message message) throws SQLException, JMSException {
        String destinationName = message.getJMSDestination() == null ? "default" : JMSUtils.getDestinationName(message.getJMSDestination());
        Domain domain = message.getJMSDestination() == null ? Domain.QUEUE : Domain.getDomain(message.getJMSDestination());
        String messageAsXMLString = this.xmlHelper.toXML(message);
        StringInputStream messageAsXML = new StringInputStream(messageAsXMLString);
        String messageId = this.getNextMessageId(storeId);
        PreparedStatement pstmt = connection.prepareStatement("insert into messages values (?, ?)");
        pstmt.setString(1, messageId);
        pstmt.setAsciiStream(2, (InputStream)messageAsXML, messageAsXMLString.length());
        pstmt.execute();
        pstmt.close();
        QueryRunner runner = new QueryRunner();
        runner.update(connection, "insert into stores values (?, ?, ?, ?)", new Object[]{storeId, destinationName, domain.getId(), messageId});
    }

    @Override
    public void remove(Connection connection, String storeId, String destination) throws SQLException, JMSException {
        QueryRunner runner = new QueryRunner();
        if (runner.update(connection, "delete from messages where messageid in (select messageid from stores where storeid=? and destination=?)", new Object[]{storeId, destination}) > 0) {
            runner.update(connection, "delete from stores where storeid=? and destination=?", new Object[]{storeId, destination});
        }
    }

    @Override
    public void remove(Connection connection, String storeId, Message message) throws SQLException, JMSException {
        QueryRunner runner = new QueryRunner();
        if (runner.update(connection, "delete from stores where storeid=? and messageid=?", new Object[]{storeId, message.getJMSMessageID()}) <= 0) {
            throw new SQLException("No message id=" + message.getJMSMessageID() + " exists in store=" + storeId);
        }
        runner.update(connection, "delete from messages where messageid=?", new Object[]{message.getJMSMessageID()});
    }

    @Override
    public Collection<Destination> getDestinations(Connection connection, String storeId) throws SQLException, JMSException {
        final ArrayList<Destination> destinations = new ArrayList<Destination>();
        QueryRunner runner = new QueryRunner();
        Hermes.ui.getDefaultMessageSink().add("Getting message store destinations....");
        runner.query(connection, "select destination from stores where storeId=? and domain=?", new Object[]{storeId, Domain.QUEUE.getId()}, new ResultSetHandler(){

            public Object handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    MessageStoreQueue d = new MessageStoreQueue(rs.getString(1));
                    destinations.add(d);
                }
                return destinations;
            }
        });
        runner.query(connection, "select destination from stores where storeId=? and domain=?", new Object[]{storeId, Domain.TOPIC.getId()}, new ResultSetHandler(){

            public Object handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    MessageStoreTopic d = new MessageStoreTopic(rs.getString(1));
                    destinations.add(d);
                }
                return destinations;
            }
        });
        Hermes.ui.getDefaultMessageSink().add("Getting message store destinations.... done.");
        return destinations;
    }

    private PreparedStatement createPreparedStatement(Connection connection, String sql, Object[] params) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement(sql);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != null) {
                    stmt.setObject(i + 1, params[i]);
                    continue;
                }
                stmt.setNull(i + 1, 1111);
            }
        }
        return stmt;
    }

    @Override
    public QueueBrowser getMessages(Connection connection, String storeId, Destination destination, MessageFactory messageFactory, MessageStore.HeaderPolicy headerPolicy) throws SQLException, JMSException {
        QueryRunner runner = new QueryRunner();
        PreparedStatement stmt = this.createPreparedStatement(connection, "select stores.destination, stores.domain, messages.message, messages.messageid from stores, messages where stores.storeId=? and destination=? and stores.messageid = messages.messageid order by messages.messageid", new Object[]{storeId, messageFactory.getDestinationName(destination)});
        return new MessageResultSetHandler(connection, stmt, messageFactory, headerPolicy);
    }

    @Override
    public QueueBrowser getMessages(Connection connection, String storeId, MessageFactory messageFactory, MessageStore.HeaderPolicy headerPolicy) throws SQLException, JMSException {
        QueryRunner runner = new QueryRunner();
        PreparedStatement stmt = this.createPreparedStatement(connection, "select stores.destination, stores.domain, messages.message, messages.messageid from stores, messages where stores.storeId=? and stores.messageid = messages.messageid order by messages.messageid", new Object[]{storeId});
        return new MessageResultSetHandler(connection, stmt, messageFactory, headerPolicy);
    }

    private void executeStatements(Connection connection, String[] statements) throws SQLException {
        StringBuffer message = new StringBuffer();
        ProgressMonitor progressMonitor = null;
        if (HermesBrowser.getBrowser() != null) {
            progressMonitor = new ProgressMonitor((Component)((Object)HermesBrowser.getBrowser()), "Initialising message stores... ", "Connecting...", 0, statements.length);
            progressMonitor.setMillisToDecideToPopup(100);
            progressMonitor.setMillisToPopup(400);
        }
        QueryRunner runner = new QueryRunner();
        for (int i = 0; i < statements.length; ++i) {
            try {
                log.debug((Object)("executing: " + statements[i]));
                if (progressMonitor != null) {
                    progressMonitor.setProgress(statements.length);
                    progressMonitor.setNote("Executing statement " + i + " of " + statements.length);
                }
                runner.update(connection, statements[i]);
                continue;
            }
            catch (SQLException ex) {
                log.error((Object)ex.getMessage());
            }
        }
    }

    @Override
    public void createStore(Connection connection, String storeId) throws SQLException {
        try {
            QueryRunner runner = new QueryRunner();
            runner.update(connection, "insert into storeInfo values ( ? )", new Object[]{storeId});
        }
        catch (SQLException ex) {
            log.debug((Object)("swallowing " + ex.getMessage()));
        }
    }

    @Override
    public void recreateDatabase(Connection connection) throws SQLException {
        this.executeStatements(connection, this.statements.getDeleteDatabaseStatements());
        connection.commit();
        this.createDatabase(connection);
    }

    @Override
    public void createDatabase(Connection connection) throws SQLException {
        Hermes.ui.getDefaultMessageSink().add("Initialising message stores...");
        this.executeStatements(connection, this.statements.getCreateDatabaseStatements(this.maxMessageSize));
        connection.commit();
        Hermes.ui.getDefaultMessageSink().add("Initialising message stores... done.");
    }

    @Override
    public int getDepth(Connection connection, String storeId, Destination destination) throws SQLException, JMSException {
        QueryRunner runner = new QueryRunner();
        return (Integer)runner.query(connection, this.statements.getDepthStatement(), new Object[]{storeId, JMSUtils.getDestinationName(destination)}, new ResultSetHandler(){

            public Object handle(ResultSet rs) throws SQLException {
                rs.next();
                return rs.getInt(1);
            }
        });
    }
}

