/*
 * Decompiled with CFR 0.152.
 */
package hermes.renderers.fix;

import hermes.browser.MessageRenderer;
import hermes.fix.FIXException;
import hermes.fix.FIXMessage;
import hermes.fix.FIXUtils;
import hermes.fix.quickfix.QuickFIXMessage;
import hermes.fix.quickfix.QuickFIXMessageCache;
import hermes.renderers.AbstractMessageRenderer;
import hermes.util.MessageUtils;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

public class FIXMessageRenderer
extends AbstractMessageRenderer {
    private static final Logger log = Logger.getLogger(FIXMessageRenderer.class);
    private static final String MESSAGE_CACHE = "messageCache";
    private static final String MESSAGE_CACHE_INFO = "The number of panels to cache - can speed up the user interface when switching between messags";
    private static final String VALUE_WITH_ENUM = "displayValueWithEnum";
    private static final String VALUE_WITH_ENUM_INDO = "If true displays any enumeration values along with the descriptive text";
    private static final String SHOW_HEADER_AND_TRAINER = "displayHeaderAndTrailer";
    private static final String SHOW_HEADER_AND_TRAINER_INFO = "Display header and trailer fields";
    private QuickFIXMessageCache cache = new QuickFIXMessageCache(32);
    private LRUMap panelCache;

    protected JComponent handleObjectMessage(ObjectMessage objectMessage) throws JMSException {
        return null;
    }

    protected JComponent handleMapMessage(MapMessage mapMessage) throws JMSException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JComponent handleBytesMessage(BytesMessage bytesMessage) throws JMSException, IOException, ClassNotFoundException {
        try {
            bytesMessage.reset();
            byte[] bytes = MessageUtils.asBytes(bytesMessage);
            JComponent jComponent = this.createComponent(new QuickFIXMessage(this.cache, bytes));
            return jComponent;
        }
        finally {
            bytesMessage.reset();
        }
    }

    protected JComponent handleStreamMessage(StreamMessage streamMessage) throws JMSException {
        return null;
    }

    protected JComponent handleTextMessage(TextMessage textMessage) throws JMSException {
        String text = textMessage.getText();
        return this.createComponent(new QuickFIXMessage(this.cache, text.getBytes()));
    }

    protected JComponent createComponent(FIXMessage message) {
        try {
            MyConfig currentConfig = (MyConfig)this.getConfig();
            return FIXUtils.createView(message, currentConfig.getDisplayHeaderAndTrailer(), currentConfig.getDisplayValueWithEnum());
        }
        catch (FIXException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            log.debug((Object)"message is not a valid FIX message, ignoring");
            return null;
        }
    }

    @Override
    public JComponent render(Message m) {
        try {
            JComponent rval = null;
            if (this.getPanelMap().containsKey((Object)m)) {
                rval = (JComponent)this.getPanelMap().get((Object)m);
            } else {
                if (m instanceof TextMessage) {
                    rval = this.handleTextMessage((TextMessage)m);
                } else if (m instanceof ObjectMessage) {
                    rval = this.handleObjectMessage((ObjectMessage)m);
                } else if (m instanceof MapMessage) {
                    rval = this.handleMapMessage((MapMessage)m);
                } else if (m instanceof BytesMessage) {
                    rval = this.handleBytesMessage((BytesMessage)m);
                } else if (m instanceof StreamMessage) {
                    rval = this.handleStreamMessage((StreamMessage)m);
                }
                if (rval != null) {
                    this.getPanelMap().put((Object)m, (Object)rval);
                }
            }
            return rval;
        }
        catch (Throwable ex) {
            JTextArea textArea = new JTextArea();
            textArea.setEditable(false);
            textArea.setText("Unable to display message: " + ex.getMessage());
            log.error((Object)ex.getMessage(), ex);
            return textArea;
        }
    }

    @Override
    public MessageRenderer.Config createConfig() {
        return new MyConfig();
    }

    public synchronized LRUMap getPanelMap() {
        if (this.panelCache == null) {
            MyConfig currentConfig = (MyConfig)this.getConfig();
            this.panelCache = new LRUMap(currentConfig.getMessageCache());
        }
        return this.panelCache;
    }

    @Override
    public boolean canRender(Message message) {
        try {
            return FIXUtils.isFIX(message);
        }
        catch (JMSException ex) {
            log.error((Object)("during FIXMessage.isValid(): " + ex.getMessage()), (Throwable)ex);
            return false;
        }
    }

    @Override
    public String getDisplayName() {
        return "FIX";
    }

    public class MyConfig
    extends AbstractMessageRenderer.BasicConfig {
        private int messageCache = 100;
        private boolean displayValueWithEnum = true;
        private boolean displayHeaderAndTrailer = true;
        private String name;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getPropertyDescription(String propertyName) {
            if (propertyName.equals(FIXMessageRenderer.MESSAGE_CACHE)) {
                return FIXMessageRenderer.MESSAGE_CACHE_INFO;
            }
            if (propertyName.equals(FIXMessageRenderer.VALUE_WITH_ENUM)) {
                return FIXMessageRenderer.VALUE_WITH_ENUM_INDO;
            }
            if (propertyName.equals(FIXMessageRenderer.SHOW_HEADER_AND_TRAINER)) {
                return FIXMessageRenderer.SHOW_HEADER_AND_TRAINER_INFO;
            }
            return propertyName;
        }

        public int getMessageCache() {
            return this.messageCache;
        }

        public void setMessageCache(int messageCache) {
            this.messageCache = messageCache;
        }

        public boolean getDisplayValueWithEnum() {
            return this.displayValueWithEnum;
        }

        public void setDisplayValueWithEnum(boolean displayValueWithEnum) {
            this.displayValueWithEnum = displayValueWithEnum;
        }

        public boolean getDisplayHeaderAndTrailer() {
            return this.displayHeaderAndTrailer;
        }

        public void setDisplayHeaderAndTrailer(boolean displayHeaderAndTrailer) {
            this.displayHeaderAndTrailer = displayHeaderAndTrailer;
        }
    }
}

