/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

public class RegexQueueBrowser
implements QueueBrowser {
    private static final Logger log = Logger.getLogger(RegexQueueBrowser.class);
    private Pattern pattern;
    private boolean searchJMSHeader;
    private boolean searchUserHeader;
    private QueueBrowser browser;

    public RegexQueueBrowser(QueueBrowser browser, String regex, boolean searchJMSHeader, boolean searchUserHeader) {
        this.browser = browser;
        this.searchJMSHeader = searchJMSHeader;
        this.searchUserHeader = searchUserHeader;
        this.pattern = Pattern.compile(regex, 104);
    }

    public Queue getQueue() throws JMSException {
        return this.browser.getQueue();
    }

    public String getMessageSelector() throws JMSException {
        return this.browser.getMessageSelector();
    }

    public Enumeration getEnumeration() throws JMSException {
        return new RegexEnumeration(this.browser.getEnumeration());
    }

    public void close() throws JMSException {
        this.browser.close();
    }

    public boolean matches(Message message) {
        try {
            block21: {
                if (this.searchJMSHeader) {
                    // empty if block
                }
                if (this.searchUserHeader) {
                    Enumeration headerNames = message.getPropertyNames();
                    while (headerNames.hasMoreElements()) {
                        try {
                            String key = (String)headerNames.nextElement();
                            Object value = message.getObjectProperty(key);
                            if (key != null && this.pattern.matcher(key).lookingAt()) {
                                return true;
                            }
                            if (value == null || !this.pattern.matcher(value.toString()).lookingAt()) continue;
                            return true;
                        }
                        catch (JMSException ex) {
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                if (message instanceof TextMessage) {
                    try {
                        return this.pattern.matcher(((TextMessage)message).getText()).lookingAt();
                    }
                    catch (JMSException ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                        break block21;
                    }
                }
                if (message instanceof MapMessage) {
                    try {
                        MapMessage map = (MapMessage)message;
                        Enumeration mapNames = map.getMapNames();
                        while (mapNames.hasMoreElements()) {
                            String key = (String)mapNames.nextElement();
                            Object value = map.getObject(key);
                            if (this.pattern.matcher(key).lookingAt()) {
                                return true;
                            }
                            if (value == null || !this.pattern.matcher(value.toString()).lookingAt()) continue;
                            return true;
                        }
                    }
                    catch (JMSException ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                } else if (message instanceof ObjectMessage) {
                    try {
                        ObjectMessage om = (ObjectMessage)message;
                        String toString = om.getObject().toString();
                        if (this.pattern.matcher(toString).lookingAt()) {
                            return true;
                        }
                    }
                    catch (Throwable t) {
                        log.error((Object)t.getMessage(), t);
                    }
                }
            }
            return false;
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    class RegexEnumeration
    implements Enumeration {
        private Enumeration iter;

        RegexEnumeration(Enumeration iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasMoreElements();
        }

        public Object nextElement() {
            while (this.iter.hasMoreElements()) {
                Message m = (Message)this.iter.nextElement();
                if (m != null) {
                    if (!RegexQueueBrowser.this.matches(m)) continue;
                    return m;
                }
                return null;
            }
            return null;
        }
    }
}

