/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Domain;
import hermes.HermesException;
import hermes.impl.jms.SimpleDestinationManager;
import hermes.util.JMSUtils;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class JNDIDestinationManager
extends SimpleDestinationManager {
    private static final Logger log = Logger.getLogger(JNDIDestinationManager.class);
    private Properties properties;
    private boolean createIfNotBound;
    private Context context;

    public JNDIDestinationManager(Properties properties, boolean createIfNotBound) {
        this.properties = properties;
        this.createIfNotBound = createIfNotBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Destination createDesintaion(Session session, String named, Domain domain) throws JMSException {
        Destination rval = null;
        try {
            rval = (Destination)this.getContext().lookup(named);
        }
        catch (NameNotFoundException e) {
            if (!this.createIfNotBound) {
                throw new HermesException(e);
            }
        }
        catch (NamingException e) {
            JNDIDestinationManager jNDIDestinationManager = this;
            synchronized (jNDIDestinationManager) {
                try {
                    this.context.close();
                }
                catch (NamingException e1) {
                    log.error((Object)("closing context: " + e1.getMessage()), (Throwable)e1);
                }
                this.context = null;
            }
            throw new HermesException(e);
        }
        if (rval == null) {
            log.warn((Object)("failed to find " + named + " in JNDI context, trying a creation by name"));
            return super.createDesintaion(session, named, domain);
        }
        log.debug((Object)("got destination " + JMSUtils.getDestinationName(rval) + " bound at " + named));
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getContext() throws NamingException {
        JNDIDestinationManager jNDIDestinationManager = this;
        synchronized (jNDIDestinationManager) {
            if (this.context == null) {
                this.context = new InitialContext(this.properties);
            }
        }
        return this.context;
    }
}

