/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix;

import hermes.fix.SessionRole;

public class SessionKey {
    private String key;
    private String senderCompID;
    private String targetCompID;
    private String senderSubID;
    private String targetSubID;
    private long numMessages;
    private SessionRole role;

    public SessionKey(String senderCompID, String targetCompID, String senderSubID, String targetSubID, SessionRole role) {
        this(senderCompID, targetCompID, role);
        this.senderSubID = senderSubID;
        this.targetSubID = targetSubID;
    }

    public SessionKey(String senderCompID, String targetCompID, SessionRole role) {
        this.senderCompID = senderCompID;
        this.targetCompID = targetCompID;
        this.key = senderCompID + "-" + targetCompID;
        this.role = role;
    }

    public SessionKey(String senderCompID, String targetCompID) {
        this(senderCompID, targetCompID, SessionRole.UNKNOWN);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SessionKey) {
            return this.key.equals(obj.toString());
        }
        return false;
    }

    public void setSessionRole(SessionRole role) {
        this.role = role;
    }

    public SessionRole getSessionRole() {
        return this.role;
    }

    public String getSenderCompID() {
        return this.senderCompID;
    }

    public String getTargetCompID() {
        return this.targetCompID;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }

    public long getNumMessages() {
        return this.numMessages;
    }

    public void setNumMessages(long numMessages) {
        this.numMessages = numMessages;
    }

    public String getSenderSubID() {
        return this.senderSubID;
    }

    public String getTargetSubID() {
        return this.targetSubID;
    }
}

