/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix;

import com.codestreet.selector.parser.IValueProvider;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageValueProvider;
import hermes.fix.SessionKey;
import hermes.fix.SessionRole;
import hermes.swing.RowValueProvider;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.collections.list.TreeList;
import org.apache.log4j.Logger;
import quickfix.Field;
import quickfix.field.MsgSeqNum;
import quickfix.field.MsgType;
import quickfix.field.SenderSubID;
import quickfix.field.SendingTime;
import quickfix.field.TargetSubID;

public class FIXMessageTableModel
extends AbstractTableModel
implements RowValueProvider {
    private static final Logger log = Logger.getLogger(FIXMessageTableModel.class);
    public static final String DIRECTION = " ";
    private final List<FIXMessage> messages = new TreeList();
    private final Vector<Field> fields = new Vector();
    private final Vector<Class> classes = new Vector();
    private SessionKey initiatorSessionKey;

    public FIXMessageTableModel(SessionKey initiatorSessionKey) {
        this.initiatorSessionKey = initiatorSessionKey;
        this.fields.add(null);
        this.fields.add((Field)new MsgSeqNum());
        this.fields.add((Field)new SendingTime());
        this.fields.add((Field)new MsgType());
        this.fields.add((Field)new SenderSubID());
        this.fields.add((Field)new TargetSubID());
        this.classes.add(Integer.class);
        this.classes.add(String.class);
        this.classes.add(String.class);
        this.classes.add(String.class);
        this.classes.add(String.class);
        this.classes.add(String.class);
    }

    @Override
    public IValueProvider getValueProviderForRow(int row) {
        return new FIXMessageValueProvider(this.getMessageAt(row));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.classes.get(columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return DIRECTION;
        }
        return this.fields.get(column).getClass().getSimpleName();
    }

    @Override
    public int getColumnCount() {
        return this.fields.size();
    }

    @Override
    public int getRowCount() {
        return this.messages.size();
    }

    public FIXMessage getMessageAt(int row) {
        return this.messages.get(row);
    }

    public void addMessages(Collection<FIXMessage> newMessages) {
        this.messages.addAll(newMessages);
        this.fireTableRowsInserted(this.messages.size() - newMessages.size(), this.messages.size());
    }

    public SessionRole getRole(FIXMessage message) {
        String senderCompID = message.getString(49);
        if (this.initiatorSessionKey.getSenderCompID().equals(senderCompID)) {
            return SessionRole.INITIATOR;
        }
        return SessionRole.ACCEPTOR;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.messages.size()) {
            return null;
        }
        FIXMessage message = this.messages.get(rowIndex);
        if (columnIndex == 0) {
            if (this.getRole(message) == SessionRole.INITIATOR) {
                return "-->";
            }
            return "<--";
        }
        Field field = this.fields.get(columnIndex);
        Object fieldValue = message.getObject(field);
        if (fieldValue != null && fieldValue instanceof String) {
            String valueName = message.getDictionary().getValueName(field.getTag(), (String)fieldValue);
            if (valueName == null) {
                return fieldValue;
            }
            return valueName;
        }
        return fieldValue;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

