/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model.tree;

import hermes.browser.IconCache;
import hermes.browser.model.BrowserTreeModel;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.MessageStoreQueueTreeNode;
import hermes.browser.model.tree.MessageStoreTopicTreeNode;
import hermes.store.MessageStore;
import hermes.store.MessageStoreListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class MessageStoreTreeNode
extends AbstractTreeNode
implements MessageStoreListener {
    private static final Logger log = Logger.getLogger(MessageStoreTreeNode.class);
    private static final Timer timer = new Timer();
    private TimerTask timerTask;
    private BrowserTreeModel model;
    private Map<String, MessageStoreTopicTreeNode> topics = new HashMap<String, MessageStoreTopicTreeNode>();
    private Map<String, MessageStoreQueueTreeNode> queues = new HashMap<String, MessageStoreQueueTreeNode>();

    public MessageStoreTreeNode(BrowserTreeModel model, String id, MessageStore messageStore) {
        super(id, messageStore);
        this.model = model;
        this.setIcon(IconCache.getIcon("hermes.store"));
        messageStore.addMessageListener(this);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                MessageStoreTreeNode.this.updateDestinations();
            }
        };
        timer.schedule(this.timerTask, 0L);
    }

    @Override
    public void remove(MutableTreeNode aChild) {
        super.remove(aChild);
    }

    public MessageStore getMessageStore() {
        return (MessageStore)this.getBean();
    }

    public void close() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.getMessageStore().removeMessageListener(this);
    }

    private void addQueue(Queue queue) throws JMSException {
        if (!this.queues.containsKey(queue.getQueueName())) {
            final MessageStoreQueueTreeNode node = new MessageStoreQueueTreeNode(this.getMessageStore(), queue.getQueueName(), queue);
            this.queues.put(queue.getQueueName(), node);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageStoreTreeNode.this.add(node);
                    MessageStoreTreeNode.this.model.nodeStructureChanged(MessageStoreTreeNode.this);
                }
            });
        }
    }

    private void addTopic(Topic topic) throws JMSException {
        if (!this.topics.containsKey(topic.getTopicName())) {
            final MessageStoreTopicTreeNode node = new MessageStoreTopicTreeNode(this.getMessageStore(), topic.getTopicName(), topic);
            this.topics.put(topic.getTopicName(), node);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageStoreTreeNode.this.add(node);
                    MessageStoreTreeNode.this.model.nodesWereInserted(MessageStoreTreeNode.this, new int[]{MessageStoreTreeNode.this.getChildCount() - 1});
                }
            });
        }
    }

    private void removeQueue(String queueName) throws JMSException {
        final MessageStoreQueueTreeNode node = this.queues.get(queueName);
        final int oldIndex = this.getIndex(node);
        this.queues.remove(queueName);
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageStoreTreeNode.this.remove(node);
                    MessageStoreTreeNode.this.model.nodesWereRemoved(MessageStoreTreeNode.this, new int[]{oldIndex}, new Object[]{node});
                }
            });
        }
    }

    private void removeTopic(String topicName) throws JMSException {
        final MessageStoreTopicTreeNode node = this.topics.get(topicName);
        final int oldIndex = this.getIndex(node);
        this.topics.remove(topicName);
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageStoreTreeNode.this.remove(node);
                    MessageStoreTreeNode.this.model.nodesWereRemoved(MessageStoreTreeNode.this, new int[]{oldIndex}, new Object[]{node});
                }
            });
        }
    }

    private void updateDestinations() {
        try {
            Collection<Destination> destinations = this.getMessageStore().getDestinations();
            HashSet<String> currentQueues = new HashSet<String>();
            HashSet<String> currentTopics = new HashSet<String>();
            for (Destination destination : destinations) {
                if (destination instanceof Queue) {
                    Queue queue = (Queue)destination;
                    currentQueues.add(queue.getQueueName());
                    this.addQueue(queue);
                    continue;
                }
                Topic topic = (Topic)destination;
                currentTopics.add(topic.getTopicName());
                this.addTopic(topic);
            }
            for (String queueName : this.queues.keySet()) {
                if (currentQueues.contains(queueName)) continue;
                this.removeQueue(queueName);
                break;
            }
            for (String topicName : this.topics.keySet()) {
                if (currentTopics.contains(topicName)) continue;
                this.removeTopic(topicName);
                break;
            }
        }
        catch (JMSException e) {
            log.error((Object)e);
        }
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
            }
        };
        timer.schedule(this.timerTask, 1000L);
    }

    @Override
    public void onDestination(Destination d) {
        try {
            if (d instanceof Queue) {
                this.addQueue((Queue)d);
            } else {
                this.addTopic((Topic)d);
            }
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void onDestinationDeleted(Destination d) {
        try {
            if (d instanceof Queue) {
                this.removeQueue(((Queue)d).getQueueName());
            } else {
                this.removeTopic(((Topic)d).getTopicName());
            }
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void onException(Exception e) {
    }

    @Override
    public final void onMessageDeleted(Message m) {
    }

    public final void onMessage(Message arg0) {
    }
}

