/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.actions.BrowserAction;
import hermes.config.DestinationConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.jms.JMSException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class QueueSearchDialog
extends StandardDialog {
    private static final Logger log = Logger.getLogger(QueueSearchDialog.class);
    private static Vector selectionHistory = new Vector();
    private JPanel topPanel = new JPanel();
    private Hermes hermes;
    private JLabel info = new JLabel("Enter the string or regular expression to search messages for.");
    private JComboBox stringCombo;
    private JCheckBox stringCheckBox = new JCheckBox("Simple string search");
    private JCheckBox regexCheckBox = new JCheckBox("Regular expression search");
    private JCheckBox userHeaderCheckBox = new JCheckBox("Search user header properties", true);
    private JCheckBox jmsHeaderCheckBox = new JCheckBox("Search JMS header poperties");
    private DestinationConfig destinationConfig;

    public QueueSearchDialog(Frame parent, Hermes hermes, DestinationConfig destinationConfig, boolean searchUserHeader) {
        super(parent, "Search queue/topic", true);
        this.hermes = hermes;
        this.destinationConfig = destinationConfig;
        this.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueueSearchDialog.this.onOK();
            }
        });
    }

    public QueueSearchDialog(Frame parent, Hermes hermes) {
        super(parent, "Search all queues on " + hermes.getId(), true);
        this.hermes = hermes;
        this.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueueSearchDialog.this.onOK();
            }
        });
    }

    protected void onOK() {
        String selection;
        String string = selection = this.stringCombo.getSelectedItem() != null ? this.stringCombo.getSelectedItem().toString() : null;
        if (selection != null && !selection.equals("")) {
            try {
                if (this.regexCheckBox.isSelected()) {
                    BrowserAction action = HermesBrowser.getBrowser().getActionFactory().createRegexQueueBrowseAction(this.hermes, this.destinationConfig, selection);
                } else {
                    BrowserAction action = HermesBrowser.getBrowser().getActionFactory().createStringSeachQueueBrowseAction(this.hermes, this.destinationConfig, selection, this.userHeaderCheckBox.isSelected());
                }
                selectionHistory.add(selection);
            }
            catch (JMSException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                HermesBrowser.getBrowser().showErrorDialog(e);
            }
        }
    }

    public JComponent createBannerPanel() {
        return new JLabel();
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.addButton((AbstractButton)okButton);
        buttonPanel.addButton((AbstractButton)cancelButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueueSearchDialog.this.onOK();
                QueueSearchDialog.this.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueueSearchDialog.this.dispose();
            }
        });
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return buttonPanel;
    }

    public JComponent createContentPanel() {
        Border border = BorderFactory.createBevelBorder(0);
        this.topPanel.setLayout(new BorderLayout());
        JPanel comboPanel = new JPanel();
        comboPanel.setLayout(new GridLayout(1, 1));
        comboPanel.setBorder(BorderFactory.createTitledBorder(border, "Search for"));
        this.stringCombo = new JComboBox(selectionHistory);
        this.stringCombo.setEditable(true);
        comboPanel.add(this.stringCombo);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(border, "Options"));
        checkBoxPanel.setLayout(new GridLayout(4, 1));
        checkBoxPanel.add(this.stringCheckBox);
        checkBoxPanel.add(this.regexCheckBox);
        checkBoxPanel.add(this.userHeaderCheckBox);
        checkBoxPanel.add(this.jmsHeaderCheckBox);
        this.topPanel.add((Component)comboPanel, "North");
        this.topPanel.add((Component)checkBoxPanel, "South");
        this.stringCheckBox.setSelected(true);
        this.regexCheckBox.setSelected(false);
        this.stringCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueueSearchDialog.this.regexCheckBox.setSelected(!QueueSearchDialog.this.stringCheckBox.isSelected());
            }
        });
        this.regexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueueSearchDialog.this.stringCheckBox.setSelected(!QueueSearchDialog.this.regexCheckBox.isSelected());
            }
        });
        this.userHeaderCheckBox.setSelected(true);
        this.jmsHeaderCheckBox.setSelected(false);
        this.jmsHeaderCheckBox.setEnabled(false);
        this.setSize(new Dimension(430, 250));
        this.setResizable(false);
        return this.topPanel;
    }
}

