/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.grid.SortableTable;
import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.PreferencesDialog;
import hermes.browser.model.DestinationConfigTableModel;
import hermes.browser.tasks.EditDestinationPropertiesTask;
import hermes.config.ConnectionConfig;
import hermes.config.DestinationConfig;
import hermes.config.FactoryConfig;
import hermes.config.SessionConfig;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import org.apache.log4j.Category;

public class DestinationConfigPanel
extends JPanel {
    private static final String IMPORT = "Import...";
    private static final String REMOVE = "Remove";
    private static final String ADD_SIMPLE = "Add...";
    private static final String EDIT_SIMPLE = "Edit...";
    private static final String DESTINATIONS = "Destinations";
    private static final Category cat = Category.getInstance(DestinationConfigPanel.class);
    private static File lastImportDirectory = null;
    private PreferencesDialog dialog;
    private FactoryConfig factoryConfig;
    private SortableTable destinationTable = new SortableTable();
    private JScrollPane destinationTableSP = new JScrollPane();
    private DestinationConfigTableModel destinationTableModel;
    private MouseAdapter mouseAdapter;
    private Map configs = new HashMap();

    public DestinationConfigPanel(PreferencesDialog dialog) {
        this.dialog = dialog;
        this.init();
    }

    public void init() {
        Border border = BorderFactory.createBevelBorder(0);
        this.setBorder(BorderFactory.createTitledBorder(border, DESTINATIONS));
        this.setLayout(new GridLayout(1, 1));
        this.destinationTableSP.setViewportView((Component)this.destinationTable);
        this.destinationTable.setSortable(true);
        this.add(this.destinationTableSP);
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem add1Item = new JMenuItem(ADD_SIMPLE);
        final JMenuItem removeItem = new JMenuItem(REMOVE);
        JMenuItem importItem = new JMenuItem(IMPORT);
        popupMenu.add(add1Item);
        popupMenu.add(removeItem);
        popupMenu.add(importItem);
        importItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (JOptionPane.showConfirmDialog(DestinationConfigPanel.this, "The input file must contain a single topic or queue name per line", "Import topics/queues", 2) == 0) {
                    JFileChooser fileChooser = lastImportDirectory == null ? new JFileChooser() : new JFileChooser(lastImportDirectory);
                    if (fileChooser.showOpenDialog(DestinationConfigPanel.this.dialog) == 0) {
                        lastImportDirectory = new File(fileChooser.getSelectedFile().getPath());
                        try {
                            String line;
                            LineNumberReader reader = new LineNumberReader(new FileReader(fileChooser.getSelectedFile()));
                            while ((line = reader.readLine()) != null) {
                                DestinationConfig dConfig = new DestinationConfig();
                                dConfig.setName(line.trim());
                                dConfig.setDomain(Domain.QUEUE.getId());
                                DestinationConfigPanel.this.destinationTableModel.addItem(dConfig);
                            }
                        }
                        catch (IOException e) {
                            cat.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    DestinationConfigPanel.this.dialog.setDirty();
                }
            }
        });
        add1Item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ConnectionConfig cConfig = DestinationConfigPanel.this.factoryConfig.getConnection().get(0);
                    SessionConfig sConfig = cConfig.getSession().get(0);
                    DestinationConfig dConfig = new DestinationConfig();
                    dConfig.setDomain(Domain.QUEUE.getId());
                    dConfig.setName("NEW");
                    DestinationConfigPanel.this.destinationTableModel.addItem(dConfig);
                    DestinationConfigPanel.this.doEdit(sConfig.getId(), dConfig);
                    DestinationConfigPanel.this.dialog.setDirty();
                }
                catch (Exception ex) {
                    cat.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        });
        removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (int row : DestinationConfigPanel.this.destinationTable.getSelectedRows()) {
                    if (row < 0) continue;
                    int realRow = DestinationConfigPanel.this.destinationTable.getActualRowAt(row);
                    DestinationConfigPanel.this.destinationTableModel.removeRow(realRow);
                    DestinationConfigPanel.this.dialog.setDirty();
                }
            }
        });
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row;
                if (SwingUtilities.isRightMouseButton(e)) {
                    if (e.getComponent() == DestinationConfigPanel.this.destinationTableSP) {
                        removeItem.setEnabled(false);
                    } else {
                        removeItem.setEnabled(true);
                    }
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getClickCount() == 2 && (row = DestinationConfigPanel.this.destinationTable.getActualRowAt(DestinationConfigPanel.this.destinationTable.getSelectedRow())) >= 0) {
                    ConnectionConfig cConfig = DestinationConfigPanel.this.factoryConfig.getConnection().get(0);
                    SessionConfig sConfig = cConfig.getSession().get(0);
                    DestinationConfigPanel.this.doEdit(sConfig.getId(), DestinationConfigPanel.this.destinationTableModel.getRowConfig(row));
                }
            }
        };
        this.destinationTable.addMouseListener((MouseListener)this.mouseAdapter);
        this.destinationTableSP.addMouseListener(this.mouseAdapter);
        this.destinationTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
    }

    public void setFactoryConfig(FactoryConfig factoryConfig) {
        this.factoryConfig = factoryConfig;
        this.destinationTableModel = new DestinationConfigTableModel(factoryConfig.getDestination());
        this.destinationTable.setModel((TableModel)this.destinationTableModel);
    }

    public void doEdit(String hermesId, DestinationConfig dConfig) {
        try {
            Hermes.ui.getThreadPool().invokeLater(new EditDestinationPropertiesTask((Hermes)HermesBrowser.getBrowser().getLoader().getContext().lookup(hermesId), dConfig, new Runnable(){

                @Override
                public void run() {
                    DestinationConfigPanel.this.destinationTableModel.fireTableDataChanged();
                }
            }));
        }
        catch (NamingException e) {
            HermesBrowser.getBrowser().showErrorDialog(e);
        }
    }

    public Collection getDestinations() {
        return this.destinationTableModel == null ? Collections.EMPTY_LIST : this.destinationTableModel.getRows();
    }

    public void updateModel() {
        if (this.factoryConfig != null) {
            this.factoryConfig.getDestination().clear();
            this.factoryConfig.getDestination().addAll(this.destinationTableModel.getRows());
        } else {
            cat.error((Object)"updateModel() factoryConfig is null");
        }
    }
}

