/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import hermes.swing.SwingAppender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class Log4JOutputViewer
extends JComponent {
    private SwingAppender swingAppender;

    public Log4JOutputViewer(String filter) {
        this.swingAppender = new SwingAppender(filter);
        this.init();
    }

    public void init() {
        JScrollPane tableSP = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.add((Component)tableSP, "Center");
        tableSP.setViewportView(this.swingAppender.getComponent());
        Logger.getRootLogger().addAppender((Appender)this.swingAppender);
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem clearItem = new JMenuItem("Clear");
        final JMenuItem stopItem = new JMenuItem("Stop");
        final JMenuItem startItem = new JMenuItem("Start");
        popupMenu.add(stopItem);
        popupMenu.add(startItem);
        popupMenu.add(clearItem);
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    stopItem.setEnabled(Log4JOutputViewer.this.swingAppender.isActive());
                    startItem.setEnabled(!Log4JOutputViewer.this.swingAppender.isActive());
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Log4JOutputViewer.this.swingAppender.clear();
            }
        });
        stopItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Log4JOutputViewer.this.swingAppender.setActive(false);
            }
        });
        startItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Log4JOutputViewer.this.swingAppender.setActive(true);
            }
        });
        this.swingAppender.getComponent().addMouseListener(m);
        tableSP.addMouseListener(m);
        this.addMouseListener(m);
    }
}

