/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.actions;

import com.jidesoft.document.DocumentComponent;
import com.jidesoft.swing.JideScrollPane;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.components.ContextTree;
import hermes.browser.model.tree.ContextTreeModel;
import hermes.browser.tasks.JNDIBrowseTask;
import hermes.config.NamingConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class BrowseContextAction
extends DocumentComponent {
    private static final Logger log = Logger.getLogger(BrowseContextAction.class);
    private NamingConfig namingConfig;
    private volatile boolean keepRunning = true;
    private JPanel rootPanel;
    private boolean firstTime = true;
    private JideScrollPane treeSP = new JideScrollPane();
    private JLabel lastUpdate = new JLabel();
    private ContextTree contextTree = new ContextTree();

    public BrowseContextAction(NamingConfig namingConfig) {
        super((JComponent)new JPanel(), "JNDI: " + namingConfig.getId());
        this.namingConfig = namingConfig;
        this.setIcon(IconCache.getIcon("jndi.context"));
        this.rootPanel = (JPanel)this.getComponent();
        this.update();
    }

    public void update() {
        JNDIBrowseTask task = new JNDIBrowseTask(this.namingConfig, this);
        task.start();
    }

    public ContextTree getContextTree() {
        return this.contextTree;
    }

    public synchronized void update(ContextTreeModel model) {
        if (this.firstTime) {
            this.rootPanel.setLayout(new BorderLayout());
            JPanel header = new JPanel();
            header.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            header.setLayout(new BoxLayout(header, 0));
            this.lastUpdate.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            header.add(this.lastUpdate);
            this.rootPanel.add((Component)header, "North");
            this.rootPanel.add((Component)this.treeSP, "Center");
        }
        try {
            this.lastUpdate.setText("Last update " + new Date());
            this.contextTree.setModel(model);
            this.treeSP.setViewportView((Component)this.contextTree);
            if (this.firstTime) {
                HermesBrowser.getBrowser().addDocumentComponent(this);
                this.firstTime = false;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

