/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;

public class JTableButtonMouseListener
implements MouseListener {
    private JTable table;

    public JTableButtonMouseListener(JTable table) {
        this.table = table;
    }

    private void forwardEvent(MouseEvent evt) {
        TableColumnModel columnModel = this.table.getColumnModel();
        int column = columnModel.getColumnIndexAtX(evt.getX());
        int row = evt.getY() / this.table.getRowHeight();
        if (row >= this.table.getRowCount() || row < 0 || column >= this.table.getColumnCount() || column < 0) {
            return;
        }
        Object value = this.table.getValueAt(row, column);
        if (value instanceof JButton) {
            JButton button = (JButton)value;
            MouseEvent buttonEvent = SwingUtilities.convertMouseEvent(this.table, evt, button);
            button.dispatchEvent(buttonEvent);
            this.table.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.forwardEvent(arg0);
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.forwardEvent(arg0);
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.forwardEvent(arg0);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.forwardEvent(arg0);
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.forwardEvent(arg0);
    }
}

