/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.ssl;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.http.HttpRequestFactory;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.reactor.SSLIOSession;
import org.apache.http.impl.nio.reactor.SSLMode;
import org.apache.http.impl.nio.reactor.SSLSetupHandler;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerIOTarget;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpParams;

public class SSLServerIOEventDispatch
implements IOEventDispatch {
    private static final String SSL_SESSION = "http.nio.ssl-session";
    private final NHttpServiceHandler handler;
    private final SSLContext sslcontext;
    private final SSLSetupHandler sslHandler;
    private final HttpParams params;

    public SSLServerIOEventDispatch(NHttpServiceHandler handler, SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP service handler may not be null");
        }
        if (sslcontext == null) {
            throw new IllegalArgumentException("SSL context may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.handler = handler;
        this.params = params;
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
    }

    public SSLServerIOEventDispatch(NHttpServiceHandler handler, SSLContext sslcontext, HttpParams params) {
        this(handler, sslcontext, null, params);
    }

    protected ByteBufferAllocator createByteBufferAllocator() {
        return new HeapByteBufferAllocator();
    }

    protected HttpRequestFactory createHttpRequestFactory() {
        return new DefaultHttpRequestFactory();
    }

    protected NHttpServerIOTarget createConnection(IOSession session) {
        return new DefaultNHttpServerConnection(session, this.createHttpRequestFactory(), this.createByteBufferAllocator(), this.params);
    }

    protected SSLIOSession createSSLIOSession(IOSession session, SSLContext sslcontext, SSLSetupHandler sslHandler) {
        return new SSLIOSession(session, sslcontext, sslHandler);
    }

    public void connected(IOSession session) {
        SSLIOSession sslSession = this.createSSLIOSession(session, this.sslcontext, this.sslHandler);
        NHttpServerIOTarget conn = this.createConnection(sslSession);
        session.setAttribute("http.connection", conn);
        session.setAttribute(SSL_SESSION, sslSession);
        this.handler.connected(conn);
        try {
            sslSession.bind(SSLMode.SERVER, this.params);
        }
        catch (SSLException ex) {
            this.handler.exception((NHttpServerConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    public void disconnected(IOSession session) {
        NHttpServerIOTarget conn = (NHttpServerIOTarget)session.getAttribute("http.connection");
        if (conn != null) {
            this.handler.closed(conn);
        }
    }

    private void ensureNotNull(NHttpServerIOTarget conn) {
        if (conn == null) {
            throw new IllegalStateException("HTTP connection is null");
        }
    }

    private void ensureNotNull(SSLIOSession ssliosession) {
        if (ssliosession == null) {
            throw new IllegalStateException("SSL I/O session is null");
        }
    }

    public void inputReady(IOSession session) {
        NHttpServerIOTarget conn = (NHttpServerIOTarget)session.getAttribute("http.connection");
        this.ensureNotNull(conn);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        this.ensureNotNull(sslSession);
        try {
            if (sslSession.isAppInputReady()) {
                conn.consumeInput(this.handler);
            }
            sslSession.inboundTransport();
        }
        catch (IOException ex) {
            this.handler.exception((NHttpServerConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    public void outputReady(IOSession session) {
        NHttpServerIOTarget conn = (NHttpServerIOTarget)session.getAttribute("http.connection");
        this.ensureNotNull(conn);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        this.ensureNotNull(sslSession);
        try {
            if (sslSession.isAppOutputReady()) {
                conn.produceOutput(this.handler);
            }
            sslSession.outboundTransport();
        }
        catch (IOException ex) {
            this.handler.exception((NHttpServerConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(IOSession session) {
        NHttpServerIOTarget conn = (NHttpServerIOTarget)session.getAttribute("http.connection");
        this.ensureNotNull(conn);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        this.ensureNotNull(sslSession);
        this.handler.timeout(conn);
        SSLIOSession sSLIOSession = sslSession;
        synchronized (sSLIOSession) {
            if (sslSession.isOutboundDone() && !sslSession.isInboundDone()) {
                sslSession.shutdown();
            }
        }
    }
}

