/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.wsi.test.ToolEnvironment;
import org.wsi.test.util.XMLInfo;
import org.wsi.util.Utils;

public class ToolInfo {
    public static final String PROP_TOOL_VERSION = "wsi.tool.version";
    public static final String PROP_TOOL_RELEASE_DATE = "wsi.tool.release.date";
    public static final String PROP_TOOL_IMPLEMENTER = "wsi.tool.implementer";
    public static final String PROP_TOOL_LOCATION = "wsi.tool.location";
    private static final String DEF_TOOL_VERSION = "1.0.1";
    private static final String DEF_TOOL_RELEASE_DATE = "2004-01-22";
    private static final String DEF_TOOL_IMPLEMENTER = "Web Services Interoperability Organization";
    private static final String DEF_TOOL_LOCATION = "http://www.ws-i.org/implementation.aspx";
    protected String name;
    protected String version;
    protected String releaseDate;
    protected String implementer;
    protected String location;
    protected ToolEnvironment toolEnvironment = null;
    public static final String PROP_FILENAME = "org.wsi.test.toolinfo";
    private static final String COMMENTS = "# Copyright (c) 2002-2003 by The Web Services-Interoperability Organization (WS-I) and \n# Certain of its Members. All Rights Reserved.\n#\n# Notice\n# The material contained herein is not a license, either expressly or impliedly, to any\n# intellectual property owned or controlled by any of the authors or developers of this\n# material or WS-I. The material contained herein is provided on an \"AS IS\" basis and to\n# the maximum extent permitted by applicable law, this material is provided AS IS AND WITH\n# ALL FAULTS, and the authors and developers of this material and WS-I hereby disclaim all\n# other warranties and conditions, either express, implied or statutory, including, but not\n# limited to, any (if any) implied warranties, duties or conditions of  merchantability,\n# of fitness for a particular purpose, of accuracy or completeness of responses, of results,\n# of workmanlike effort, of lack of viruses, and of lack of negligence. ALSO, THERE IS NO\n# WARRANTY OR CONDITION OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, CORRESPONDENCE TO\n# DESCRIPTION OR NON-INFRINGEMENT WITH REGARD TO THIS MATERIAL.\n#\n# IN NO EVENT WILL ANY AUTHOR OR DEVELOPER OF THIS MATERIAL OR WS-I BE LIABLE TO ANY OTHER\n# PARTY FOR THE COST OF PROCURING SUBSTITUTE GOODS OR SERVICES, LOST PROFITS, LOSS OF USE,\n# LOSS OF DATA, OR ANY INCIDENTAL, CONSEQUENTIAL, DIRECT, INDIRECT, OR SPECIAL DAMAGES\n# WHETHER UNDER CONTRACT, TORT, WARRANTY, OR OTHERWISE, ARISING IN ANY WAY OUT OF THIS OR\n# ANY OTHER AGREEMENT RELATING TO THIS MATERIAL, WHETHER OR NOT SUCH PARTY HAD ADVANCE\n# NOTICE OF THE POSSIBILITY OF SUCH DAMAGES.\n#\n# WS-I License Information\n# Use of this WS-I Material is governed by the WS-I Test License and other licenses.  Information on these\n# licenses are contained in the README.txt and ReleaseNotes.txt files.  By downloading this file, you agree\n# to the terms of these licenses.\n#\n# How To Provide Feedback\n# The Web Services-Interoperability Organization (WS-I) would like to receive input,\n# suggestions and other feedback (\"Feedback\") on this work from a wide variety of \n# industry participants to improve its quality over time.\n#\n# By sending email, or otherwise communicating with WS-I, you (on behalf of yourself if\n# you are an individual, and your company if you are providing Feedback on behalf of the\n# company) will be deemed to have granted to WS-I, the members of WS-I, and other parties\n# that have access to your Feedback, a non-exclusive, non-transferable, worldwide, perpetual,\n# irrevocable, royalty-free license to use, disclose, copy, license, modify, sublicense or\n# otherwise distribute and exploit in any manner whatsoever the Feedback you provide regarding\n# the work. You acknowledge that you have no expectation of confidentiality with respect to\n# any Feedback you provide. You represent and warrant that you have rights to provide this\n# Feedback, and if you are providing Feedback on behalf of a company, you represent and warrant\n# that you have the rights to provide Feedback on behalf of your company. You also acknowledge\n# that WS-I is not required to review, discuss, use, consider or in any way incorporate your\n# Feedback into future versions of its work. If WS-I does incorporate some or all of your\n# Feedback in a future version of the work, it may, but is not obligated to include your name\n# (or, if you are identified as acting on behalf of your company, the name of your company) on\n# a list of contributors to the work. If the foregoing is not acceptable to you and any company\n# on whose behalf you are acting, please do not provide any Feedback.\n#\n# WS-I members should direct feedback on this document to wsi_testing@lists.ws-i.org;\n# non-members should direct feedback to wsi-tools@ws-i.org.\n";

    public ToolInfo() {
        this.toolEnvironment = new ToolEnvironment();
    }

    public ToolInfo(String string) {
        this.name = string;
        this.getProperties();
        this.toolEnvironment = new ToolEnvironment();
    }

    public ToolInfo(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.version = string2;
        this.releaseDate = string3;
        this.implementer = string4;
        this.location = string5;
        this.toolEnvironment = new ToolEnvironment();
    }

    public ToolInfo(String string, String string2, String string3, String string4, String string5, XMLInfo xMLInfo) {
        this.name = string;
        this.version = string2;
        this.releaseDate = string3;
        this.implementer = string4;
        this.location = string5;
        this.toolEnvironment = new ToolEnvironment(xMLInfo);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getImplementer() {
        return this.implementer;
    }

    public String getLocation() {
        return this.location;
    }

    public ToolEnvironment getToolEnvironment() {
        return this.toolEnvironment;
    }

    public void setImplementer(String string) {
        this.implementer = string;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setReleaseDate(String string) {
        this.releaseDate = string;
    }

    public void setToolEnvironment(ToolEnvironment toolEnvironment) {
        this.toolEnvironment = toolEnvironment;
    }

    public void setAdditionalToolEnvironment(XMLInfo xMLInfo) {
        this.toolEnvironment.setAdditionalToolEnvironment(xMLInfo);
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getStartXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals("")) {
            string2 = string2 + ":";
        }
        printWriter.print("  <" + string2 + this.getName().toLowerCase() + " ");
        printWriter.print("version=\"" + this.getVersion() + "\" ");
        printWriter.println("releaseDate=\"" + this.getReleaseDate() + "\">");
        printWriter.print("    <" + string2 + "implementer" + " ");
        printWriter.print("name=\"" + this.getImplementer() + "\" ");
        printWriter.println("location=\"" + this.getLocation() + "\"/>");
        printWriter.print(this.toolEnvironment.toXMLString(string));
        return stringWriter.toString();
    }

    public String getEndXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals("")) {
            string2 = string2 + ":";
        }
        printWriter.println("  </" + string2 + this.getName().toLowerCase() + ">");
        return stringWriter.toString();
    }

    protected void getProperties() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(PROP_FILENAME);
            this.version = this.getProperty(resourceBundle, PROP_TOOL_VERSION, DEF_TOOL_VERSION);
            this.releaseDate = this.getProperty(resourceBundle, PROP_TOOL_RELEASE_DATE, DEF_TOOL_RELEASE_DATE);
            this.implementer = this.getProperty(resourceBundle, PROP_TOOL_IMPLEMENTER, DEF_TOOL_IMPLEMENTER);
            this.location = this.getProperty(resourceBundle, PROP_TOOL_LOCATION, DEF_TOOL_LOCATION);
        }
        catch (MissingResourceException missingResourceException) {
            this.version = DEF_TOOL_VERSION;
            this.releaseDate = DEF_TOOL_RELEASE_DATE;
            this.implementer = DEF_TOOL_IMPLEMENTER;
            this.location = DEF_TOOL_LOCATION;
        }
    }

    protected String getProperty(ResourceBundle resourceBundle, String string, String string2) {
        String string3 = resourceBundle.getString(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    private String formatToolLocation(String string) {
        String string2 = string;
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return string2 + this.getName() + ".html";
    }

    public static void main(String[] stringArray) {
        int n = 0;
        String string = PROP_FILENAME;
        String string2 = DEF_TOOL_VERSION;
        String string3 = DEF_TOOL_IMPLEMENTER;
        String string4 = DEF_TOOL_LOCATION;
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        if (stringArray.length >= 2) {
            string2 = stringArray[1];
        }
        if (stringArray.length >= 3) {
            string3 = stringArray[2];
        }
        if (stringArray.length >= 4) {
            string4 = stringArray[3];
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(COMMENTS);
            printWriter.println("wsi.tool.version=" + string2);
            printWriter.println("wsi.tool.release.date=" + Utils.getDate());
            printWriter.println("wsi.tool.implementer=" + string3);
            printWriter.println("wsi.tool.location=" + string4);
            fileWriter.close();
            System.out.println("File [" + string + "] created.");
        }
        catch (IOException iOException) {
            n = 1;
            System.out.println("EXCEPTION: " + iOException.toString());
            iOException.printStackTrace();
        }
        System.exit(n);
    }
}

