/*
 * Decompiled with CFR 0.152.
 */
package com.kineticdata.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.JarFile;

public class Main
implements Runnable {
    public static final String MAIN = "/" + Main.class.getName().replace('.', '/') + ".class";
    private String[] args;
    private String path;
    private String jarfile;
    private boolean debug;
    private File extractRoot;

    public Main(String[] stringArray) throws Exception {
        this.args = stringArray;
        URL uRL = this.getClass().getResource(MAIN);
        this.path = uRL.toURI().getSchemeSpecificPart();
        this.jarfile = this.path.replace("!" + MAIN, "").replace("file:", "");
        this.debug = Main.isDebug();
        this.extractRoot = File.createTempFile("jruby", "extract");
        this.extractRoot.delete();
        this.extractRoot.mkdirs();
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    private URL[] extractJRuby() throws Exception {
        JarFile jarFile = new JarFile(this.jarfile);
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = jarFile.entries();
        while (object.hasMoreElements()) {
            String string = object.nextElement().getName();
            if (!string.startsWith("vendor") || !string.endsWith(".jar")) continue;
            arrayList.add("/" + (String)string);
        }
        object = new ArrayList();
        for (String string : arrayList) {
            object.add(this.extractJar(string));
        }
        return object.toArray(new URL[object.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL extractJar(String string) throws Exception {
        InputStream inputStream = new URL("jar:" + this.path.replace(MAIN, string)).openStream();
        String string2 = string.substring(string.lastIndexOf("/") + 1, string.lastIndexOf("."));
        File file = new File(this.extractRoot, string2 + ".jar");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            byte[] byArray = new byte[65536];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            fileOutputStream.close();
        }
        this.debug(string2 + ".jar extracted to " + file.getPath());
        return file.toURI().toURL();
    }

    private int launchJRuby(URL[] uRLArray) throws Exception {
        System.setProperty("org.jruby.embed.class.path", "");
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        Class<?> clazz = Class.forName("org.jruby.embed.ScriptingContainer", true, uRLClassLoader);
        Object obj = clazz.newInstance();
        Method method = clazz.getDeclaredMethod("setArgv", String[].class);
        method.invoke(obj, new Object[]{this.args});
        Method method2 = clazz.getDeclaredMethod("setClassLoader", ClassLoader.class);
        method2.invoke(obj, uRLClassLoader);
        this.debug("invoking " + this.jarfile + " with: " + Arrays.deepToString(this.args));
        Method method3 = clazz.getDeclaredMethod("runScriptlet", String.class);
        return ((Number)method3.invoke(obj, "begin\nrequire 'lib/main.rb'\n0\nrescue SystemExit => e\ne.status\nend")).intValue();
    }

    private int start() throws Exception {
        URL[] uRLArray = this.extractJRuby();
        return this.launchJRuby(uRLArray);
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.delete(fileArray[i]);
            }
        }
        file.delete();
    }

    @Override
    public void run() {
        this.delete(this.extractRoot);
    }

    public static void main(String[] stringArray) {
        try {
            int n = new Main(stringArray).start();
            System.exit(n);
        }
        catch (Exception exception) {
            Throwable throwable;
            for (throwable = exception; throwable.getCause() != null && throwable.getCause() != throwable; throwable = throwable.getCause()) {
            }
            if (Main.isDebug()) {
                throwable.printStackTrace();
            }
            System.exit(1);
        }
    }

    private static boolean isDebug() {
        return System.getProperty("kinetic.debug") != null;
    }
}

