#!/bin/sh
#
# Script for updating the Mac OS X engine. This script will be 
# run from the directory containing the installer binaries.
#
# Copyright 2010 by Sonic Solutions. All rights reserved.
#
#

# globals
TAR_FILE=/tmp/retro/retroinstaller.tar
INSTALLER_PATH=/tmp/retro
SLEEP_TIME=1

# untar installer
cd "$INSTALLER_PATH"
sudo tar -xvf $TAR_FILE -C $INSTALLER_PATH
sleep $SLEEP_TIME

# start the installer
cd "$INSTALLER_PATH"
sudo installer -verboseR -pkg "Retrospect Engine Installer.pkg" -target /

# clean up
cd "$INSTALLER_PATH"
sudo rm -f $TAR_FILE engineupdater.sh
