#!/usr/bin/ruby

# This file is used to generate the datahooks.qrc resource file for the QT dashboard

require 'find'

datahooks_path = "datahooks/"
datahooks_qrc_path = "../../qt/dashboard/resources/datahooks.qrc"

all_items = []
Find.find(datahooks_path) {|path|
  all_items << path if path =~ /.*\.html$/
  all_items << path if path =~ /.*\.css$/
  all_items << path if path =~ /.*\.js$/
  all_items << path if path =~ /.*\.xml$/
}

File.open(datahooks_qrc_path, "w") do |file|
    file.puts "<RCC>"
    file.puts "\t<qresource prefix=\"/\">"
    all_items.each do |path|
        file.puts "\t\t<file alias=\"#{path}\">../../../mac/dashboard/#{path}</file>"
    end
    file.puts "\t</qresource>"
    file.puts "</RCC>"
end
