#!/bin/bash
#
# Retrospect Client Install script
# 5/2022
# 
# (C) 2022 Retrospect, Inc. Portions (C) 1989-2010 EMC Corporation. All rights reserved.
# www.retrospect.com
# 

CLIENTDIR=/usr/local/retrospect
CLIENTLOGFILES=/var/log/
EXCLUDEFILE=/etc/retroclient.excludes
ETCSERVICEFILE=/etc/systemd/system/retroclient.service
USRSERVICEFILE=/usr/lib/systemd/system/retroclient.service
INITDFILE=/etc/init.d/rcl
RCD=rc.d/

ISROOT="YES"

# Check uninstaller dependencies
numErrors=0
if [ "$(id -u)" != 0 ]; then
    echo "Sorry, uninstallation requires that you be logged on as root."
    numErrors=$((numErrors + 1))
fi

echo
echo -n "Uninstall Retrospect Client? (y/n): "
read X

if [ "$X" != "y" ] && [ "$X" != "Y" ]; then
        echo "Uninstallation canceled."
        exit 1
fi

# Red Hat and CentOS locations
if [ -r "/etc/redhat-release" ]; then
    INITDFILE=/etc/rc.d/init.d/rcl
fi

# Ubuntu service file location
if [ -d "/lib/systemd/system" ]; then
    USRSERVICEFILE=/lib/systemd/system/retroclient.service
fi

# Stop the client first and delete associated files
# retroclient.service file will be in multiple locations
if [ -f $ETCSERVICEFILE ] || [ -f $USRSERVICEFILE ]; then
    systemctl stop retroclient.service
    /bin/rm -f $USRSERVICEFILE
    /bin/rm -f $ETCSERVICEFILE
    /bin/rm -f /etc/systemd/system/multi-user.target.wants/retroclient.service
else
    $INITDFILE stop /dev/null
    /bin/rm -f $INITDFILE
fi

# Delete the rest of the client files
/bin/rm -f $EXCLUDEFILE
/bin/rm -f $CLIENTLOGFILES/retroclient.*
/bin/rm -f $CLIENTLOGFILES/retropds.log
/bin/rm -fR $CLIENTDIR
/bin/rm -f /usr/local/man/man1/retroclient.*
/bin/rm -f /usr/local/man/man1/retrocpl.*
/bin/rm -f /usr/share/info/retroclient.info.gz

if [ -d "/usr/man/man1" ]; then
	/bin/rm -f /usr/man/man1/retroclient.*
	/bin/rm -f /usr/man/man1/retrocpl.*
fi

if [ -d "/etc/${RCD}rc2.d" ]; then
    for Y in 2 3 5; do
        /bin/rm -f /etc/${RCD}rc$Y.d/s99retroclient
    done
    if [ -r '/etc/redhat-release' ]; then
        chkconfig --del rcl 2> /dev/null
    fi
elif [ -f "/etc/rc.local" ]; then
      echo "Your system uses a rc.local start up script, you may need to remove the following line"
      echo "'/usr/local/retrospect/client/rcl' start from /etc/rc.local"
fi
echo
echo "Retrospect client uninstall script has completed"
exit 0
