/* Macros to swap the order of bytes in integer values.
   Copyright (C) 1997, 1998, 2000, 2001, 2002 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/* Modified by Phil Carns (pcarns@parl.clemson.edu) 
 * June 2003
 * For use with custom network encoding routines in the BMI component of 
 * the Parallel Virtual File System version 2.
 */

#ifndef __BMI_BYTESWAP_H
#define __BMI_BYTESWAP_H 

#include "pvfs2-internal.h"

#ifndef __bswap_16
/* Swap bytes in 16 bit value.  */
#ifdef __GNUC__
# define __bswap_16(x) \
    (__extension__							      \
     ({ unsigned short int __bsx = (x);					      \
        ((((__bsx) >> 8) & 0xff) | (((__bsx) & 0xff) << 8)); }))
#else
static __inline unsigned short int
__bswap_16 (unsigned short int __bsx)
{
  return ((((__bsx) >> 8) & 0xff) | (((__bsx) & 0xff) << 8));
}
#endif
#endif

#ifndef __bswap_32
/* Swap bytes in 32 bit value.  */
#ifdef __GNUC__
# define __bswap_32(x) \
    (__extension__							      \
     ({ unsigned int __bsx = (x);					      \
        ((((__bsx) & 0xff000000) >> 24) | (((__bsx) & 0x00ff0000) >>  8) |    \
	 (((__bsx) & 0x0000ff00) <<  8) | (((__bsx) & 0x000000ff) << 24)); }))
#else
static __inline unsigned int
__bswap_32 (unsigned int __bsx)
{
  return ((((__bsx) & 0xff000000) >> 24) | (((__bsx) & 0x00ff0000) >>  8) |
	  (((__bsx) & 0x0000ff00) <<  8) | (((__bsx) & 0x000000ff) << 24));
}
#endif
#endif

#ifndef __bswap_64
#if defined __GNUC__ && __GNUC__ >= 2
/* Swap bytes in 64 bit value.  */
#ifndef __bswap_constant_64
# define __bswap_constant_64(x) \
     ((((x) & 0xff00000000000000ull) >> 56)				      \
      | (((x) & 0x00ff000000000000ull) >> 40)				      \
      | (((x) & 0x0000ff0000000000ull) >> 24)				      \
      | (((x) & 0x000000ff00000000ull) >> 8)				      \
      | (((x) & 0x00000000ff000000ull) << 8)				      \
      | (((x) & 0x0000000000ff0000ull) << 24)				      \
      | (((x) & 0x000000000000ff00ull) << 40)				      \
      | (((x) & 0x00000000000000ffull) << 56))
#endif

#ifndef BSWAP_64_IS_A_FUNC
# define __bswap_64(x) \
     (__extension__							      \
      ({ union { __extension__ unsigned long long int __ll;		      \
		 unsigned int __l[2]; } __w, __r;			      \
         if (__builtin_constant_p (x))					      \
	   __r.__ll = __bswap_constant_64 (x);				      \
	 else								      \
	   {								      \
	     __w.__ll = (x);						      \
	     __r.__l[0] = __bswap_32 (__w.__l[1]);			      \
	     __r.__l[1] = __bswap_32 (__w.__l[0]);			      \
	   }								      \
	 __r.__ll; }))
#endif
#else
#ifdef WORDS_BIGENDIAN
#error FIX ME: no 64 bit bswap routine for non GNUC preprocessor.
#endif
#endif
#endif 

#ifdef WORDS_BIGENDIAN
#define htobmi16(x) __bswap_16(x)
#define htobmi32(x) __bswap_32(x)
#define htobmi64(x) __bswap_64(x)
#else
#define htobmi16(x) x
#define htobmi32(x) x
#define htobmi64(x) x
#endif

#define bmitoh16(x) htobmi16(x) 
#define bmitoh32(x) htobmi32(x)
#define bmitoh64(x) htobmi64(x)

#endif /* __BMI_BYTESWAP_H */

