#!/usr/bin/perl -w

#
# This code parses a header file with prototypes and generates the code for the functions
# for us.  I should document it better.
#

# init_token() - call before calling next_token()
sub init_token()
{
    # skip to start of prototypes
    while(<>) {
	if ( /\/\* BEGIN AUTOGEN PROTOTYPES/ ) { last; }
    }

    $pos = 1;
    @tokens = ();
}

# next_token() - returns next token.  starts with first line after BEGIN PROTOTYPES,
#                ends with line before END PROTOTYPES, returns "" once all tokens are
#                read.
#
# TODO: skip comments
#
sub next_token()
{
    while (1) {
	if ($pos >= @tokens) {
	    $pos = 0;
	    if ($_ = <>) {
		if ( /\/\* END AUTOGEN PROTOTYPES/ ) { return ""; }
		
		@tokens = split(/([\s|\*+|\(|\)|,])/);
	    }
	    else { return ""; }
	}
	
	if ($tokens[$pos] =~ /^\s+/ || $tokens[$pos] eq "") { $pos++; }
	else { return $tokens[$pos++]; }
    }
}

# spit_out_header() - call before starting to output code
sub spit_out_header()
{
    print "/*\
 * (C) 2002 Clemson University and The University of Chicago\
 *\
 * See COPYING in top-level directory.\
 */\
\
/* THIS FILE IS AUTOMATICALLY GENERATED FROM HEADERS -- DO NOT EDIT!!! */\
\
#include \"trove.h\"\
#include \"trove-internal.h\"\
\
extern struct TROVE_keyval_ops  *keyval_method_table[];\
extern struct TROVE_dspace_ops  *dspace_method_table[];\
extern struct TROVE_bstream_ops *bstream_method_table[];\
extern struct TROVE_mgmt_ops    *mgmt_method_table[];";

    printf "\n\n";
}

# spit_out_code() - creates code for us.
#
#                   This relies on $arg_nr being index to last argument in $arg_type[]
#                   and $arg_name[] arrays, and $ret_type and $fn_name being set.
#                   These are set by the main loop.
sub spit_out_code()
{
    printf "%s %s(\n", $ret_type, $fn_name;
    for ($i=0; $i <= $arg_nr; $i++) {
	printf "    %s %s", $arg_type[$i], $arg_name[$i];
	if ($i == $arg_nr) { printf ")\n{\n"; }
	else { printf ",\n"; }
    }

    print "    int method_id;\
\
    method_id = map_coll_id_to_method(coll_id);\
    if (method_id < 0) {\
        return -1; /* NEED STATUS TYPE FOR THIS */\
    }\
";

    $short_name = $fn_name;
    $short_name =~ s/trove_//;

    if ($short_name =~ /bstream/) {
	printf "    return bstream_method_table[method_id]->";
    }
    elsif ($short_name =~ /keyval/) {
	printf "    return keyval_method_table[method_id]->";
    }
    elsif ($short_name =~ /dspace/) {
	printf "    return dspace_method_table[method_id]->";
    }
    elsif ($short_name =~ /collection/) {
	printf "    return mgmt_method_table[method_id]->";
    }
    else {
	printf "unexpected function name\n";
	exit -1;
    }

    printf "%s(\n", $short_name;
    for ($i=0; $i <= $arg_nr; $i++) {
	printf "           %s", $arg_name[$i];
	if ($i == $arg_nr) { printf ");\n}\n\n"; }
	else { printf ",\n"; }
    }
}

#
# main loop
#

init_token();

spit_out_header();

# while (1) { print '"', next_token(), '"', "\n"; }

#
# Our states:
# 0 - before start of fn
# 1 - reading return type
# 2 - starting read of type of parameter
# 3 - reading parameter name
# 4 - end of function
# 5 - continuing to read type of parameter
#
$state = 0;
$token = next_token();
$arg_nr = 0;

while (1) {
    SWITCH: {
	if ($state == 0) {
	    $ret_type = $token;
	    $token = next_token();
	    $state = 1;
	    last SWITCH;
	}
	if ($state == 1) {
	    if ($token eq "*") {
		$ret_type = $ret_type . "*";
		$token = next_token();
		# keep looking for more return type
	    }
	    else {
		$fn_name = $token;
		$token = next_token();
		if ($token ne "(") {
		    printf "state 1, expected (, got \"%s\"\n", $token;
		    exit -1;
		}
		$token = next_token();
		$state = 2;
	    }
	    last SWITCH;
	}
	if ($state == 2) {
	    $arg_type[$arg_nr] = $token;
	    $token = next_token();
	    $state = 5;
	    

	    last SWITCH;
	}
	if ($state == 5) {
	    if ($token eq "*") {
		$arg_type[$arg_nr] = $arg_type[$arg_nr] . "*";
		# printf "partial name is %s\n", $arg_type[$arg_nr];
		$token = next_token();
		# keep looking for more argument type
	    }
	    else {
		# printf "  arg_type[%d] = %s\n", $arg_nr, $arg_type[$arg_nr];
		$state = 3;
	    }
	    last SWITCH;
	}
	if ($state == 3) {
	    $arg_name[$arg_nr] = $token;
	    # printf "  arg_name[%d] = %s\n", $arg_nr, $token;
	    $token = next_token();
	    if ($token eq ",") {
		$token = next_token();
		$arg_nr++;
		$state = 2;
	    }
	    elsif ($token ne ")") { 
		printf "state 3, expected ), got \"%s\"\n", $token;
		exit -1;
	    }
	    else {
		$token = next_token();
		if ($token ne ";") { 
		    printf "state 3, expected ;, got \"%s\"\n", $token;
		    exit -1;
		}
		$token = next_token();
		$state = 4;
	    }
	    last SWITCH;
	}
	if ($state == 4) {
	    #
	    # END OF FUNCTION
	    #
	    # printf "%s %s()\n", $ret_type, $fn_name;

	    spit_out_code();

	    $state = 0;
	    $arg_nr = 0;

	    if ($token eq "") { exit 0; }
	    last SWITCH;
	}
    }
}







