#ifndef _DT_BINDINGS_PINCTRL_IMX7D_H
#define _DT_BINDINGS_PINCTRL_IMX7D_H

/* see Documentation/devicetree/bindings/pinctrl/fsl,imx7d-pinctrl.txt */

#define NO_PAD_CTRL			(1 << 31)
#define IOMUX_CONFIG_SION		(1 << 30)

/* Drive Strength */
#define PAD_CTL_DSE_X1			(0 << 0) /* default */
#define PAD_CTL_DSE_X4			(1 << 0)
#define PAD_CTL_DSE_X2			(2 << 0)
#define PAD_CTL_DSE_X6			(3 << 0)

/* Slew Rate */
#define PAD_CTL_SRE_FAST		(0 << 2)
#define PAD_CTL_SRE_SLOW		(1 << 2) /* default */

/* Hysteresis */
#define PAD_CTL_HYS			(1 << 3)

/* Pull Select */
#define PAD_CTL_PUE			(1 << 4)
#define PAD_CTL_PUS_100K_DOWN		(0 << 5 | PAD_CTL_PUE)
#define PAD_CTL_PUS_5K_UP		(1 << 5 | PAD_CTL_PUE)
#define PAD_CTL_PUS_47K_UP		(2 << 5 | PAD_CTL_PUE)
#define PAD_CTL_PUS_100K_UP		(3 << 5 | PAD_CTL_PUE)

#endif
