/*
 * Freescale PXP Register Definitions
 *
 * Copyright (C) 2012-2013 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 *
 * Xml Revision: 1.29
 * Template revision: 1.3
 */

#ifndef __ARCH_ARM___PXP_H
#define __ARCH_ARM___PXP_H

#define HW_PXP_CTRL	(0x00000000)
#define HW_PXP_CTRL_SET	(0x00000004)
#define HW_PXP_CTRL_CLR	(0x00000008)
#define HW_PXP_CTRL_TOG	(0x0000000c)

#define BM_PXP_CTRL_SFTRST 0x80000000
#define BM_PXP_CTRL_CLKGATE 0x40000000
#define BM_PXP_CTRL_RSVD4 0x20000000
#define BM_PXP_CTRL_EN_REPEAT 0x10000000
#define BP_PXP_CTRL_RSVD3      26
#define BM_PXP_CTRL_RSVD3 0x0C000000
#define BF_PXP_CTRL_RSVD3(v)  \
	(((v) << 26) & BM_PXP_CTRL_RSVD3)
#define BP_PXP_CTRL_INTERLACED_INPUT	  24
#define BM_PXP_CTRL_INTERLACED_INPUT 0x03000000
#define BF_PXP_CTRL_INTERLACED_INPUT(v)  \
	(((v) << 24) & BM_PXP_CTRL_INTERLACED_INPUT)
#define BV_PXP_CTRL_INTERLACED_INPUT__PROGRESSIVE 0x0
#define BV_PXP_CTRL_INTERLACED_INPUT__FIELD0	  0x2
#define BV_PXP_CTRL_INTERLACED_INPUT__FIELD1	  0x3
#define BM_PXP_CTRL_BLOCK_SIZE 0x00800000
#define BV_PXP_CTRL_BLOCK_SIZE__8X8   0x0
#define BV_PXP_CTRL_BLOCK_SIZE__16X16 0x1
#define BM_PXP_CTRL_ROT_POS 0x00400000
#define BM_PXP_CTRL_IN_PLACE 0x00200000
#define BP_PXP_CTRL_RSVD1      12
#define BM_PXP_CTRL_RSVD1 0x001FF000
#define BF_PXP_CTRL_RSVD1(v)  \
	(((v) << 12) & BM_PXP_CTRL_RSVD1)
#define BM_PXP_CTRL_VFLIP 0x00000800
#define BM_PXP_CTRL_HFLIP 0x00000400
#define BP_PXP_CTRL_ROTATE	8
#define BM_PXP_CTRL_ROTATE 0x00000300
#define BF_PXP_CTRL_ROTATE(v)  \
	(((v) << 8) & BM_PXP_CTRL_ROTATE)
#define BV_PXP_CTRL_ROTATE__ROT_0   0x0
#define BV_PXP_CTRL_ROTATE__ROT_90  0x1
#define BV_PXP_CTRL_ROTATE__ROT_180 0x2
#define BV_PXP_CTRL_ROTATE__ROT_270 0x3
#define BP_PXP_CTRL_RSVD0      5
#define BM_PXP_CTRL_RSVD0 0x000000E0
#define BF_PXP_CTRL_RSVD0(v)  \
	(((v) << 5) & BM_PXP_CTRL_RSVD0)
#define BM_PXP_CTRL_ENABLE_LCD_HANDSHAKE 0x00000010
#define BM_PXP_CTRL_LUT_DMA_IRQ_ENABLE 0x00000008
#define BM_PXP_CTRL_NEXT_IRQ_ENABLE 0x00000004
#define BM_PXP_CTRL_IRQ_ENABLE 0x00000002
#define BM_PXP_CTRL_ENABLE 0x00000001

#define HW_PXP_STAT	(0x00000010)
#define HW_PXP_STAT_SET	(0x00000014)
#define HW_PXP_STAT_CLR	(0x00000018)
#define HW_PXP_STAT_TOG	(0x0000001c)

#define BP_PXP_STAT_BLOCKX	24
#define BM_PXP_STAT_BLOCKX 0xFF000000
#define BF_PXP_STAT_BLOCKX(v) \
	(((v) << 24) & BM_PXP_STAT_BLOCKX)
#define BP_PXP_STAT_BLOCKY	16
#define BM_PXP_STAT_BLOCKY 0x00FF0000
#define BF_PXP_STAT_BLOCKY(v)  \
	(((v) << 16) & BM_PXP_STAT_BLOCKY)
#define BP_PXP_STAT_RSVD2      9
#define BM_PXP_STAT_RSVD2 0x0000FE00
#define BF_PXP_STAT_RSVD2(v)  \
	(((v) << 9) & BM_PXP_STAT_RSVD2)
#define BM_PXP_STAT_LUT_DMA_LOAD_DONE_IRQ 0x00000100
#define BP_PXP_STAT_AXI_ERROR_ID      4
#define BM_PXP_STAT_AXI_ERROR_ID 0x000000F0
#define BF_PXP_STAT_AXI_ERROR_ID(v)  \
	(((v) << 4) & BM_PXP_STAT_AXI_ERROR_ID)
#define BM_PXP_STAT_NEXT_IRQ 0x00000008
#define BM_PXP_STAT_AXI_READ_ERROR 0x00000004
#define BM_PXP_STAT_AXI_WRITE_ERROR 0x00000002
#define BM_PXP_STAT_IRQ 0x00000001

#define HW_PXP_OUT_CTRL	(0x00000020)
#define HW_PXP_OUT_CTRL_SET	(0x00000024)
#define HW_PXP_OUT_CTRL_CLR	(0x00000028)
#define HW_PXP_OUT_CTRL_TOG	(0x0000002c)

#define BP_PXP_OUT_CTRL_ALPHA	   24
#define BM_PXP_OUT_CTRL_ALPHA 0xFF000000
#define BF_PXP_OUT_CTRL_ALPHA(v) \
	(((v) << 24) & BM_PXP_OUT_CTRL_ALPHA)
#define BM_PXP_OUT_CTRL_ALPHA_OUTPUT 0x00800000
#define BP_PXP_OUT_CTRL_RSVD1	   10
#define BM_PXP_OUT_CTRL_RSVD1 0x007FFC00
#define BF_PXP_OUT_CTRL_RSVD1(v)  \
	(((v) << 10) & BM_PXP_OUT_CTRL_RSVD1)
#define BP_PXP_OUT_CTRL_INTERLACED_OUTPUT      8
#define BM_PXP_OUT_CTRL_INTERLACED_OUTPUT 0x00000300
#define BF_PXP_OUT_CTRL_INTERLACED_OUTPUT(v)  \
	(((v) << 8) & BM_PXP_OUT_CTRL_INTERLACED_OUTPUT)
#define BV_PXP_OUT_CTRL_INTERLACED_OUTPUT__PROGRESSIVE 0x0
#define BV_PXP_OUT_CTRL_INTERLACED_OUTPUT__FIELD0      0x1
#define BV_PXP_OUT_CTRL_INTERLACED_OUTPUT__FIELD1      0x2
#define BV_PXP_OUT_CTRL_INTERLACED_OUTPUT__INTERLACED  0x3
#define BP_PXP_OUT_CTRL_RSVD0	   5
#define BM_PXP_OUT_CTRL_RSVD0 0x000000E0
#define BF_PXP_OUT_CTRL_RSVD0(v)  \
	(((v) << 5) & BM_PXP_OUT_CTRL_RSVD0)
#define BP_PXP_OUT_CTRL_FORMAT	    0
#define BM_PXP_OUT_CTRL_FORMAT 0x0000001F
#define BF_PXP_OUT_CTRL_FORMAT(v)  \
	(((v) << 0) & BM_PXP_OUT_CTRL_FORMAT)
#define BV_PXP_OUT_CTRL_FORMAT__ARGB8888  0x0
#define BV_PXP_OUT_CTRL_FORMAT__RGB888	  0x4
#define BV_PXP_OUT_CTRL_FORMAT__RGB888P   0x5
#define BV_PXP_OUT_CTRL_FORMAT__ARGB1555  0x8
#define BV_PXP_OUT_CTRL_FORMAT__ARGB4444  0x9
#define BV_PXP_OUT_CTRL_FORMAT__RGB555	  0xC
#define BV_PXP_OUT_CTRL_FORMAT__RGB444	  0xD
#define BV_PXP_OUT_CTRL_FORMAT__RGB565	  0xE
#define BV_PXP_OUT_CTRL_FORMAT__YUV1P444  0x10
#define BV_PXP_OUT_CTRL_FORMAT__UYVY1P422 0x12
#define BV_PXP_OUT_CTRL_FORMAT__VYUY1P422 0x13
#define BV_PXP_OUT_CTRL_FORMAT__Y8	  0x14
#define BV_PXP_OUT_CTRL_FORMAT__Y4	  0x15
#define BV_PXP_OUT_CTRL_FORMAT__YUV2P422  0x18
#define BV_PXP_OUT_CTRL_FORMAT__YUV2P420  0x19
#define BV_PXP_OUT_CTRL_FORMAT__YVU2P422  0x1A
#define BV_PXP_OUT_CTRL_FORMAT__YVU2P420  0x1B

#define HW_PXP_OUT_BUF	(0x00000030)

#define BP_PXP_OUT_BUF_ADDR	 0
#define BM_PXP_OUT_BUF_ADDR 0xFFFFFFFF
#define BF_PXP_OUT_BUF_ADDR(v)	 (v)

#define HW_PXP_OUT_BUF2	(0x00000040)

#define BP_PXP_OUT_BUF2_ADDR	  0
#define BM_PXP_OUT_BUF2_ADDR 0xFFFFFFFF
#define BF_PXP_OUT_BUF2_ADDR(v)   (v)

#define HW_PXP_OUT_PITCH	(0x00000050)

#define BP_PXP_OUT_PITCH_RSVD	   16
#define BM_PXP_OUT_PITCH_RSVD 0xFFFF0000
#define BF_PXP_OUT_PITCH_RSVD(v) \
	(((v) << 16) & BM_PXP_OUT_PITCH_RSVD)
#define BP_PXP_OUT_PITCH_PITCH	    0
#define BM_PXP_OUT_PITCH_PITCH 0x0000FFFF
#define BF_PXP_OUT_PITCH_PITCH(v)  \
	(((v) << 0) & BM_PXP_OUT_PITCH_PITCH)

#define HW_PXP_OUT_LRC	(0x00000060)

#define BP_PXP_OUT_LRC_RSVD1	  30
#define BM_PXP_OUT_LRC_RSVD1 0xC0000000
#define BF_PXP_OUT_LRC_RSVD1(v) \
	(((v) << 30) & BM_PXP_OUT_LRC_RSVD1)
#define BP_PXP_OUT_LRC_X      16
#define BM_PXP_OUT_LRC_X 0x3FFF0000
#define BF_PXP_OUT_LRC_X(v)  \
	(((v) << 16) & BM_PXP_OUT_LRC_X)
#define BP_PXP_OUT_LRC_RSVD0	  14
#define BM_PXP_OUT_LRC_RSVD0 0x0000C000
#define BF_PXP_OUT_LRC_RSVD0(v)  \
	(((v) << 14) & BM_PXP_OUT_LRC_RSVD0)
#define BP_PXP_OUT_LRC_Y      0
#define BM_PXP_OUT_LRC_Y 0x00003FFF
#define BF_PXP_OUT_LRC_Y(v)  \
	(((v) << 0) & BM_PXP_OUT_LRC_Y)

#define HW_PXP_OUT_PS_ULC	(0x00000070)

#define BP_PXP_OUT_PS_ULC_RSVD1      30
#define BM_PXP_OUT_PS_ULC_RSVD1 0xC0000000
#define BF_PXP_OUT_PS_ULC_RSVD1(v) \
	(((v) << 30) & BM_PXP_OUT_PS_ULC_RSVD1)
#define BP_PXP_OUT_PS_ULC_X	 16
#define BM_PXP_OUT_PS_ULC_X 0x3FFF0000
#define BF_PXP_OUT_PS_ULC_X(v)	\
	(((v) << 16) & BM_PXP_OUT_PS_ULC_X)
#define BP_PXP_OUT_PS_ULC_RSVD0      14
#define BM_PXP_OUT_PS_ULC_RSVD0 0x0000C000
#define BF_PXP_OUT_PS_ULC_RSVD0(v)  \
	(((v) << 14) & BM_PXP_OUT_PS_ULC_RSVD0)
#define BP_PXP_OUT_PS_ULC_Y	 0
#define BM_PXP_OUT_PS_ULC_Y 0x00003FFF
#define BF_PXP_OUT_PS_ULC_Y(v)	\
	(((v) << 0) & BM_PXP_OUT_PS_ULC_Y)

#define HW_PXP_OUT_PS_LRC	(0x00000080)

#define BP_PXP_OUT_PS_LRC_RSVD1      30
#define BM_PXP_OUT_PS_LRC_RSVD1 0xC0000000
#define BF_PXP_OUT_PS_LRC_RSVD1(v) \
	(((v) << 30) & BM_PXP_OUT_PS_LRC_RSVD1)
#define BP_PXP_OUT_PS_LRC_X	 16
#define BM_PXP_OUT_PS_LRC_X 0x3FFF0000
#define BF_PXP_OUT_PS_LRC_X(v)	\
	(((v) << 16) & BM_PXP_OUT_PS_LRC_X)
#define BP_PXP_OUT_PS_LRC_RSVD0      14
#define BM_PXP_OUT_PS_LRC_RSVD0 0x0000C000
#define BF_PXP_OUT_PS_LRC_RSVD0(v)  \
	(((v) << 14) & BM_PXP_OUT_PS_LRC_RSVD0)
#define BP_PXP_OUT_PS_LRC_Y	 0
#define BM_PXP_OUT_PS_LRC_Y 0x00003FFF
#define BF_PXP_OUT_PS_LRC_Y(v)	\
	(((v) << 0) & BM_PXP_OUT_PS_LRC_Y)

#define HW_PXP_OUT_AS_ULC	(0x00000090)

#define BP_PXP_OUT_AS_ULC_RSVD1      30
#define BM_PXP_OUT_AS_ULC_RSVD1 0xC0000000
#define BF_PXP_OUT_AS_ULC_RSVD1(v) \
	(((v) << 30) & BM_PXP_OUT_AS_ULC_RSVD1)
#define BP_PXP_OUT_AS_ULC_X	 16
#define BM_PXP_OUT_AS_ULC_X 0x3FFF0000
#define BF_PXP_OUT_AS_ULC_X(v)	\
	(((v) << 16) & BM_PXP_OUT_AS_ULC_X)
#define BP_PXP_OUT_AS_ULC_RSVD0      14
#define BM_PXP_OUT_AS_ULC_RSVD0 0x0000C000
#define BF_PXP_OUT_AS_ULC_RSVD0(v)  \
	(((v) << 14) & BM_PXP_OUT_AS_ULC_RSVD0)
#define BP_PXP_OUT_AS_ULC_Y	 0
#define BM_PXP_OUT_AS_ULC_Y 0x00003FFF
#define BF_PXP_OUT_AS_ULC_Y(v)	\
	(((v) << 0) & BM_PXP_OUT_AS_ULC_Y)

#define HW_PXP_OUT_AS_LRC	(0x000000a0)

#define BP_PXP_OUT_AS_LRC_RSVD1      30
#define BM_PXP_OUT_AS_LRC_RSVD1 0xC0000000
#define BF_PXP_OUT_AS_LRC_RSVD1(v) \
	(((v) << 30) & BM_PXP_OUT_AS_LRC_RSVD1)
#define BP_PXP_OUT_AS_LRC_X	 16
#define BM_PXP_OUT_AS_LRC_X 0x3FFF0000
#define BF_PXP_OUT_AS_LRC_X(v)	\
	(((v) << 16) & BM_PXP_OUT_AS_LRC_X)
#define BP_PXP_OUT_AS_LRC_RSVD0      14
#define BM_PXP_OUT_AS_LRC_RSVD0 0x0000C000
#define BF_PXP_OUT_AS_LRC_RSVD0(v)  \
	(((v) << 14) & BM_PXP_OUT_AS_LRC_RSVD0)
#define BP_PXP_OUT_AS_LRC_Y	 0
#define BM_PXP_OUT_AS_LRC_Y 0x00003FFF
#define BF_PXP_OUT_AS_LRC_Y(v)	\
	(((v) << 0) & BM_PXP_OUT_AS_LRC_Y)

#define HW_PXP_PS_CTRL	(0x000000b0)
#define HW_PXP_PS_CTRL_SET	(0x000000b4)
#define HW_PXP_PS_CTRL_CLR	(0x000000b8)
#define HW_PXP_PS_CTRL_TOG	(0x000000bc)

#define BP_PXP_PS_CTRL_RSVD1	  12
#define BM_PXP_PS_CTRL_RSVD1 0xFFFFF000
#define BF_PXP_PS_CTRL_RSVD1(v) \
	(((v) << 12) & BM_PXP_PS_CTRL_RSVD1)
#define BP_PXP_PS_CTRL_DECX	 10
#define BM_PXP_PS_CTRL_DECX 0x00000C00
#define BF_PXP_PS_CTRL_DECX(v)	\
	(((v) << 10) & BM_PXP_PS_CTRL_DECX)
#define BV_PXP_PS_CTRL_DECX__DISABLE 0x0
#define BV_PXP_PS_CTRL_DECX__DECX2   0x1
#define BV_PXP_PS_CTRL_DECX__DECX4   0x2
#define BV_PXP_PS_CTRL_DECX__DECX8   0x3
#define BP_PXP_PS_CTRL_DECY	 8
#define BM_PXP_PS_CTRL_DECY 0x00000300
#define BF_PXP_PS_CTRL_DECY(v)	\
	(((v) << 8) & BM_PXP_PS_CTRL_DECY)
#define BV_PXP_PS_CTRL_DECY__DISABLE 0x0
#define BV_PXP_PS_CTRL_DECY__DECY2   0x1
#define BV_PXP_PS_CTRL_DECY__DECY4   0x2
#define BV_PXP_PS_CTRL_DECY__DECY8   0x3
#define BP_PXP_PS_CTRL_SWAP 5
#define BM_PXP_PS_CTRL_SWAP 0x000000E0
#define BF_PXP_PS_CTRL_SWAP(v)  \
	(((v) << 5) & BM_PXP_PS_CTRL_SWAP)
#define BP_PXP_PS_CTRL_FORMAT	   0
#define BM_PXP_PS_CTRL_FORMAT 0x0000001F
#define BF_PXP_PS_CTRL_FORMAT(v)  \
	(((v) << 0) & BM_PXP_PS_CTRL_FORMAT)
#define BV_PXP_PS_CTRL_FORMAT__RGB888	 0x4
#define BV_PXP_PS_CTRL_FORMAT__RGB555	 0xC
#define BV_PXP_PS_CTRL_FORMAT__RGB444	 0xD
#define BV_PXP_PS_CTRL_FORMAT__RGB565	 0xE
#define BV_PXP_PS_CTRL_FORMAT__YUV1P444  0x10
#define BV_PXP_PS_CTRL_FORMAT__UYVY1P422 0x12
#define BV_PXP_PS_CTRL_FORMAT__VYUY1P422 0x13
#define BV_PXP_PS_CTRL_FORMAT__Y8	 0x14
#define BV_PXP_PS_CTRL_FORMAT__Y4	 0x15
#define BV_PXP_PS_CTRL_FORMAT__YUV2P422  0x18
#define BV_PXP_PS_CTRL_FORMAT__YUV2P420  0x19
#define BV_PXP_PS_CTRL_FORMAT__YVU2P422  0x1A
#define BV_PXP_PS_CTRL_FORMAT__YVU2P420  0x1B
#define BV_PXP_PS_CTRL_FORMAT__YUV422	 0x1E
#define BV_PXP_PS_CTRL_FORMAT__YUV420	 0x1F

#define HW_PXP_PS_BUF	(0x000000c0)

#define BP_PXP_PS_BUF_ADDR	0
#define BM_PXP_PS_BUF_ADDR 0xFFFFFFFF
#define BF_PXP_PS_BUF_ADDR(v)	(v)

#define HW_PXP_PS_UBUF	(0x000000d0)

#define BP_PXP_PS_UBUF_ADDR	 0
#define BM_PXP_PS_UBUF_ADDR 0xFFFFFFFF
#define BF_PXP_PS_UBUF_ADDR(v)	 (v)

#define HW_PXP_PS_VBUF	(0x000000e0)

#define BP_PXP_PS_VBUF_ADDR	 0
#define BM_PXP_PS_VBUF_ADDR 0xFFFFFFFF
#define BF_PXP_PS_VBUF_ADDR(v)	 (v)

#define HW_PXP_PS_PITCH	(0x000000f0)

#define BP_PXP_PS_PITCH_RSVD	  16
#define BM_PXP_PS_PITCH_RSVD 0xFFFF0000
#define BF_PXP_PS_PITCH_RSVD(v) \
	(((v) << 16) & BM_PXP_PS_PITCH_RSVD)
#define BP_PXP_PS_PITCH_PITCH	   0
#define BM_PXP_PS_PITCH_PITCH 0x0000FFFF
#define BF_PXP_PS_PITCH_PITCH(v)  \
	(((v) << 0) & BM_PXP_PS_PITCH_PITCH)

#define HW_PXP_PS_BACKGROUND	(0x00000100)

#define BP_PXP_PS_BACKGROUND_RSVD      24
#define BM_PXP_PS_BACKGROUND_RSVD 0xFF000000
#define BF_PXP_PS_BACKGROUND_RSVD(v) \
	(((v) << 24) & BM_PXP_PS_BACKGROUND_RSVD)
#define BP_PXP_PS_BACKGROUND_COLOR	0
#define BM_PXP_PS_BACKGROUND_COLOR 0x00FFFFFF
#define BF_PXP_PS_BACKGROUND_COLOR(v)  \
	(((v) << 0) & BM_PXP_PS_BACKGROUND_COLOR)

#define HW_PXP_PS_SCALE	(0x00000110)

#define BM_PXP_PS_SCALE_RSVD2 0x80000000
#define BP_PXP_PS_SCALE_YSCALE	    16
#define BM_PXP_PS_SCALE_YSCALE 0x7FFF0000
#define BF_PXP_PS_SCALE_YSCALE(v)  \
	(((v) << 16) & BM_PXP_PS_SCALE_YSCALE)
#define BM_PXP_PS_SCALE_RSVD1 0x00008000
#define BP_PXP_PS_SCALE_XSCALE	    0
#define BM_PXP_PS_SCALE_XSCALE 0x00007FFF
#define BF_PXP_PS_SCALE_XSCALE(v)  \
	(((v) << 0) & BM_PXP_PS_SCALE_XSCALE)

#define HW_PXP_PS_OFFSET	(0x00000120)

#define BP_PXP_PS_OFFSET_RSVD2	    28
#define BM_PXP_PS_OFFSET_RSVD2 0xF0000000
#define BF_PXP_PS_OFFSET_RSVD2(v) \
	(((v) << 28) & BM_PXP_PS_OFFSET_RSVD2)
#define BP_PXP_PS_OFFSET_YOFFSET      16
#define BM_PXP_PS_OFFSET_YOFFSET 0x0FFF0000
#define BF_PXP_PS_OFFSET_YOFFSET(v)  \
	(((v) << 16) & BM_PXP_PS_OFFSET_YOFFSET)
#define BP_PXP_PS_OFFSET_RSVD1	    12
#define BM_PXP_PS_OFFSET_RSVD1 0x0000F000
#define BF_PXP_PS_OFFSET_RSVD1(v)  \
	(((v) << 12) & BM_PXP_PS_OFFSET_RSVD1)
#define BP_PXP_PS_OFFSET_XOFFSET      0
#define BM_PXP_PS_OFFSET_XOFFSET 0x00000FFF
#define BF_PXP_PS_OFFSET_XOFFSET(v)  \
	(((v) << 0) & BM_PXP_PS_OFFSET_XOFFSET)

#define HW_PXP_PS_CLRKEYLOW	(0x00000130)

#define BP_PXP_PS_CLRKEYLOW_RSVD1      24
#define BM_PXP_PS_CLRKEYLOW_RSVD1 0xFF000000
#define BF_PXP_PS_CLRKEYLOW_RSVD1(v) \
	(((v) << 24) & BM_PXP_PS_CLRKEYLOW_RSVD1)
#define BP_PXP_PS_CLRKEYLOW_PIXEL      0
#define BM_PXP_PS_CLRKEYLOW_PIXEL 0x00FFFFFF
#define BF_PXP_PS_CLRKEYLOW_PIXEL(v)  \
	(((v) << 0) & BM_PXP_PS_CLRKEYLOW_PIXEL)

#define HW_PXP_PS_CLRKEYHIGH	(0x00000140)

#define BP_PXP_PS_CLRKEYHIGH_RSVD1	24
#define BM_PXP_PS_CLRKEYHIGH_RSVD1 0xFF000000
#define BF_PXP_PS_CLRKEYHIGH_RSVD1(v) \
	(((v) << 24) & BM_PXP_PS_CLRKEYHIGH_RSVD1)
#define BP_PXP_PS_CLRKEYHIGH_PIXEL	0
#define BM_PXP_PS_CLRKEYHIGH_PIXEL 0x00FFFFFF
#define BF_PXP_PS_CLRKEYHIGH_PIXEL(v)  \
	(((v) << 0) & BM_PXP_PS_CLRKEYHIGH_PIXEL)

#define HW_PXP_AS_CTRL	(0x00000150)

#define BP_PXP_AS_CTRL_RSVD1	  21
#define BM_PXP_AS_CTRL_RSVD1 0xFFE00000
#define BF_PXP_AS_CTRL_RSVD1(v) \
	(((v) << 21) & BM_PXP_AS_CTRL_RSVD1)
#define BM_PXP_AS_CTRL_ALPHA_INVERT 0x00100000
#define BP_PXP_AS_CTRL_ROP	16
#define BM_PXP_AS_CTRL_ROP 0x000F0000
#define BF_PXP_AS_CTRL_ROP(v)  \
	(((v) << 16) & BM_PXP_AS_CTRL_ROP)
#define BV_PXP_AS_CTRL_ROP__MASKAS     0x0
#define BV_PXP_AS_CTRL_ROP__MASKNOTAS  0x1
#define BV_PXP_AS_CTRL_ROP__MASKASNOT  0x2
#define BV_PXP_AS_CTRL_ROP__MERGEAS    0x3
#define BV_PXP_AS_CTRL_ROP__MERGENOTAS 0x4
#define BV_PXP_AS_CTRL_ROP__MERGEASNOT 0x5
#define BV_PXP_AS_CTRL_ROP__NOTCOPYAS  0x6
#define BV_PXP_AS_CTRL_ROP__NOT        0x7
#define BV_PXP_AS_CTRL_ROP__NOTMASKAS  0x8
#define BV_PXP_AS_CTRL_ROP__NOTMERGEAS 0x9
#define BV_PXP_AS_CTRL_ROP__XORAS      0xA
#define BV_PXP_AS_CTRL_ROP__NOTXORAS   0xB
#define BP_PXP_AS_CTRL_ALPHA	  8
#define BM_PXP_AS_CTRL_ALPHA 0x0000FF00
#define BF_PXP_AS_CTRL_ALPHA(v)  \
	(((v) << 8) & BM_PXP_AS_CTRL_ALPHA)
#define BP_PXP_AS_CTRL_FORMAT	   4
#define BM_PXP_AS_CTRL_FORMAT 0x000000F0
#define BF_PXP_AS_CTRL_FORMAT(v)  \
	(((v) << 4) & BM_PXP_AS_CTRL_FORMAT)
#define BV_PXP_AS_CTRL_FORMAT__ARGB8888 0x0
#define BV_PXP_AS_CTRL_FORMAT__RGB888	0x4
#define BV_PXP_AS_CTRL_FORMAT__ARGB1555 0x8
#define BV_PXP_AS_CTRL_FORMAT__ARGB4444 0x9
#define BV_PXP_AS_CTRL_FORMAT__RGB555	0xC
#define BV_PXP_AS_CTRL_FORMAT__RGB444	0xD
#define BV_PXP_AS_CTRL_FORMAT__RGB565	0xE
#define BM_PXP_AS_CTRL_ENABLE_COLORKEY 0x00000008
#define BP_PXP_AS_CTRL_ALPHA_CTRL      1
#define BM_PXP_AS_CTRL_ALPHA_CTRL 0x00000006
#define BF_PXP_AS_CTRL_ALPHA_CTRL(v)  \
	(((v) << 1) & BM_PXP_AS_CTRL_ALPHA_CTRL)
#define BV_PXP_AS_CTRL_ALPHA_CTRL__Embedded 0x0
#define BV_PXP_AS_CTRL_ALPHA_CTRL__Override 0x1
#define BV_PXP_AS_CTRL_ALPHA_CTRL__Multiply 0x2
#define BV_PXP_AS_CTRL_ALPHA_CTRL__ROPs     0x3
#define BM_PXP_AS_CTRL_RSVD0 0x00000001

#define HW_PXP_AS_BUF	(0x00000160)

#define BP_PXP_AS_BUF_ADDR	0
#define BM_PXP_AS_BUF_ADDR 0xFFFFFFFF
#define BF_PXP_AS_BUF_ADDR(v)	(v)

#define HW_PXP_AS_PITCH	(0x00000170)

#define BP_PXP_AS_PITCH_RSVD	  16
#define BM_PXP_AS_PITCH_RSVD 0xFFFF0000
#define BF_PXP_AS_PITCH_RSVD(v) \
	(((v) << 16) & BM_PXP_AS_PITCH_RSVD)
#define BP_PXP_AS_PITCH_PITCH	   0
#define BM_PXP_AS_PITCH_PITCH 0x0000FFFF
#define BF_PXP_AS_PITCH_PITCH(v)  \
	(((v) << 0) & BM_PXP_AS_PITCH_PITCH)

#define HW_PXP_AS_CLRKEYLOW	(0x00000180)

#define BP_PXP_AS_CLRKEYLOW_RSVD1      24
#define BM_PXP_AS_CLRKEYLOW_RSVD1 0xFF000000
#define BF_PXP_AS_CLRKEYLOW_RSVD1(v) \
	(((v) << 24) & BM_PXP_AS_CLRKEYLOW_RSVD1)
#define BP_PXP_AS_CLRKEYLOW_PIXEL      0
#define BM_PXP_AS_CLRKEYLOW_PIXEL 0x00FFFFFF
#define BF_PXP_AS_CLRKEYLOW_PIXEL(v)  \
	(((v) << 0) & BM_PXP_AS_CLRKEYLOW_PIXEL)

#define HW_PXP_AS_CLRKEYHIGH	(0x00000190)

#define BP_PXP_AS_CLRKEYHIGH_RSVD1	24
#define BM_PXP_AS_CLRKEYHIGH_RSVD1 0xFF000000
#define BF_PXP_AS_CLRKEYHIGH_RSVD1(v) \
	(((v) << 24) & BM_PXP_AS_CLRKEYHIGH_RSVD1)
#define BP_PXP_AS_CLRKEYHIGH_PIXEL	0
#define BM_PXP_AS_CLRKEYHIGH_PIXEL 0x00FFFFFF
#define BF_PXP_AS_CLRKEYHIGH_PIXEL(v)  \
	(((v) << 0) & BM_PXP_AS_CLRKEYHIGH_PIXEL)

#define HW_PXP_CSC1_COEF0	(0x000001a0)

#define BM_PXP_CSC1_COEF0_YCBCR_MODE 0x80000000
#define BM_PXP_CSC1_COEF0_BYPASS 0x40000000
#define BM_PXP_CSC1_COEF0_RSVD1 0x20000000
#define BP_PXP_CSC1_COEF0_C0	  18
#define BM_PXP_CSC1_COEF0_C0 0x1FFC0000
#define BF_PXP_CSC1_COEF0_C0(v)  \
	(((v) << 18) & BM_PXP_CSC1_COEF0_C0)
#define BP_PXP_CSC1_COEF0_UV_OFFSET	 9
#define BM_PXP_CSC1_COEF0_UV_OFFSET 0x0003FE00
#define BF_PXP_CSC1_COEF0_UV_OFFSET(v)	\
	(((v) << 9) & BM_PXP_CSC1_COEF0_UV_OFFSET)
#define BP_PXP_CSC1_COEF0_Y_OFFSET	0
#define BM_PXP_CSC1_COEF0_Y_OFFSET 0x000001FF
#define BF_PXP_CSC1_COEF0_Y_OFFSET(v)  \
	(((v) << 0) & BM_PXP_CSC1_COEF0_Y_OFFSET)

#define HW_PXP_CSC1_COEF1	(0x000001b0)

#define BP_PXP_CSC1_COEF1_RSVD1      27
#define BM_PXP_CSC1_COEF1_RSVD1 0xF8000000
#define BF_PXP_CSC1_COEF1_RSVD1(v) \
	(((v) << 27) & BM_PXP_CSC1_COEF1_RSVD1)
#define BP_PXP_CSC1_COEF1_C1	  16
#define BM_PXP_CSC1_COEF1_C1 0x07FF0000
#define BF_PXP_CSC1_COEF1_C1(v)  \
	(((v) << 16) & BM_PXP_CSC1_COEF1_C1)
#define BP_PXP_CSC1_COEF1_RSVD0      11
#define BM_PXP_CSC1_COEF1_RSVD0 0x0000F800
#define BF_PXP_CSC1_COEF1_RSVD0(v)  \
	(((v) << 11) & BM_PXP_CSC1_COEF1_RSVD0)
#define BP_PXP_CSC1_COEF1_C4	  0
#define BM_PXP_CSC1_COEF1_C4 0x000007FF
#define BF_PXP_CSC1_COEF1_C4(v)  \
	(((v) << 0) & BM_PXP_CSC1_COEF1_C4)

#define HW_PXP_CSC1_COEF2	(0x000001c0)

#define BP_PXP_CSC1_COEF2_RSVD1      27
#define BM_PXP_CSC1_COEF2_RSVD1 0xF8000000
#define BF_PXP_CSC1_COEF2_RSVD1(v) \
	(((v) << 27) & BM_PXP_CSC1_COEF2_RSVD1)
#define BP_PXP_CSC1_COEF2_C2	  16
#define BM_PXP_CSC1_COEF2_C2 0x07FF0000
#define BF_PXP_CSC1_COEF2_C2(v)  \
	(((v) << 16) & BM_PXP_CSC1_COEF2_C2)
#define BP_PXP_CSC1_COEF2_RSVD0      11
#define BM_PXP_CSC1_COEF2_RSVD0 0x0000F800
#define BF_PXP_CSC1_COEF2_RSVD0(v)  \
	(((v) << 11) & BM_PXP_CSC1_COEF2_RSVD0)
#define BP_PXP_CSC1_COEF2_C3	  0
#define BM_PXP_CSC1_COEF2_C3 0x000007FF
#define BF_PXP_CSC1_COEF2_C3(v)  \
	(((v) << 0) & BM_PXP_CSC1_COEF2_C3)

#define HW_PXP_CSC2_CTRL	(0x000001d0)

#define BP_PXP_CSC2_CTRL_RSVD	   3
#define BM_PXP_CSC2_CTRL_RSVD 0xFFFFFFF8
#define BF_PXP_CSC2_CTRL_RSVD(v) \
	(((v) << 3) & BM_PXP_CSC2_CTRL_RSVD)
#define BP_PXP_CSC2_CTRL_CSC_MODE      1
#define BM_PXP_CSC2_CTRL_CSC_MODE 0x00000006
#define BF_PXP_CSC2_CTRL_CSC_MODE(v)  \
	(((v) << 1) & BM_PXP_CSC2_CTRL_CSC_MODE)
#define BV_PXP_CSC2_CTRL_CSC_MODE__YUV2RGB   0x0
#define BV_PXP_CSC2_CTRL_CSC_MODE__YCbCr2RGB 0x1
#define BV_PXP_CSC2_CTRL_CSC_MODE__RGB2YUV   0x2
#define BV_PXP_CSC2_CTRL_CSC_MODE__RGB2YCbCr 0x3
#define BM_PXP_CSC2_CTRL_BYPASS 0x00000001

#define HW_PXP_CSC2_COEF0	(0x000001e0)

#define BP_PXP_CSC2_COEF0_RSVD1      27
#define BM_PXP_CSC2_COEF0_RSVD1 0xF8000000
#define BF_PXP_CSC2_COEF0_RSVD1(v) \
	(((v) << 27) & BM_PXP_CSC2_COEF0_RSVD1)
#define BP_PXP_CSC2_COEF0_A2	  16
#define BM_PXP_CSC2_COEF0_A2 0x07FF0000
#define BF_PXP_CSC2_COEF0_A2(v)  \
	(((v) << 16) & BM_PXP_CSC2_COEF0_A2)
#define BP_PXP_CSC2_COEF0_RSVD0      11
#define BM_PXP_CSC2_COEF0_RSVD0 0x0000F800
#define BF_PXP_CSC2_COEF0_RSVD0(v)  \
	(((v) << 11) & BM_PXP_CSC2_COEF0_RSVD0)
#define BP_PXP_CSC2_COEF0_A1	  0
#define BM_PXP_CSC2_COEF0_A1 0x000007FF
#define BF_PXP_CSC2_COEF0_A1(v)  \
	(((v) << 0) & BM_PXP_CSC2_COEF0_A1)

#define HW_PXP_CSC2_COEF1	(0x000001f0)

#define BP_PXP_CSC2_COEF1_RSVD1      27
#define BM_PXP_CSC2_COEF1_RSVD1 0xF8000000
#define BF_PXP_CSC2_COEF1_RSVD1(v) \
	(((v) << 27) & BM_PXP_CSC2_COEF1_RSVD1)
#define BP_PXP_CSC2_COEF1_B1	  16
#define BM_PXP_CSC2_COEF1_B1 0x07FF0000
#define BF_PXP_CSC2_COEF1_B1(v)  \
	(((v) << 16) & BM_PXP_CSC2_COEF1_B1)
#define BP_PXP_CSC2_COEF1_RSVD0      11
#define BM_PXP_CSC2_COEF1_RSVD0 0x0000F800
#define BF_PXP_CSC2_COEF1_RSVD0(v)  \
	(((v) << 11) & BM_PXP_CSC2_COEF1_RSVD0)
#define BP_PXP_CSC2_COEF1_A3	  0
#define BM_PXP_CSC2_COEF1_A3 0x000007FF
#define BF_PXP_CSC2_COEF1_A3(v)  \
	(((v) << 0) & BM_PXP_CSC2_COEF1_A3)

#define HW_PXP_CSC2_COEF2	(0x00000200)

#define BP_PXP_CSC2_COEF2_RSVD1      27
#define BM_PXP_CSC2_COEF2_RSVD1 0xF8000000
#define BF_PXP_CSC2_COEF2_RSVD1(v) \
	(((v) << 27) & BM_PXP_CSC2_COEF2_RSVD1)
#define BP_PXP_CSC2_COEF2_B3	  16
#define BM_PXP_CSC2_COEF2_B3 0x07FF0000
#define BF_PXP_CSC2_COEF2_B3(v)  \
	(((v) << 16) & BM_PXP_CSC2_COEF2_B3)
#define BP_PXP_CSC2_COEF2_RSVD0      11
#define BM_PXP_CSC2_COEF2_RSVD0 0x0000F800
#define BF_PXP_CSC2_COEF2_RSVD0(v)  \
	(((v) << 11) & BM_PXP_CSC2_COEF2_RSVD0)
#define BP_PXP_CSC2_COEF2_B2	  0
#define BM_PXP_CSC2_COEF2_B2 0x000007FF
#define BF_PXP_CSC2_COEF2_B2(v)  \
	(((v) << 0) & BM_PXP_CSC2_COEF2_B2)

#define HW_PXP_CSC2_COEF3	(0x00000210)

#define BP_PXP_CSC2_COEF3_RSVD1      27
#define BM_PXP_CSC2_COEF3_RSVD1 0xF8000000
#define BF_PXP_CSC2_COEF3_RSVD1(v) \
	(((v) << 27) & BM_PXP_CSC2_COEF3_RSVD1)
#define BP_PXP_CSC2_COEF3_C2	  16
#define BM_PXP_CSC2_COEF3_C2 0x07FF0000
#define BF_PXP_CSC2_COEF3_C2(v)  \
	(((v) << 16) & BM_PXP_CSC2_COEF3_C2)
#define BP_PXP_CSC2_COEF3_RSVD0      11
#define BM_PXP_CSC2_COEF3_RSVD0 0x0000F800
#define BF_PXP_CSC2_COEF3_RSVD0(v)  \
	(((v) << 11) & BM_PXP_CSC2_COEF3_RSVD0)
#define BP_PXP_CSC2_COEF3_C1	  0
#define BM_PXP_CSC2_COEF3_C1 0x000007FF
#define BF_PXP_CSC2_COEF3_C1(v)  \
	(((v) << 0) & BM_PXP_CSC2_COEF3_C1)

#define HW_PXP_CSC2_COEF4	(0x00000220)

#define BP_PXP_CSC2_COEF4_RSVD1      25
#define BM_PXP_CSC2_COEF4_RSVD1 0xFE000000
#define BF_PXP_CSC2_COEF4_RSVD1(v) \
	(((v) << 25) & BM_PXP_CSC2_COEF4_RSVD1)
#define BP_PXP_CSC2_COEF4_D1	  16
#define BM_PXP_CSC2_COEF4_D1 0x01FF0000
#define BF_PXP_CSC2_COEF4_D1(v)  \
	(((v) << 16) & BM_PXP_CSC2_COEF4_D1)
#define BP_PXP_CSC2_COEF4_RSVD0      11
#define BM_PXP_CSC2_COEF4_RSVD0 0x0000F800
#define BF_PXP_CSC2_COEF4_RSVD0(v)  \
	(((v) << 11) & BM_PXP_CSC2_COEF4_RSVD0)
#define BP_PXP_CSC2_COEF4_C3	  0
#define BM_PXP_CSC2_COEF4_C3 0x000007FF
#define BF_PXP_CSC2_COEF4_C3(v)  \
	(((v) << 0) & BM_PXP_CSC2_COEF4_C3)

#define HW_PXP_CSC2_COEF5	(0x00000230)

#define BP_PXP_CSC2_COEF5_RSVD1      25
#define BM_PXP_CSC2_COEF5_RSVD1 0xFE000000
#define BF_PXP_CSC2_COEF5_RSVD1(v) \
	(((v) << 25) & BM_PXP_CSC2_COEF5_RSVD1)
#define BP_PXP_CSC2_COEF5_D3	  16
#define BM_PXP_CSC2_COEF5_D3 0x01FF0000
#define BF_PXP_CSC2_COEF5_D3(v)  \
	(((v) << 16) & BM_PXP_CSC2_COEF5_D3)
#define BP_PXP_CSC2_COEF5_RSVD0      9
#define BM_PXP_CSC2_COEF5_RSVD0 0x0000FE00
#define BF_PXP_CSC2_COEF5_RSVD0(v)  \
	(((v) << 9) & BM_PXP_CSC2_COEF5_RSVD0)
#define BP_PXP_CSC2_COEF5_D2	  0
#define BM_PXP_CSC2_COEF5_D2 0x000001FF
#define BF_PXP_CSC2_COEF5_D2(v)  \
	(((v) << 0) & BM_PXP_CSC2_COEF5_D2)

#define HW_PXP_LUT_CTRL	(0x00000240)

#define BM_PXP_LUT_CTRL_BYPASS 0x80000000
#define BP_PXP_LUT_CTRL_RSVD3	   26
#define BM_PXP_LUT_CTRL_RSVD3 0x7C000000
#define BF_PXP_LUT_CTRL_RSVD3(v)  \
	(((v) << 26) & BM_PXP_LUT_CTRL_RSVD3)
#define BP_PXP_LUT_CTRL_LOOKUP_MODE	 24
#define BM_PXP_LUT_CTRL_LOOKUP_MODE 0x03000000
#define BF_PXP_LUT_CTRL_LOOKUP_MODE(v)	\
	(((v) << 24) & BM_PXP_LUT_CTRL_LOOKUP_MODE)
#define BV_PXP_LUT_CTRL_LOOKUP_MODE__CACHE_RGB565  0x0
#define BV_PXP_LUT_CTRL_LOOKUP_MODE__DIRECT_Y8	   0x1
#define BV_PXP_LUT_CTRL_LOOKUP_MODE__DIRECT_RGB444 0x2
#define BV_PXP_LUT_CTRL_LOOKUP_MODE__DIRECT_RGB454 0x3
#define BP_PXP_LUT_CTRL_RSVD2	   18
#define BM_PXP_LUT_CTRL_RSVD2 0x00FC0000
#define BF_PXP_LUT_CTRL_RSVD2(v)  \
	(((v) << 18) & BM_PXP_LUT_CTRL_RSVD2)
#define BP_PXP_LUT_CTRL_OUT_MODE      16
#define BM_PXP_LUT_CTRL_OUT_MODE 0x00030000
#define BF_PXP_LUT_CTRL_OUT_MODE(v)  \
	(((v) << 16) & BM_PXP_LUT_CTRL_OUT_MODE)
#define BV_PXP_LUT_CTRL_OUT_MODE__RESERVED    0x0
#define BV_PXP_LUT_CTRL_OUT_MODE__Y8	      0x1
#define BV_PXP_LUT_CTRL_OUT_MODE__RGBW4444CFA 0x2
#define BV_PXP_LUT_CTRL_OUT_MODE__RGB888      0x3
#define BP_PXP_LUT_CTRL_RSVD1	   11
#define BM_PXP_LUT_CTRL_RSVD1 0x0000F800
#define BF_PXP_LUT_CTRL_RSVD1(v)  \
	(((v) << 11) & BM_PXP_LUT_CTRL_RSVD1)
#define BM_PXP_LUT_CTRL_SEL_8KB 0x00000400
#define BM_PXP_LUT_CTRL_LRU_UPD 0x00000200
#define BM_PXP_LUT_CTRL_INVALID 0x00000100
#define BP_PXP_LUT_CTRL_RSVD0	   1
#define BM_PXP_LUT_CTRL_RSVD0 0x000000FE
#define BF_PXP_LUT_CTRL_RSVD0(v)  \
	(((v) << 1) & BM_PXP_LUT_CTRL_RSVD0)
#define BM_PXP_LUT_CTRL_DMA_START 0x00000001

#define HW_PXP_LUT_ADDR	(0x00000250)

#define BM_PXP_LUT_ADDR_RSVD2 0x80000000
#define BP_PXP_LUT_ADDR_NUM_BYTES      16
#define BM_PXP_LUT_ADDR_NUM_BYTES 0x7FFF0000
#define BF_PXP_LUT_ADDR_NUM_BYTES(v)  \
	(((v) << 16) & BM_PXP_LUT_ADDR_NUM_BYTES)
#define BP_PXP_LUT_ADDR_RSVD1	   14
#define BM_PXP_LUT_ADDR_RSVD1 0x0000C000
#define BF_PXP_LUT_ADDR_RSVD1(v)  \
	(((v) << 14) & BM_PXP_LUT_ADDR_RSVD1)
#define BP_PXP_LUT_ADDR_ADDR	  0
#define BM_PXP_LUT_ADDR_ADDR 0x00003FFF
#define BF_PXP_LUT_ADDR_ADDR(v)  \
	(((v) << 0) & BM_PXP_LUT_ADDR_ADDR)

#define HW_PXP_LUT_DATA	(0x00000260)

#define BP_PXP_LUT_DATA_DATA	  0
#define BM_PXP_LUT_DATA_DATA 0xFFFFFFFF
#define BF_PXP_LUT_DATA_DATA(v)   (v)

#define HW_PXP_LUT_EXTMEM	(0x00000270)

#define BP_PXP_LUT_EXTMEM_ADDR	    0
#define BM_PXP_LUT_EXTMEM_ADDR 0xFFFFFFFF
#define BF_PXP_LUT_EXTMEM_ADDR(v)   (v)

#define HW_PXP_CFA	(0x00000280)

#define BP_PXP_CFA_DATA      0
#define BM_PXP_CFA_DATA 0xFFFFFFFF
#define BF_PXP_CFA_DATA(v)   (v)

#define HW_PXP_HIST_CTRL	(0x00000290)

#define BP_PXP_HIST_CTRL_RSVD	   6
#define BM_PXP_HIST_CTRL_RSVD 0xFFFFFFC0
#define BF_PXP_HIST_CTRL_RSVD(v) \
	(((v) << 6) & BM_PXP_HIST_CTRL_RSVD)
#define BP_PXP_HIST_CTRL_PANEL_MODE	 4
#define BM_PXP_HIST_CTRL_PANEL_MODE 0x00000030
#define BF_PXP_HIST_CTRL_PANEL_MODE(v)	\
	(((v) << 4) & BM_PXP_HIST_CTRL_PANEL_MODE)
#define BV_PXP_HIST_CTRL_PANEL_MODE__GRAY4  0x0
#define BV_PXP_HIST_CTRL_PANEL_MODE__GRAY8  0x1
#define BV_PXP_HIST_CTRL_PANEL_MODE__GRAY16 0x2
#define BV_PXP_HIST_CTRL_PANEL_MODE__GRAY32 0x3
#define BP_PXP_HIST_CTRL_STATUS      0
#define BM_PXP_HIST_CTRL_STATUS 0x0000000F
#define BF_PXP_HIST_CTRL_STATUS(v)  \
	(((v) << 0) & BM_PXP_HIST_CTRL_STATUS)

#define HW_PXP_HIST2_PARAM	(0x000002a0)

#define BP_PXP_HIST2_PARAM_RSVD      16
#define BM_PXP_HIST2_PARAM_RSVD 0xFFFF0000
#define BF_PXP_HIST2_PARAM_RSVD(v) \
	(((v) << 16) & BM_PXP_HIST2_PARAM_RSVD)
#define BP_PXP_HIST2_PARAM_RSVD1      13
#define BM_PXP_HIST2_PARAM_RSVD1 0x0000E000
#define BF_PXP_HIST2_PARAM_RSVD1(v)  \
	(((v) << 13) & BM_PXP_HIST2_PARAM_RSVD1)
#define BP_PXP_HIST2_PARAM_VALUE1      8
#define BM_PXP_HIST2_PARAM_VALUE1 0x00001F00
#define BF_PXP_HIST2_PARAM_VALUE1(v)  \
	(((v) << 8) & BM_PXP_HIST2_PARAM_VALUE1)
#define BP_PXP_HIST2_PARAM_RSVD0      5
#define BM_PXP_HIST2_PARAM_RSVD0 0x000000E0
#define BF_PXP_HIST2_PARAM_RSVD0(v)  \
	(((v) << 5) & BM_PXP_HIST2_PARAM_RSVD0)
#define BP_PXP_HIST2_PARAM_VALUE0      0
#define BM_PXP_HIST2_PARAM_VALUE0 0x0000001F
#define BF_PXP_HIST2_PARAM_VALUE0(v)  \
	(((v) << 0) & BM_PXP_HIST2_PARAM_VALUE0)

#define HW_PXP_HIST4_PARAM	(0x000002b0)

#define BP_PXP_HIST4_PARAM_RSVD3      29
#define BM_PXP_HIST4_PARAM_RSVD3 0xE0000000
#define BF_PXP_HIST4_PARAM_RSVD3(v) \
	(((v) << 29) & BM_PXP_HIST4_PARAM_RSVD3)
#define BP_PXP_HIST4_PARAM_VALUE3      24
#define BM_PXP_HIST4_PARAM_VALUE3 0x1F000000
#define BF_PXP_HIST4_PARAM_VALUE3(v)  \
	(((v) << 24) & BM_PXP_HIST4_PARAM_VALUE3)
#define BP_PXP_HIST4_PARAM_RSVD2      21
#define BM_PXP_HIST4_PARAM_RSVD2 0x00E00000
#define BF_PXP_HIST4_PARAM_RSVD2(v)  \
	(((v) << 21) & BM_PXP_HIST4_PARAM_RSVD2)
#define BP_PXP_HIST4_PARAM_VALUE2      16
#define BM_PXP_HIST4_PARAM_VALUE2 0x001F0000
#define BF_PXP_HIST4_PARAM_VALUE2(v)  \
	(((v) << 16) & BM_PXP_HIST4_PARAM_VALUE2)
#define BP_PXP_HIST4_PARAM_RSVD1      13
#define BM_PXP_HIST4_PARAM_RSVD1 0x0000E000
#define BF_PXP_HIST4_PARAM_RSVD1(v)  \
	(((v) << 13) & BM_PXP_HIST4_PARAM_RSVD1)
#define BP_PXP_HIST4_PARAM_VALUE1      8
#define BM_PXP_HIST4_PARAM_VALUE1 0x00001F00
#define BF_PXP_HIST4_PARAM_VALUE1(v)  \
	(((v) << 8) & BM_PXP_HIST4_PARAM_VALUE1)
#define BP_PXP_HIST4_PARAM_RSVD0      5
#define BM_PXP_HIST4_PARAM_RSVD0 0x000000E0
#define BF_PXP_HIST4_PARAM_RSVD0(v)  \
	(((v) << 5) & BM_PXP_HIST4_PARAM_RSVD0)
#define BP_PXP_HIST4_PARAM_VALUE0      0
#define BM_PXP_HIST4_PARAM_VALUE0 0x0000001F
#define BF_PXP_HIST4_PARAM_VALUE0(v)  \
	(((v) << 0) & BM_PXP_HIST4_PARAM_VALUE0)

#define HW_PXP_HIST8_PARAM0	(0x000002c0)

#define BP_PXP_HIST8_PARAM0_RSVD3      29
#define BM_PXP_HIST8_PARAM0_RSVD3 0xE0000000
#define BF_PXP_HIST8_PARAM0_RSVD3(v) \
	(((v) << 29) & BM_PXP_HIST8_PARAM0_RSVD3)
#define BP_PXP_HIST8_PARAM0_VALUE3	24
#define BM_PXP_HIST8_PARAM0_VALUE3 0x1F000000
#define BF_PXP_HIST8_PARAM0_VALUE3(v)  \
	(((v) << 24) & BM_PXP_HIST8_PARAM0_VALUE3)
#define BP_PXP_HIST8_PARAM0_RSVD2      21
#define BM_PXP_HIST8_PARAM0_RSVD2 0x00E00000
#define BF_PXP_HIST8_PARAM0_RSVD2(v)  \
	(((v) << 21) & BM_PXP_HIST8_PARAM0_RSVD2)
#define BP_PXP_HIST8_PARAM0_VALUE2	16
#define BM_PXP_HIST8_PARAM0_VALUE2 0x001F0000
#define BF_PXP_HIST8_PARAM0_VALUE2(v)  \
	(((v) << 16) & BM_PXP_HIST8_PARAM0_VALUE2)
#define BP_PXP_HIST8_PARAM0_RSVD1      13
#define BM_PXP_HIST8_PARAM0_RSVD1 0x0000E000
#define BF_PXP_HIST8_PARAM0_RSVD1(v)  \
	(((v) << 13) & BM_PXP_HIST8_PARAM0_RSVD1)
#define BP_PXP_HIST8_PARAM0_VALUE1	8
#define BM_PXP_HIST8_PARAM0_VALUE1 0x00001F00
#define BF_PXP_HIST8_PARAM0_VALUE1(v)  \
	(((v) << 8) & BM_PXP_HIST8_PARAM0_VALUE1)
#define BP_PXP_HIST8_PARAM0_RSVD0      5
#define BM_PXP_HIST8_PARAM0_RSVD0 0x000000E0
#define BF_PXP_HIST8_PARAM0_RSVD0(v)  \
	(((v) << 5) & BM_PXP_HIST8_PARAM0_RSVD0)
#define BP_PXP_HIST8_PARAM0_VALUE0	0
#define BM_PXP_HIST8_PARAM0_VALUE0 0x0000001F
#define BF_PXP_HIST8_PARAM0_VALUE0(v)  \
	(((v) << 0) & BM_PXP_HIST8_PARAM0_VALUE0)

#define HW_PXP_HIST8_PARAM1	(0x000002d0)

#define BP_PXP_HIST8_PARAM1_RSVD7      29
#define BM_PXP_HIST8_PARAM1_RSVD7 0xE0000000
#define BF_PXP_HIST8_PARAM1_RSVD7(v) \
	(((v) << 29) & BM_PXP_HIST8_PARAM1_RSVD7)
#define BP_PXP_HIST8_PARAM1_VALUE7	24
#define BM_PXP_HIST8_PARAM1_VALUE7 0x1F000000
#define BF_PXP_HIST8_PARAM1_VALUE7(v)  \
	(((v) << 24) & BM_PXP_HIST8_PARAM1_VALUE7)
#define BP_PXP_HIST8_PARAM1_RSVD6      21
#define BM_PXP_HIST8_PARAM1_RSVD6 0x00E00000
#define BF_PXP_HIST8_PARAM1_RSVD6(v)  \
	(((v) << 21) & BM_PXP_HIST8_PARAM1_RSVD6)
#define BP_PXP_HIST8_PARAM1_VALUE6	16
#define BM_PXP_HIST8_PARAM1_VALUE6 0x001F0000
#define BF_PXP_HIST8_PARAM1_VALUE6(v)  \
	(((v) << 16) & BM_PXP_HIST8_PARAM1_VALUE6)
#define BP_PXP_HIST8_PARAM1_RSVD5      13
#define BM_PXP_HIST8_PARAM1_RSVD5 0x0000E000
#define BF_PXP_HIST8_PARAM1_RSVD5(v)  \
	(((v) << 13) & BM_PXP_HIST8_PARAM1_RSVD5)
#define BP_PXP_HIST8_PARAM1_VALUE5	8
#define BM_PXP_HIST8_PARAM1_VALUE5 0x00001F00
#define BF_PXP_HIST8_PARAM1_VALUE5(v)  \
	(((v) << 8) & BM_PXP_HIST8_PARAM1_VALUE5)
#define BP_PXP_HIST8_PARAM1_RSVD4      5
#define BM_PXP_HIST8_PARAM1_RSVD4 0x000000E0
#define BF_PXP_HIST8_PARAM1_RSVD4(v)  \
	(((v) << 5) & BM_PXP_HIST8_PARAM1_RSVD4)
#define BP_PXP_HIST8_PARAM1_VALUE4	0
#define BM_PXP_HIST8_PARAM1_VALUE4 0x0000001F
#define BF_PXP_HIST8_PARAM1_VALUE4(v)  \
	(((v) << 0) & BM_PXP_HIST8_PARAM1_VALUE4)

#define HW_PXP_HIST16_PARAM0	(0x000002e0)

#define BP_PXP_HIST16_PARAM0_RSVD3	29
#define BM_PXP_HIST16_PARAM0_RSVD3 0xE0000000
#define BF_PXP_HIST16_PARAM0_RSVD3(v) \
	(((v) << 29) & BM_PXP_HIST16_PARAM0_RSVD3)
#define BP_PXP_HIST16_PARAM0_VALUE3	 24
#define BM_PXP_HIST16_PARAM0_VALUE3 0x1F000000
#define BF_PXP_HIST16_PARAM0_VALUE3(v)	\
	(((v) << 24) & BM_PXP_HIST16_PARAM0_VALUE3)
#define BP_PXP_HIST16_PARAM0_RSVD2	21
#define BM_PXP_HIST16_PARAM0_RSVD2 0x00E00000
#define BF_PXP_HIST16_PARAM0_RSVD2(v)  \
	(((v) << 21) & BM_PXP_HIST16_PARAM0_RSVD2)
#define BP_PXP_HIST16_PARAM0_VALUE2	 16
#define BM_PXP_HIST16_PARAM0_VALUE2 0x001F0000
#define BF_PXP_HIST16_PARAM0_VALUE2(v)	\
	(((v) << 16) & BM_PXP_HIST16_PARAM0_VALUE2)
#define BP_PXP_HIST16_PARAM0_RSVD1	13
#define BM_PXP_HIST16_PARAM0_RSVD1 0x0000E000
#define BF_PXP_HIST16_PARAM0_RSVD1(v)  \
	(((v) << 13) & BM_PXP_HIST16_PARAM0_RSVD1)
#define BP_PXP_HIST16_PARAM0_VALUE1	 8
#define BM_PXP_HIST16_PARAM0_VALUE1 0x00001F00
#define BF_PXP_HIST16_PARAM0_VALUE1(v)	\
	(((v) << 8) & BM_PXP_HIST16_PARAM0_VALUE1)
#define BP_PXP_HIST16_PARAM0_RSVD0	5
#define BM_PXP_HIST16_PARAM0_RSVD0 0x000000E0
#define BF_PXP_HIST16_PARAM0_RSVD0(v)  \
	(((v) << 5) & BM_PXP_HIST16_PARAM0_RSVD0)
#define BP_PXP_HIST16_PARAM0_VALUE0	 0
#define BM_PXP_HIST16_PARAM0_VALUE0 0x0000001F
#define BF_PXP_HIST16_PARAM0_VALUE0(v)	\
	(((v) << 0) & BM_PXP_HIST16_PARAM0_VALUE0)

#define HW_PXP_HIST16_PARAM1	(0x000002f0)

#define BP_PXP_HIST16_PARAM1_RSVD7	29
#define BM_PXP_HIST16_PARAM1_RSVD7 0xE0000000
#define BF_PXP_HIST16_PARAM1_RSVD7(v) \
	(((v) << 29) & BM_PXP_HIST16_PARAM1_RSVD7)
#define BP_PXP_HIST16_PARAM1_VALUE7	 24
#define BM_PXP_HIST16_PARAM1_VALUE7 0x1F000000
#define BF_PXP_HIST16_PARAM1_VALUE7(v)	\
	(((v) << 24) & BM_PXP_HIST16_PARAM1_VALUE7)
#define BP_PXP_HIST16_PARAM1_RSVD6	21
#define BM_PXP_HIST16_PARAM1_RSVD6 0x00E00000
#define BF_PXP_HIST16_PARAM1_RSVD6(v)  \
	(((v) << 21) & BM_PXP_HIST16_PARAM1_RSVD6)
#define BP_PXP_HIST16_PARAM1_VALUE6	 16
#define BM_PXP_HIST16_PARAM1_VALUE6 0x001F0000
#define BF_PXP_HIST16_PARAM1_VALUE6(v)	\
	(((v) << 16) & BM_PXP_HIST16_PARAM1_VALUE6)
#define BP_PXP_HIST16_PARAM1_RSVD5	13
#define BM_PXP_HIST16_PARAM1_RSVD5 0x0000E000
#define BF_PXP_HIST16_PARAM1_RSVD5(v)  \
	(((v) << 13) & BM_PXP_HIST16_PARAM1_RSVD5)
#define BP_PXP_HIST16_PARAM1_VALUE5	 8
#define BM_PXP_HIST16_PARAM1_VALUE5 0x00001F00
#define BF_PXP_HIST16_PARAM1_VALUE5(v)	\
	(((v) << 8) & BM_PXP_HIST16_PARAM1_VALUE5)
#define BP_PXP_HIST16_PARAM1_RSVD4	5
#define BM_PXP_HIST16_PARAM1_RSVD4 0x000000E0
#define BF_PXP_HIST16_PARAM1_RSVD4(v)  \
	(((v) << 5) & BM_PXP_HIST16_PARAM1_RSVD4)
#define BP_PXP_HIST16_PARAM1_VALUE4	 0
#define BM_PXP_HIST16_PARAM1_VALUE4 0x0000001F
#define BF_PXP_HIST16_PARAM1_VALUE4(v)	\
	(((v) << 0) & BM_PXP_HIST16_PARAM1_VALUE4)

#define HW_PXP_HIST16_PARAM2	(0x00000300)

#define BP_PXP_HIST16_PARAM2_RSVD11	 29
#define BM_PXP_HIST16_PARAM2_RSVD11 0xE0000000
#define BF_PXP_HIST16_PARAM2_RSVD11(v) \
	(((v) << 29) & BM_PXP_HIST16_PARAM2_RSVD11)
#define BP_PXP_HIST16_PARAM2_VALUE11	  24
#define BM_PXP_HIST16_PARAM2_VALUE11 0x1F000000
#define BF_PXP_HIST16_PARAM2_VALUE11(v)  \
	(((v) << 24) & BM_PXP_HIST16_PARAM2_VALUE11)
#define BP_PXP_HIST16_PARAM2_RSVD10	 21
#define BM_PXP_HIST16_PARAM2_RSVD10 0x00E00000
#define BF_PXP_HIST16_PARAM2_RSVD10(v)	\
	(((v) << 21) & BM_PXP_HIST16_PARAM2_RSVD10)
#define BP_PXP_HIST16_PARAM2_VALUE10	  16
#define BM_PXP_HIST16_PARAM2_VALUE10 0x001F0000
#define BF_PXP_HIST16_PARAM2_VALUE10(v)  \
	(((v) << 16) & BM_PXP_HIST16_PARAM2_VALUE10)
#define BP_PXP_HIST16_PARAM2_RSVD9	13
#define BM_PXP_HIST16_PARAM2_RSVD9 0x0000E000
#define BF_PXP_HIST16_PARAM2_RSVD9(v)  \
	(((v) << 13) & BM_PXP_HIST16_PARAM2_RSVD9)
#define BP_PXP_HIST16_PARAM2_VALUE9	 8
#define BM_PXP_HIST16_PARAM2_VALUE9 0x00001F00
#define BF_PXP_HIST16_PARAM2_VALUE9(v)	\
	(((v) << 8) & BM_PXP_HIST16_PARAM2_VALUE9)
#define BP_PXP_HIST16_PARAM2_RSVD8	5
#define BM_PXP_HIST16_PARAM2_RSVD8 0x000000E0
#define BF_PXP_HIST16_PARAM2_RSVD8(v)  \
	(((v) << 5) & BM_PXP_HIST16_PARAM2_RSVD8)
#define BP_PXP_HIST16_PARAM2_VALUE8	 0
#define BM_PXP_HIST16_PARAM2_VALUE8 0x0000001F
#define BF_PXP_HIST16_PARAM2_VALUE8(v)	\
	(((v) << 0) & BM_PXP_HIST16_PARAM2_VALUE8)

#define HW_PXP_HIST16_PARAM3	(0x00000310)

#define BP_PXP_HIST16_PARAM3_RSVD15	 29
#define BM_PXP_HIST16_PARAM3_RSVD15 0xE0000000
#define BF_PXP_HIST16_PARAM3_RSVD15(v) \
	(((v) << 29) & BM_PXP_HIST16_PARAM3_RSVD15)
#define BP_PXP_HIST16_PARAM3_VALUE15	  24
#define BM_PXP_HIST16_PARAM3_VALUE15 0x1F000000
#define BF_PXP_HIST16_PARAM3_VALUE15(v)  \
	(((v) << 24) & BM_PXP_HIST16_PARAM3_VALUE15)
#define BP_PXP_HIST16_PARAM3_RSVD14	 21
#define BM_PXP_HIST16_PARAM3_RSVD14 0x00E00000
#define BF_PXP_HIST16_PARAM3_RSVD14(v)	\
	(((v) << 21) & BM_PXP_HIST16_PARAM3_RSVD14)
#define BP_PXP_HIST16_PARAM3_VALUE14	  16
#define BM_PXP_HIST16_PARAM3_VALUE14 0x001F0000
#define BF_PXP_HIST16_PARAM3_VALUE14(v)  \
	(((v) << 16) & BM_PXP_HIST16_PARAM3_VALUE14)
#define BP_PXP_HIST16_PARAM3_RSVD13	 13
#define BM_PXP_HIST16_PARAM3_RSVD13 0x0000E000
#define BF_PXP_HIST16_PARAM3_RSVD13(v)	\
	(((v) << 13) & BM_PXP_HIST16_PARAM3_RSVD13)
#define BP_PXP_HIST16_PARAM3_VALUE13	  8
#define BM_PXP_HIST16_PARAM3_VALUE13 0x00001F00
#define BF_PXP_HIST16_PARAM3_VALUE13(v)  \
	(((v) << 8) & BM_PXP_HIST16_PARAM3_VALUE13)
#define BP_PXP_HIST16_PARAM3_RSVD12	 5
#define BM_PXP_HIST16_PARAM3_RSVD12 0x000000E0
#define BF_PXP_HIST16_PARAM3_RSVD12(v)	\
	(((v) << 5) & BM_PXP_HIST16_PARAM3_RSVD12)
#define BP_PXP_HIST16_PARAM3_VALUE12	  0
#define BM_PXP_HIST16_PARAM3_VALUE12 0x0000001F
#define BF_PXP_HIST16_PARAM3_VALUE12(v)  \
	(((v) << 0) & BM_PXP_HIST16_PARAM3_VALUE12)

#define HW_PXP_POWER	(0x00000320)

#define BP_PXP_POWER_CTRL      12
#define BM_PXP_POWER_CTRL 0xFFFFF000
#define BF_PXP_POWER_CTRL(v) \
	(((v) << 12) & BM_PXP_POWER_CTRL)
#define BP_PXP_POWER_ROT_MEM_LP_STATE	   9
#define BM_PXP_POWER_ROT_MEM_LP_STATE 0x00000E00
#define BF_PXP_POWER_ROT_MEM_LP_STATE(v)  \
	(((v) << 9) & BM_PXP_POWER_ROT_MEM_LP_STATE)
#define BV_PXP_POWER_ROT_MEM_LP_STATE__NONE 0x0
#define BV_PXP_POWER_ROT_MEM_LP_STATE__LS   0x1
#define BV_PXP_POWER_ROT_MEM_LP_STATE__DS   0x2
#define BV_PXP_POWER_ROT_MEM_LP_STATE__SD   0x4
#define BP_PXP_POWER_LUT_LP_STATE_WAY1_BANKN	  6
#define BM_PXP_POWER_LUT_LP_STATE_WAY1_BANKN 0x000001C0
#define BF_PXP_POWER_LUT_LP_STATE_WAY1_BANKN(v)  \
	(((v) << 6) & BM_PXP_POWER_LUT_LP_STATE_WAY1_BANKN)
#define BV_PXP_POWER_LUT_LP_STATE_WAY1_BANKN__NONE 0x0
#define BV_PXP_POWER_LUT_LP_STATE_WAY1_BANKN__LS   0x1
#define BV_PXP_POWER_LUT_LP_STATE_WAY1_BANKN__DS   0x2
#define BV_PXP_POWER_LUT_LP_STATE_WAY1_BANKN__SD   0x4
#define BP_PXP_POWER_LUT_LP_STATE_WAY0_BANKN	  3
#define BM_PXP_POWER_LUT_LP_STATE_WAY0_BANKN 0x00000038
#define BF_PXP_POWER_LUT_LP_STATE_WAY0_BANKN(v)  \
	(((v) << 3) & BM_PXP_POWER_LUT_LP_STATE_WAY0_BANKN)
#define BV_PXP_POWER_LUT_LP_STATE_WAY0_BANKN__NONE 0x0
#define BV_PXP_POWER_LUT_LP_STATE_WAY0_BANKN__LS   0x1
#define BV_PXP_POWER_LUT_LP_STATE_WAY0_BANKN__DS   0x2
#define BV_PXP_POWER_LUT_LP_STATE_WAY0_BANKN__SD   0x4
#define BP_PXP_POWER_LUT_LP_STATE_WAY0_BANK0	  0
#define BM_PXP_POWER_LUT_LP_STATE_WAY0_BANK0 0x00000007
#define BF_PXP_POWER_LUT_LP_STATE_WAY0_BANK0(v)  \
	(((v) << 0) & BM_PXP_POWER_LUT_LP_STATE_WAY0_BANK0)
#define BV_PXP_POWER_LUT_LP_STATE_WAY0_BANK0__NONE 0x0
#define BV_PXP_POWER_LUT_LP_STATE_WAY0_BANK0__LS   0x1
#define BV_PXP_POWER_LUT_LP_STATE_WAY0_BANK0__DS   0x2
#define BV_PXP_POWER_LUT_LP_STATE_WAY0_BANK0__SD   0x4

#define HW_PXP_NEXT	(0x00000400)

#define BP_PXP_NEXT_POINTER	 2
#define BM_PXP_NEXT_POINTER 0xFFFFFFFC
#define BF_PXP_NEXT_POINTER(v) \
	(((v) << 2) & BM_PXP_NEXT_POINTER)
#define BM_PXP_NEXT_RSVD 0x00000002
#define BM_PXP_NEXT_ENABLED 0x00000001

#define HW_PXP_DEBUGCTRL	(0x00000410)

#define BP_PXP_DEBUGCTRL_RSVD	   12
#define BM_PXP_DEBUGCTRL_RSVD 0xFFFFF000
#define BF_PXP_DEBUGCTRL_RSVD(v) \
	(((v) << 12) & BM_PXP_DEBUGCTRL_RSVD)
#define BP_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT      8
#define BM_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT 0x00000F00
#define BF_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT(v)  \
	(((v) << 8) & BM_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT)
#define BV_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT__NONE     0x0
#define BV_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT__MISS_CNT 0x1
#define BV_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT__HIT_CNT  0x2
#define BV_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT__LAT_CNT  0x4
#define BV_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT__MAX_LAT  0x8
#define BP_PXP_DEBUGCTRL_SELECT      0
#define BM_PXP_DEBUGCTRL_SELECT 0x000000FF
#define BF_PXP_DEBUGCTRL_SELECT(v)  \
	(((v) << 0) & BM_PXP_DEBUGCTRL_SELECT)
#define BV_PXP_DEBUGCTRL_SELECT__NONE	     0x0
#define BV_PXP_DEBUGCTRL_SELECT__CTRL	     0x1
#define BV_PXP_DEBUGCTRL_SELECT__PSBUF	     0x2
#define BV_PXP_DEBUGCTRL_SELECT__PSBAX	     0x3
#define BV_PXP_DEBUGCTRL_SELECT__PSBAY	     0x4
#define BV_PXP_DEBUGCTRL_SELECT__ASBUF	     0x5
#define BV_PXP_DEBUGCTRL_SELECT__ROTATION    0x6
#define BV_PXP_DEBUGCTRL_SELECT__OUTBUF0     0x7
#define BV_PXP_DEBUGCTRL_SELECT__OUTBUF1     0x8
#define BV_PXP_DEBUGCTRL_SELECT__OUTBUF2     0x9
#define BV_PXP_DEBUGCTRL_SELECT__LUT_STAT    0x10
#define BV_PXP_DEBUGCTRL_SELECT__LUT_MISS    0x11
#define BV_PXP_DEBUGCTRL_SELECT__LUT_HIT     0x12
#define BV_PXP_DEBUGCTRL_SELECT__LUT_LAT     0x13
#define BV_PXP_DEBUGCTRL_SELECT__LUT_MAX_LAT 0x14

#define HW_PXP_DEBUG	(0x00000420)

#define BP_PXP_DEBUG_DATA      0
#define BM_PXP_DEBUG_DATA 0xFFFFFFFF
#define BF_PXP_DEBUG_DATA(v)   (v)

#define HW_PXP_VERSION	(0x00000430)

#define BP_PXP_VERSION_MAJOR	  24
#define BM_PXP_VERSION_MAJOR 0xFF000000
#define BF_PXP_VERSION_MAJOR(v) \
	(((v) << 24) & BM_PXP_VERSION_MAJOR)
#define BP_PXP_VERSION_MINOR	  16
#define BM_PXP_VERSION_MINOR 0x00FF0000
#define BF_PXP_VERSION_MINOR(v)  \
	(((v) << 16) & BM_PXP_VERSION_MINOR)
#define BP_PXP_VERSION_STEP	 0
#define BM_PXP_VERSION_STEP 0x0000FFFF
#define BF_PXP_VERSION_STEP(v)	\
	(((v) << 0) & BM_PXP_VERSION_STEP)
#endif /* __ARCH_ARM___PXP_H */
