/*
 * Copyright (c) (2011) Fluke Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/kernel.h>
#include <linux/module.h> 
#include <linux/types.h>
#include <linux/init.h>
#include <linux/of_irq.h>
#include <linux/of_platform.h>
#include <linux/printk.h>
#include <linux/platform_device.h>
#include <linux/memory.h>
#include <linux/gpio.h>
#include <linux/mtd/physmap.h>
#include <linux/workqueue.h>
#include <linux/cicada_gasgauge.h>
#include <linux/pinctrl/machine.h>

#include <linux/pwm.h>
#include <linux/pwm_backlight.h>

#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <asm/mach/time.h>
#include <asm/mach/irq.h>

#include "hardware.h"
#include "common.h"
#include "devices-imx35.h"
#include "hardware.h"
#include "iomux-mx35.h"
#include "ehci.h"

/* the GPU disable fuse is in fuse bank 0 */
#define MX35_FUSE_GPUD_ADDR	0x0008
#define MX35_FUSE_GPUD_BIT	0x10
int cicada_is_cpu_imx353(void)
{
	u8 bVal = __raw_readb(MX35_IO_ADDRESS(MX35_IIM_BASE_ADDR +
				0x800 + MX35_FUSE_GPUD_ADDR));
	return ((bVal & MX35_FUSE_GPUD_BIT) ? 1 : 0);
}
EXPORT_SYMBOL(cicada_is_cpu_imx353);

/* the unique ID is fuse bank 0 and is 64 bits long*/
#define MX35_FUSE_UID_ADDR	0x0020
#define MX35_FUSE_UID_COUNT	8
u64 cicada_cpu_uid(void)
{
	int i;
	union {
		u8 bytes[MX35_FUSE_UID_COUNT];
		u64 word;
	} retcode;

	u32 addr = MX35_IIM_BASE_ADDR + 0x800 + MX35_FUSE_UID_ADDR;

	retcode.word = 0;

	/* fetch the unique ID fuse data using direct addressing method */
	for (i = 0; i < MX35_FUSE_UID_COUNT; i++) {
		retcode.bytes[i] =  __raw_readb(MX35_IO_ADDRESS(addr));
		addr += 4;
	}

	return retcode.word;
}
EXPORT_SYMBOL(cicada_cpu_uid);

/*
 * FEC hardware address (mac)
 */
#define FEC_ADDR_LOW		0x0e4 /* Low 32bits MAC address */
#define FEC_ADDR_HIGH		0x0e8 /* High 16bits MAC address */
static int __init fec_mac_setup(char *new_mac)
{
	void __iomem *base = MX35_IO_ADDRESS(MX35_FEC_BASE_ADDR);
	unsigned char buffer[6];
	char *ptr, *p = new_mac;
	int i = 0;

	while (p && (*p) && i < 6) {
		ptr = strchr(p, ':');
		if (ptr)
			*ptr++ = '\0';

		if (strlen(p)) {
			unsigned long tmp = simple_strtoul(p, NULL, 16);
			if (tmp > 0xff)
				break;
			buffer[i++] = tmp;
		}
		p = ptr;
	}

	writel(buffer[3] | (buffer[2] << 8) | (buffer[1] << 16) | (buffer[0] << 24),
		base + FEC_ADDR_LOW);
	writel((buffer[5] << 16) | (buffer[4] << 24),
		base + FEC_ADDR_HIGH);
/*
	__raw_writel(buffer[3] | (buffer[2] << 8) | (buffer[1] << 16) | (buffer[0] << 24),
		base + FEC_ADDR_LOW);
	__raw_writel((buffer[5] << 16) | (buffer[4] << 24),
		base + FEC_ADDR_HIGH);
*/
	return 0;
}

__setup("fec_mac=", fec_mac_setup);

/*
 * usb, otg, UTMI
 */
/*
static int cicada_otg_init(struct platform_device *pdev)
{
	return mx35_initialize_usb_hw(pdev->id, MXC_EHCI_INTERNAL_PHY);
}
*/

static const struct fsl_usb2_platform_data otg_device_pdata __initconst = {
/*	.init           = cicada_otg_init, */
	.operating_mode = FSL_USB2_DR_DEVICE,
/*	.operating_mode = FSL_USB2_DR_OTG, */
	.phy_mode       = FSL_USB2_PHY_UTMI,
	.workaround	= FLS_USB2_WORKAROUND_ENGCM09152,
};

/*
 * usb, host 2, ULPI, isp1504 phy
 */
static int cicada_usbh1_init(struct platform_device *pdev)
{
	return mx35_initialize_usb_hw(pdev->id,
		MXC_EHCI_INTERFACE_SINGLE_UNI | MXC_EHCI_IPPUE_DOWN);
}

static const struct mxc_usbh_platform_data usb_host_pdata __initconst = {
	.init	= cicada_usbh1_init,
	.portsc	= MXC_EHCI_MODE_ULPI,
};

static void __init cicada_board_init(void)
{
	struct device *parent = NULL;

//	mxc_arch_reset_init_dt();

#if 1
	parent = imx_soc_device_init();
	if (parent == NULL)
		pr_warn("failed to initialize soc device\n");
#endif

	of_platform_populate(NULL, of_default_bus_match_table, NULL, parent);

	pinctrl_provide_dummies();

	imx35_add_imx2_wdt();

	imx35_add_ipu_core();

	/* usb otg */
#if 1
pr_debug("*** %s, imx35_add_mxc_ehci_hs\n", __func__);
	/* usb not host mode */
#if 0
	imx35_add_mxc_ehci_hs(&usb_host_pdata);
#else
	{
		const struct mxc_usbh_platform_data pdata = {
			.init	= cicada_usbh1_init,
			.portsc	= MXC_EHCI_MODE_ULPI,
		};

		struct resource res[] = {
			{
				.start = MX35_USB_HS_BASE_ADDR,
				.end = MX35_USB_HS_BASE_ADDR + SZ_512 - 1,
				.flags = IORESOURCE_MEM,
			}, {
				.start = MX35_INT_USB_HS,
				.end = MX35_INT_USB_HS,
				.flags = IORESOURCE_IRQ,
			},
		};

		struct platform_device_info pdevinfo = {
			.name = "mxc-ehci",
			.id = 1,
			.res = res,
			.num_res = ARRAY_SIZE(res),
			.data = &pdata,
			.size_data = sizeof(pdata),
			.dma_mask = DMA_BIT_MASK(32),
		};

		platform_device_register_full(&pdevinfo);
	}
#endif
#if 0
	imx35_add_fsl_usb2_udc(&otg_device_pdata);
#else
	{
		struct fsl_usb2_platform_data pdata = {
			.operating_mode = FSL_USB2_DR_DEVICE,
			.phy_mode       = FSL_USB2_PHY_UTMI,
			.workaround	= FLS_USB2_WORKAROUND_ENGCM09152,
		};

		struct resource res[] = {
			{
				.start = MX35_USB_OTG_BASE_ADDR,
				.end = MX35_USB_OTG_BASE_ADDR + SZ_512 - 1,
				.flags = IORESOURCE_MEM,
			}, {
				.start = MX35_INT_USB_OTG,
				.end = MX35_INT_USB_OTG,
				.flags = IORESOURCE_IRQ,
			},
		};

		struct platform_device_info pdevinfo = {
			.name = "imx-udc-mx27",
			.id = -1,
			.res = res,
			.num_res = ARRAY_SIZE(res),
			.data = &pdata,
			.size_data = sizeof(pdata),
			.dma_mask = DMA_BIT_MASK(32),
		};

		platform_device_register_full(&pdevinfo);
	}
#endif
#else
	/* usb host mode */
	imx35_add_mxc_ehci_otg(&otg_pdata);
	imx35_add_mxc_ehci_hs(&usb_host_pdata);
#endif
}

static void __init imx35_irq_init(void)
{
	imx_init_l2cache();
	mx35_init_irq();
}

static void __init cicada_mx35_map_io(void)
{
	mx35_map_io();
	init_dma_coherent_pool_size(SZ_4M);
}

static void __init imx35_init_machine(void)
{
	struct device *parent;
	struct device_node *np;

	parent = imx_soc_device_init();
	if (parent == NULL)
		pr_warn("failed to initialize soc device\n");

	imx35_add_imx2_wdt();

	of_platform_populate(NULL, of_default_bus_match_table, NULL, NULL);
	np = of_find_compatible_node(NULL, NULL, "fsl,imx35-ipu");
	if (of_device_is_available(np))
		imx35_add_ipu_core();

}

static const char * const cicada_mx35_compat[] __initconst = {
	"fnet,imx35-cicada",
	"fsl,imx35",
	NULL
};

DT_MACHINE_START(MX35_CICADA, "FNet MX35 Cicada Board")
	.atag_offset	= 0x100,
	.map_io		= cicada_mx35_map_io,
	.init_early	= imx35_init_early,
	.init_irq	= imx35_irq_init,
	.init_machine	= imx35_init_machine,
	.dt_compat	= cicada_mx35_compat,
	.restart	= mxc_restart,
MACHINE_END

